/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class TestNeo4jApiExceptions {
    private Transaction tx;
    private GraphDatabaseService graph;
    private DatabaseManagementService managementService;

    TestNeo4jApiExceptions() {
    }

    @BeforeEach
    void init() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        this.graph = this.managementService.database("neo4j");
        this.newTransaction();
    }

    @AfterEach
    void cleanUp() {
        if (this.graph != null) {
            this.rollback();
            this.managementService.shutdown();
        }
    }

    @Test
    void testNotInTransactionException() {
        Node node1 = this.tx.createNode();
        node1.setProperty("test", (Object)1);
        Node node2 = this.tx.createNode();
        Node node3 = this.tx.createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("test", (Object)11);
        this.commit();
        Assertions.assertThrows(NotInTransactionException.class, () -> node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
        Assertions.assertThrows(NotInTransactionException.class, () -> node1.setProperty("test", (Object)2));
        Assertions.assertThrows(NotInTransactionException.class, () -> rel.setProperty("test", (Object)22));
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node3).delete());
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Relationship)rel).delete());
        this.newTransaction();
        Node testNode = this.tx.getNodeById(node1.getId());
        Relationship testRelationship = this.tx.getRelationshipById(rel.getId());
        Assertions.assertEquals((Object)testNode.getProperty("test"), (Object)1);
        Assertions.assertEquals((Object)testRelationship.getProperty("test"), (Object)11);
        Assertions.assertEquals((Object)testRelationship, (Object)testNode.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        testNode.delete();
        this.tx.getNodeById(node2.getId()).delete();
        testRelationship.delete();
        this.tx.getNodeById(node3.getId()).delete();
        this.rollback();
    }

    @Test
    void testNotFoundException() {
        Node node1 = this.tx.createNode();
        Node node2 = this.tx.createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        long nodeId = node1.getId();
        long relId = rel.getId();
        rel.delete();
        node2.delete();
        node1.delete();
        this.newTransaction();
        Assertions.assertThrows(NotFoundException.class, () -> this.tx.getNodeById(nodeId));
        Assertions.assertThrows(NotFoundException.class, () -> this.tx.getRelationshipById(relId));
        this.rollback();
    }

    @Test
    void shouldGiveNiceErrorWhenShutdownKernelApi() {
        GraphDatabaseService graphDb = this.graph;
        Node node = this.tx.createNode();
        this.commit();
        this.managementService.shutdown();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getLabels().iterator());
    }

    @Test
    void shouldGiveNiceErrorWhenShutdownLegacy() {
        GraphDatabaseService graphDb = this.graph;
        Node node = this.tx.createNode();
        this.commit();
        this.managementService.shutdown();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node).getRelationships());
    }

    private void newTransaction() {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.tx = this.graph.beginTx();
    }

    public void commit() {
        if (this.tx != null) {
            this.tx.commit();
            this.tx = null;
        }
    }

    public void rollback() {
        if (this.tx != null) {
            this.tx.close();
            this.tx = null;
        }
    }
}

