/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class DifferentIndexTypesOnSameSchemaTest
extends KernelAPIWriteTestBase<KernelAPIWriteTestSupport> {
    private static final String TOKEN = "TestToken";
    private static final String PROPERTY = "prop";

    DifferentIndexTypesOnSameSchemaTest() {
    }

    @Override
    public KernelAPIWriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    @EnumSource(value=EntityType.class)
    @ParameterizedTest
    void testNumberValueFromIndex(EntityType entityType) throws KernelException {
        long entityId;
        entityType.crateIndexes(graphDb);
        LongValue value = Values.longValue((long)1234L);
        try (KernelTransaction tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();){
            entityId = entityType.createEntity(tx, (Value)value);
            tx.commit();
        }
        tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();
        try {
            for (IndexType indexType : List.of(IndexType.BTREE, IndexType.RANGE)) {
                Assertions.assertThat(entityType.getEntitiesByPropertyValue(tx, indexType, (Value)value)).containsExactly((Object[])new Long[]{entityId});
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @EnumSource(value=EntityType.class)
    @ParameterizedTest
    void testNumberValueFromTxState(EntityType entityType) throws KernelException {
        entityType.crateIndexes(graphDb);
        LongValue value = Values.longValue((long)1234L);
        try (KernelTransaction tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();){
            long entityId = entityType.createEntity(tx, (Value)value);
            for (IndexType indexType : List.of(IndexType.BTREE, IndexType.RANGE)) {
                Assertions.assertThat(entityType.getEntitiesByPropertyValue(tx, indexType, (Value)value)).containsExactly((Object[])new Long[]{entityId});
            }
            tx.commit();
        }
    }

    @EnumSource(value=EntityType.class)
    @ParameterizedTest
    void testTextValueFromIndex(EntityType entityType) throws KernelException {
        long entityId;
        entityType.crateIndexes(graphDb);
        TextValue value = Values.stringValue((String)"Some string");
        try (KernelTransaction tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();){
            entityId = entityType.createEntity(tx, (Value)value);
            tx.commit();
        }
        tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();
        try {
            for (IndexType indexType : List.of(IndexType.BTREE, IndexType.RANGE, IndexType.TEXT)) {
                Assertions.assertThat(entityType.getEntitiesByPropertyValue(tx, indexType, (Value)value)).containsExactly((Object[])new Long[]{entityId});
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @EnumSource(value=EntityType.class)
    @ParameterizedTest
    void testTextValueFromTxState(EntityType entityType) throws KernelException {
        entityType.crateIndexes(graphDb);
        TextValue value = Values.stringValue((String)"Some string");
        try (KernelTransaction tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();){
            long entityId = entityType.createEntity(tx, (Value)value);
            for (IndexType indexType : List.of(IndexType.BTREE, IndexType.RANGE, IndexType.TEXT)) {
                Assertions.assertThat(entityType.getEntitiesByPropertyValue(tx, indexType, (Value)value)).containsExactly((Object[])new Long[]{entityId});
            }
            tx.commit();
        }
    }

    @EnumSource(value=EntityType.class)
    @ParameterizedTest
    void testPointValueFromIndex(EntityType entityType) throws KernelException {
        long entityId;
        entityType.crateIndexes(graphDb);
        PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 2.0});
        try (KernelTransaction tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();){
            entityId = entityType.createEntity(tx, (Value)value);
            tx.commit();
        }
        tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();
        try {
            for (IndexType indexType : List.of(IndexType.BTREE, IndexType.RANGE, IndexType.POINT)) {
                Assertions.assertThat(entityType.getEntitiesByPropertyValue(tx, indexType, (Value)value)).containsExactly((Object[])new Long[]{entityId});
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @EnumSource(value=EntityType.class)
    @ParameterizedTest
    void testPointValueFromTxState(EntityType entityType) throws KernelException {
        entityType.crateIndexes(graphDb);
        PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 2.0});
        try (KernelTransaction tx = DifferentIndexTypesOnSameSchemaTest.beginTransaction();){
            long entityId = entityType.createEntity(tx, (Value)value);
            for (IndexType indexType : List.of(IndexType.BTREE, IndexType.RANGE, IndexType.POINT)) {
                Assertions.assertThat(entityType.getEntitiesByPropertyValue(tx, indexType, (Value)value)).containsExactly((Object[])new Long[]{entityId});
            }
            tx.commit();
        }
    }

    private static String nameForType(IndexType indexType) {
        return indexType + "-IDX";
    }

    private static enum EntityType {
        NODE{

            @Override
            void crateIndexes(GraphDatabaseService db) {
                try (Transaction tx = db.beginTx();){
                    List.of(IndexType.BTREE, IndexType.RANGE, IndexType.TEXT, IndexType.POINT).forEach(indexType -> tx.schema().indexFor(Label.label((String)DifferentIndexTypesOnSameSchemaTest.TOKEN)).on(DifferentIndexTypesOnSameSchemaTest.PROPERTY).withName(DifferentIndexTypesOnSameSchemaTest.nameForType(indexType)).withIndexType(indexType).create());
                    tx.commit();
                }
                tx = db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            List<Long> getEntitiesByPropertyValue(KernelTransaction tx, IndexType indexType, Value value) throws KernelException {
                IndexReadSession indexSession = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(DifferentIndexTypesOnSameSchemaTest.nameForType(indexType)));
                org.junit.jupiter.api.Assertions.assertEquals((Object)DifferentIndexTypesOnSameSchemaTest.nameForType(indexType), (Object)indexSession.reference().getName());
                int property = tx.token().propertyKey(DifferentIndexTypesOnSameSchemaTest.PROPERTY);
                try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(CursorContext.NULL, tx.memoryTracker());){
                    tx.dataRead().nodeIndexSeek(tx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)property, (Object)value)});
                    ArrayList<Long> hits = new ArrayList<Long>();
                    while (cursor.next()) {
                        hits.add(cursor.nodeReference());
                    }
                    ArrayList<Long> arrayList = hits;
                    return arrayList;
                }
            }

            @Override
            long createEntity(KernelTransaction tx, Value value) throws KernelException {
                long nodeId = tx.dataWrite().nodeCreate();
                tx.dataWrite().nodeAddLabel(nodeId, tx.token().nodeLabel(DifferentIndexTypesOnSameSchemaTest.TOKEN));
                tx.dataWrite().nodeSetProperty(nodeId, tx.token().propertyKey(DifferentIndexTypesOnSameSchemaTest.PROPERTY), value);
                return nodeId;
            }
        }
        ,
        RELATIONSHIP{

            @Override
            void crateIndexes(GraphDatabaseService db) {
                try (Transaction tx = db.beginTx();){
                    List.of(IndexType.BTREE, IndexType.RANGE, IndexType.TEXT, IndexType.POINT).forEach(indexType -> tx.schema().indexFor(RelationshipType.withName((String)DifferentIndexTypesOnSameSchemaTest.TOKEN)).on(DifferentIndexTypesOnSameSchemaTest.PROPERTY).withName(DifferentIndexTypesOnSameSchemaTest.nameForType(indexType)).withIndexType(indexType).create());
                    tx.commit();
                }
                tx = db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            List<Long> getEntitiesByPropertyValue(KernelTransaction tx, IndexType indexType, Value value) throws KernelException {
                IndexReadSession indexSession = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(DifferentIndexTypesOnSameSchemaTest.nameForType(indexType)));
                org.junit.jupiter.api.Assertions.assertEquals((Object)DifferentIndexTypesOnSameSchemaTest.nameForType(indexType), (Object)indexSession.reference().getName());
                int property = tx.token().propertyKey(DifferentIndexTypesOnSameSchemaTest.PROPERTY);
                try (RelationshipValueIndexCursor cursor = tx.cursors().allocateRelationshipValueIndexCursor(CursorContext.NULL, tx.memoryTracker());){
                    tx.dataRead().relationshipIndexSeek(tx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)property, (Object)value)});
                    ArrayList<Long> hits = new ArrayList<Long>();
                    while (cursor.next()) {
                        hits.add(cursor.relationshipReference());
                    }
                    ArrayList<Long> arrayList = hits;
                    return arrayList;
                }
            }

            @Override
            long createEntity(KernelTransaction tx, Value value) throws KernelException {
                long node1 = tx.dataWrite().nodeCreate();
                long node2 = tx.dataWrite().nodeCreate();
                long relationshipId = tx.dataWrite().relationshipCreate(node1, tx.token().relationshipType(DifferentIndexTypesOnSameSchemaTest.TOKEN), node2);
                tx.dataWrite().relationshipSetProperty(relationshipId, tx.token().propertyKey(DifferentIndexTypesOnSameSchemaTest.PROPERTY), value);
                return relationshipId;
            }
        };


        abstract void crateIndexes(GraphDatabaseService var1);

        abstract List<Long> getEntitiesByPropertyValue(KernelTransaction var1, IndexType var2, Value var3) throws KernelException;

        abstract long createEntity(KernelTransaction var1, Value var2) throws KernelException;
    }
}

