/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.PrimitiveIterator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexSeekPartitionedScanTestSuite;

class NodePropertyIndexSeekPartitionedScanTestSuite
extends PropertyIndexSeekPartitionedScanTestSuite<NodeValueIndexCursor> {
    NodePropertyIndexSeekPartitionedScanTestSuite(PropertyIndexPartitionedScanTestSuite.IndexType index) {
        super(index);
    }

    public final PartitionedScanFactories.NodePropertyIndexSeek getFactory() {
        return PartitionedScanFactories.NodePropertyIndexSeek.FACTORY;
    }

    @Nested
    class WithData
    extends PropertyIndexSeekPartitionedScanTestSuite.WithData<NodeValueIndexCursor> {
        WithData() {
            super(NodePropertyIndexSeekPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery> setupDatabase() {
            boolean numberOfLabels = true;
            int numberOfPropKeys = 2;
            int numberOfProperties = 4096;
            this.ratioForExactQuery = 0.002;
            Integer labelId = this.createTags(1, this.factory.getTokenFactory()).get(0);
            int[] propKeyIds = this.createTags(2, this.factory.getPropKeyFactory()).stream().mapToInt(i -> i).toArray();
            this.createIndexes(NodePropertyIndexSeekPartitionedScanTestSuite.this.createIndexPrototypes(labelId, propKeyIds));
            return this.createData(4096, labelId, propKeyIds);
        }

        @Override
        protected PartitionedScanTestSuite.Queries<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery> createData(int numberOfProperties, int labelId, int[] propKeyIds) {
            PropertyIndexSeekPartitionedScanTestSuite.TrackEntityIdsMatchingQuery tracking = new PropertyIndexSeekPartitionedScanTestSuite.TrackEntityIdsMatchingQuery();
            PrimitiveIterator.OfInt propValues = this.random.ints((long)numberOfProperties).iterator();
            int numberOfCreatedProperties = 0;
            try (KernelTransaction tx = this.beginTx();){
                Write write = tx.dataWrite();
                while (propValues.hasNext()) {
                    PropertyIndexPartitionedScanTestSuite.PropertyRecord[] assignedProperties = new PropertyIndexPartitionedScanTestSuite.PropertyRecord[propKeyIds.length];
                    long nodeId = write.nodeCreate();
                    if (!write.nodeAddLabel(nodeId, labelId)) continue;
                    for (int i = 0; i < propKeyIds.length; ++i) {
                        if (!propValues.hasNext()) continue;
                        PropertyIndexPartitionedScanTestSuite.PropertyRecord prop = PropertyIndexPartitionedScanTestSuite.createRandomPropertyRecord(this.random, propKeyIds[i], propValues.next());
                        write.nodeSetProperty(nodeId, prop.id, prop.value);
                        ++numberOfCreatedProperties;
                        assignedProperties[i] = prop;
                        IndexDescriptor index = this.factory.getIndex(tx, labelId, prop.id);
                        tracking.generateAndTrack(nodeId, this.shouldIncludeExactQuery(), index, prop);
                    }
                    IndexDescriptor index = this.factory.getIndex(tx, labelId, propKeyIds);
                    tracking.generateAndTrack(nodeId, this.shouldIncludeExactQuery(), index, assignedProperties);
                }
                tx.commit();
            }
            catch (Exception e) {
                throw new AssertionError("failed to create database", e);
            }
            PartitionedScanTestSuite.Queries<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery> expected = tracking.get();
            ((AbstractIntegerAssert)Assertions.assertThat((int)expected.valid.queries().size()).as("valid queries should exist", new Object[0])).isGreaterThan(0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfCreatedProperties).as("node properties created", new Object[0])).isEqualTo(numberOfProperties);
            return expected;
        }
    }

    @Nested
    class WithoutData
    extends PropertyIndexSeekPartitionedScanTestSuite.WithoutData<NodeValueIndexCursor> {
        WithoutData() {
            super(NodePropertyIndexSeekPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery> setupDatabase() {
            boolean numberOfLabels = true;
            int numberOfPropKeys = 2;
            Integer labelId = this.createTags(1, this.factory.getTokenFactory()).get(0);
            int[] propKeyIds = this.createTags(2, this.factory.getPropKeyFactory()).stream().mapToInt(i -> i).toArray();
            this.createIndexes(NodePropertyIndexSeekPartitionedScanTestSuite.this.createIndexPrototypes(labelId, propKeyIds));
            return this.emptyQueries(labelId, propKeyIds);
        }
    }
}

