/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexPartitionedScanTestSuite;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class PropertyIndexSeekPartitionedScanTestSuite<CURSOR extends Cursor>
extends PropertyIndexPartitionedScanTestSuite<PropertyKeySeekQuery, CURSOR> {
    private static final Pair<Integer, Integer> RANGE = Pair.of((Object)-1073741824, (Object)0x3FFFFFFF);

    PropertyIndexSeekPartitionedScanTestSuite(PropertyIndexPartitionedScanTestSuite.IndexType index) {
        super(index);
    }

    private static Stream<PropertyIndexQuery> queries(PropertyIndexPartitionedScanTestSuite.PropertyRecord prop) {
        if (prop == null) {
            return Stream.of(new PropertyIndexQuery[0]);
        }
        Stream<PropertyIndexQuery> general = Stream.of(PropertyIndexQuery.allEntries(), PropertyIndexQuery.exists((int)prop.id), PropertyIndexQuery.exact((int)prop.id, (Object)prop.value), PropertyIndexQuery.range((int)prop.id, (Value)prop.type.toValue((Integer)RANGE.first()), (boolean)true, (Value)prop.type.toValue((Integer)RANGE.other()), (boolean)false));
        Stream<PropertyIndexQuery.StringPredicate> text = Stream.of(PropertyIndexQuery.stringPrefix((int)prop.id, (TextValue)Values.utf8Value((String)"1")), PropertyIndexQuery.stringSuffix((int)prop.id, (TextValue)Values.utf8Value((String)"1")), PropertyIndexQuery.stringContains((int)prop.id, (TextValue)Values.utf8Value((String)"1")));
        Stream<PropertyIndexQuery> queries = prop.type == PropertyIndexPartitionedScanTestSuite.ValueType.TEXT ? Stream.concat(general, text) : general;
        return queries.filter(query -> query.acceptsValue(prop.value));
    }

    private static Stream<PropertyIndexQuery[]> queries(PropertyIndexPartitionedScanTestSuite.PropertyRecord ... props) {
        List allSingleQueries = Arrays.stream(props).map(PropertyIndexSeekPartitionedScanTestSuite::queries).map(queries -> queries.collect(Collectors.toUnmodifiableList())).collect(Collectors.toUnmodifiableList());
        Stream<List<Object>> compositeQueries = Stream.of(List.of());
        for (List singleQueries : allSingleQueries) {
            compositeQueries = compositeQueries.flatMap(prev -> singleQueries.stream().map(extra -> {
                ArrayList<PropertyIndexQuery> prevWithExtra = new ArrayList<PropertyIndexQuery>((Collection<PropertyIndexQuery>)prev);
                prevWithExtra.add((PropertyIndexQuery)extra);
                return prevWithExtra;
            }));
        }
        return compositeQueries.map(compositeQuery -> (PropertyIndexQuery[])compositeQuery.toArray(PropertyIndexQuery[]::new));
    }

    protected static final class PropertyKeySeekQuery
    implements PartitionedScanTestSuite.Query<PropertyIndexQuery[]> {
        private final String indexName;
        private final PropertyIndexQuery[] queries;

        PropertyKeySeekQuery(String indexName, PropertyIndexQuery ... queries) {
            this.indexName = indexName;
            this.queries = queries;
        }

        @Override
        public String indexName() {
            return this.indexName;
        }

        @Override
        public PropertyIndexQuery[] get() {
            return this.queries;
        }

        public PropertyIndexQuery get(int i) {
            return this.queries[i];
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyKeySeekQuery that = (PropertyKeySeekQuery)obj;
            return Objects.equals(this.indexName, that.indexName) && Arrays.equals(this.queries, that.queries);
        }

        public int hashCode() {
            int result = Objects.hash(this.indexName);
            result = 31 * result + Arrays.hashCode(this.queries);
            return result;
        }

        public String toString() {
            return String.format("%s[index='%s', query='%s']", this.getClass().getSimpleName(), this.indexName, Arrays.stream(this.queries).map(PropertyIndexQuery::toString).collect(Collectors.joining(",")));
        }
    }

    protected static final class TrackEntityIdsMatchingQuery {
        private final PartitionedScanTestSuite.EntityIdsMatchingQuery<PropertyKeySeekQuery> tracking = new PartitionedScanTestSuite.EntityIdsMatchingQuery();
        private final PartitionedScanTestSuite.EntityIdsMatchingQuery<PropertyKeySeekQuery> included = new PartitionedScanTestSuite.EntityIdsMatchingQuery();
        private final Set<PropertyKeySeekQuery> invalid = new HashSet<PropertyKeySeekQuery>();

        protected TrackEntityIdsMatchingQuery() {
        }

        PartitionedScanTestSuite.Queries<PropertyKeySeekQuery> get() {
            return new PartitionedScanTestSuite.Queries<PropertyKeySeekQuery>(this.included, Collections.unmodifiableSet(this.invalid));
        }

        void generateAndTrack(long nodeId, boolean includeExactQueries, IndexDescriptor index, PropertyIndexPartitionedScanTestSuite.PropertyRecord ... props) {
            Map<Boolean, List<PropertyKeySeekQuery>> validQueries = PropertyIndexSeekPartitionedScanTestSuite.queries(props).map(queries -> new PropertyKeySeekQuery(index.getName(), (PropertyIndexQuery)queries)).collect(Collectors.partitioningBy(query -> index.getCapability().supportPartitionedScan((IndexQuery[])query.get())));
            validQueries.get(true).stream().map(query -> this.add(nodeId, (PropertyKeySeekQuery)query)).filter(query -> Arrays.stream(query.get()).noneMatch(PropertyIndexQuery.ExactPredicate.class::isInstance) || includeExactQueries).forEach(this::include);
            this.invalid.addAll((Collection<PropertyKeySeekQuery>)validQueries.get(false));
        }

        private PropertyKeySeekQuery add(long nodeId, PropertyKeySeekQuery query) {
            this.tracking.getOrCreate(query).add(nodeId);
            return query;
        }

        private void include(PropertyKeySeekQuery propertyKeySeekQuery) {
            this.included.addOrReplace(propertyKeySeekQuery, this.tracking.getOrCreate(propertyKeySeekQuery));
        }
    }

    static abstract class WithData<CURSOR extends Cursor>
    extends PropertyIndexPartitionedScanTestSuite.WithData<PropertyKeySeekQuery, CURSOR> {
        protected double ratioForExactQuery;

        WithData(PropertyIndexSeekPartitionedScanTestSuite<CURSOR> testSuite) {
            super(testSuite);
        }

        protected boolean shouldIncludeExactQuery() {
            return this.random.nextDouble() < this.ratioForExactQuery;
        }
    }

    static abstract class WithoutData<CURSOR extends Cursor>
    extends PropertyIndexPartitionedScanTestSuite.WithoutData<PropertyKeySeekQuery, CURSOR> {
        WithoutData(PropertyIndexSeekPartitionedScanTestSuite<CURSOR> testSuite) {
            super(testSuite);
        }

        protected PartitionedScanTestSuite.Queries<PropertyKeySeekQuery> emptyQueries(int tokenId, int[] propKeyIds) {
            PartitionedScanTestSuite.Queries<PropertyKeySeekQuery> queries;
            block8: {
                KernelTransaction tx = this.beginTx();
                try {
                    Map<Boolean, List<PropertyKeySeekQuery>> validQueries = Stream.concat(Arrays.stream(propKeyIds).boxed().flatMap(propKeyId -> Arrays.stream(PropertyIndexPartitionedScanTestSuite.ValueType.values()).map(type -> new PropertyIndexPartitionedScanTestSuite.PropertyRecord((int)propKeyId, type.toValue(0), (PropertyIndexPartitionedScanTestSuite.ValueType)((Object)((Object)type))))).flatMap(prop -> PropertyIndexSeekPartitionedScanTestSuite.queries(prop).map(query -> new PropertyKeySeekQuery(this.factory.getIndexName(tokenId, prop.id), (PropertyIndexQuery)query))), PropertyIndexSeekPartitionedScanTestSuite.queries((PropertyIndexPartitionedScanTestSuite.PropertyRecord[])Arrays.stream(propKeyIds).mapToObj(propKeyId -> PropertyIndexPartitionedScanTestSuite.createRandomPropertyRecord(this.random, propKeyId, 0)).toArray(PropertyIndexPartitionedScanTestSuite.PropertyRecord[]::new)).map(query -> new PropertyKeySeekQuery(this.factory.getIndexName(tokenId, propKeyIds), (PropertyIndexQuery)query))).collect(Collectors.partitioningBy(query -> this.factory.getIndex(tx, query.indexName()).getCapability().supportPartitionedScan((IndexQuery[])query.get())));
                    queries = new PartitionedScanTestSuite.Queries<PropertyKeySeekQuery>(validQueries.get(true).stream().collect(PartitionedScanTestSuite.EntityIdsMatchingQuery.collector()), validQueries.get(false).stream().collect(Collectors.toUnmodifiableSet()));
                    if (tx == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new AssertionError("failed to create empty queries", e);
                    }
                }
                tx.close();
            }
            return queries;
        }
    }
}

