/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.TokenIndexScanPartitionedScanTestSuite;

class RelationshipTypeIndexScanPartitionedScanTestSuite
extends TokenIndexScanPartitionedScanTestSuite<RelationshipTypeIndexCursor> {
    RelationshipTypeIndexScanPartitionedScanTestSuite() {
    }

    public final PartitionedScanFactories.RelationshipTypeIndexScan getFactory() {
        return PartitionedScanFactories.RelationshipTypeIndexScan.FACTORY;
    }

    @Nested
    class WithData
    extends TokenIndexScanPartitionedScanTestSuite.WithData<RelationshipTypeIndexCursor> {
        WithData() {
            super(RelationshipTypeIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            int numberOfRelTypes = 3;
            int numberOfRelationships = 100000;
            List<Integer> relTypeIds = this.createTags(3, PartitionedScanFactories.RelationshipType.FACTORY);
            return this.createData(100000, relTypeIds);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> createData(int numberOfRelationships, List<Integer> relTypeIds) {
            PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> relsWithRelTypeId = new PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>();
            String indexName = this.getTokenIndexName(EntityType.RELATIONSHIP);
            float selfRelRatio = 0.1f;
            int numberOfNodes = numberOfRelationships / 10;
            int denseNodeNumberOfRels = 64;
            int numberOfDenseNodes = numberOfRelationships / 64 / 100;
            try (KernelTransaction tx = this.beginTx();){
                Write write = tx.dataWrite();
                long[] nodeIds = LongStream.generate(() -> ((Write)write).nodeCreate()).limit(numberOfNodes).toArray();
                int relationshipsToCreate = numberOfRelationships;
                for (int i = 0; relationshipsToCreate > 0 && i < numberOfDenseNodes; ++i) {
                    long denseNodeId = this.random.among(nodeIds);
                    for (int j = 0; relationshipsToCreate > 0 && j < 64; --relationshipsToCreate, ++j) {
                        long otherNodeId = this.random.nextFloat() < 0.1f ? denseNodeId : this.random.among(nodeIds);
                        boolean forward = this.random.nextBoolean();
                        long sourceNodeId = forward ? denseNodeId : otherNodeId;
                        long targetNodeId = forward ? otherNodeId : denseNodeId;
                        Integer relTypeId = (Integer)this.random.among(relTypeIds);
                        long relId = write.relationshipCreate(sourceNodeId, relTypeId.intValue(), targetNodeId);
                        relsWithRelTypeId.getOrCreate(new TokenIndexScanPartitionedScanTestSuite.TokenScanQuery(indexName, new TokenPredicate(relTypeId.intValue()))).add(relId);
                    }
                }
                while (relationshipsToCreate > 0) {
                    Integer relTypeId = (Integer)this.random.among(relTypeIds);
                    long sourceNodeId = this.random.among(nodeIds);
                    long targetNodeId = this.random.nextFloat() < 0.1f ? sourceNodeId : this.random.among(nodeIds);
                    long relId = write.relationshipCreate(sourceNodeId, relTypeId.intValue(), targetNodeId);
                    relsWithRelTypeId.getOrCreate(new TokenIndexScanPartitionedScanTestSuite.TokenScanQuery(indexName, new TokenPredicate(relTypeId.intValue()))).add(relId);
                    --relationshipsToCreate;
                }
                tx.commit();
            }
            catch (Exception e) {
                throw new AssertionError("failed to create database", e);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)relsWithRelTypeId.queries().size()).as("valid queries should exist", new Object[0])).isGreaterThan(0);
            int numberOfCreatedRels = 0;
            for (Map.Entry entry : relsWithRelTypeId) {
                numberOfCreatedRels += entry.getValue().size();
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfCreatedRels).as("relationships created", new Object[0])).isEqualTo(numberOfRelationships);
            return new PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>(relsWithRelTypeId);
        }
    }

    @Nested
    class WithoutData
    extends TokenIndexScanPartitionedScanTestSuite.WithoutData<RelationshipTypeIndexCursor> {
        WithoutData() {
            super(RelationshipTypeIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            int numberOfRelTypes = 3;
            List<Integer> relTypeIds = this.createTags(3, PartitionedScanFactories.RelationshipType.FACTORY);
            return this.emptyQueries(EntityType.RELATIONSHIP, relTypeIds);
        }
    }
}

