/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.index;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.ProxyableIterableAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.function.checked.ThrowingFunction;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.kernel.impl.newapi.index.EntityParams;
import org.neo4j.kernel.impl.newapi.index.NodeParams;
import org.neo4j.kernel.impl.newapi.index.RelationshipParams;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class EntityValueIndexCursorLimitedIndexTest {
    EntityValueIndexCursorLimitedIndexTest() {
    }

    private static Stream<Value> numbers() {
        return Stream.of(-999, -99, 99, 999).map(Values::of);
    }

    @ExtendWith(value={SoftAssertionsExtension.class})
    static abstract class Entity<ENTITY_VALUE_INDEX_CURSOR extends Cursor & ValueIndexCursor>
    extends KernelAPIReadTestBase<ReadTestSupport> {
        private static final String ENTITY_TOKEN = "EntityToken";
        private static final String PROPERTY_KEY = "PropKey";
        private static final String INDEX_NAME = "Index";
        private final IndexSuite suite;
        private final EntityParams<ENTITY_VALUE_INDEX_CURSOR> entityParams;
        private Set<Long> validCommittedEntityIds;
        private Set<Long> invalidCommittedEntityIds;
        @InjectSoftAssertions
        private SoftAssertions softly;

        Entity(IndexSuite suite, EntityParams<ENTITY_VALUE_INDEX_CURSOR> entityParams) {
            this.suite = suite;
            this.entityParams = entityParams;
        }

        @Override
        public ReadTestSupport newTestSupport() {
            return new ReadTestSupport();
        }

        @Override
        public void createTestGraph(GraphDatabaseService db) {
            try (Transaction tx = db.beginTx();){
                this.entityParams.createEntityIndex(tx, ENTITY_TOKEN, PROPERTY_KEY, INDEX_NAME, this.suite.type);
                tx.commit();
            }
            try (KernelTransaction ktx = Entity.beginTransaction();){
                this.validCommittedEntityIds = this.createEntitiesWithProp(ktx, this.suite.validValues());
                this.invalidCommittedEntityIds = this.createEntitiesWithProp(ktx, this.suite.invalidValues());
                ktx.commit();
            }
            catch (Exception e) {
                throw new AssertionError("failed to create graph", e);
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        @Test
        final void scanWithoutTxStateShouldOnlyReturnCommitedValidValuesForIndex() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, this.validCommittedEntityIds, "should find only expected committed entries");
            }
        }

        @Test
        final void scanWithValidTxStateShouldOnlyReturnValidCommitedValuesAndStateForIndex() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                HashSet<Long> expected = new HashSet<Long>(this.validCommittedEntityIds);
                expected.addAll(this.createEntitiesWithProp(tx, this.suite.validValues()));
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, expected, "should find both committed entries, and the valid state entries");
            }
        }

        @Test
        final void scanWithInvalidTxStateShouldOnlyReturnValidCommitedValuesForIndex() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                this.createEntitiesWithProp(tx, this.suite.invalidValues());
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, this.validCommittedEntityIds, "should find only committed entries");
            }
        }

        @Test
        final void scanWithValid2ValidChangeTxStateShouldOnlyReturnValidCommitedValuesForIndexWithChange() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                ArrayDeque<Long> commitedPool = new ArrayDeque<Long>(this.validCommittedEntityIds);
                this.changePropValue(tx, commitedPool.removeLast(), this.suite.validValues().findFirst().orElseThrow());
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, this.validCommittedEntityIds, "should find commited entries, including the changed entry");
            }
        }

        @Test
        final void scanWithValid2InvalidChangeTxStateShouldOnlyReturnValidCommitedValuesForIndexWithoutChange() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                ArrayDeque<Long> commitedPool = new ArrayDeque<Long>(this.validCommittedEntityIds);
                this.changePropValue(tx, commitedPool.removeLast(), this.suite.invalidValues().findFirst().orElseThrow());
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, commitedPool, "should find commited entries, without the changed entry");
            }
        }

        @Test
        final void scanWithInvalid2ValidChangeTxStateShouldOnlyReturnValidCommitedValuesForIndexWithChange() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                HashSet<Long> expected = new HashSet<Long>(this.validCommittedEntityIds);
                ArrayDeque<Long> commitedPool = new ArrayDeque<Long>(this.invalidCommittedEntityIds);
                expected.add(this.changePropValue(tx, commitedPool.removeLast(), this.suite.validValues().findFirst().orElseThrow()));
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, expected, "should find commited entries, including the changed entry");
            }
        }

        @Test
        final void scanWithInvalid2InvalidChangeTxStateShouldOnlyReturnValidCommitedValuesForIndexWithoutChange() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                ArrayDeque<Long> commitedPool = new ArrayDeque<Long>(this.invalidCommittedEntityIds);
                this.changePropValue(tx, commitedPool.removeLast(), this.suite.invalidValues().findFirst().orElseThrow());
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, this.validCommittedEntityIds, "should find commited entries, without the changed entry");
            }
        }

        @Test
        final void scanWithRemovedValidTxStateShouldOnlyReturnValidCommitedValuesForIndexWithoutRemoved() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                ArrayDeque<Long> commitedPool = new ArrayDeque<Long>(this.validCommittedEntityIds);
                this.removeEntity(tx, commitedPool.removeLast());
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, commitedPool, "should find commited entries, without the removed entry");
            }
        }

        @Test
        final void scanWithRemovedInvalidTxStateShouldOnlyReturnValidCommitedValuesForIndexWithoutRemoved() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                ArrayDeque<Long> commitedPool = new ArrayDeque<Long>(this.invalidCommittedEntityIds);
                this.removeEntity(tx, commitedPool.removeLast());
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, this.validCommittedEntityIds, "should find commited entries, without the removed entry");
            }
        }

        @Test
        final void scanWithComplexTxStateShouldOnlyReturnValidCommitedAndStateForIndex() throws KernelException {
            try (KernelTransaction tx = Entity.beginTransaction();
                 ENTITY_VALUE_INDEX_CURSOR entities = this.entityParams.allocateEntityValueIndexCursor(tx, tx.cursors());){
                HashSet<Long> expected = new HashSet<Long>(this.validCommittedEntityIds);
                ArrayDeque<Long> validCommitedPool = new ArrayDeque<Long>(this.validCommittedEntityIds);
                ArrayDeque<Long> invalidCommitedPool = new ArrayDeque<Long>(this.invalidCommittedEntityIds);
                expected.addAll(this.createEntitiesWithProp(tx, this.suite.validValues()));
                this.createEntitiesWithProp(tx, this.suite.invalidValues());
                this.changePropValue(tx, validCommitedPool.removeLast(), this.suite.validValues().findFirst().orElseThrow());
                expected.remove(this.changePropValue(tx, validCommitedPool.removeLast(), this.suite.invalidValues().findFirst().orElseThrow()));
                expected.add(this.changePropValue(tx, invalidCommitedPool.removeLast(), this.suite.validValues().findFirst().orElseThrow()));
                this.changePropValue(tx, invalidCommitedPool.removeLast(), this.suite.invalidValues().findFirst().orElseThrow());
                expected.remove(this.removeEntity(tx, validCommitedPool.removeLast()));
                this.removeEntity(tx, invalidCommitedPool.removeLast());
                this.assertThatIndexScanContainsExactlyInAnyOrderElementsOf(tx, entities, expected, "should find all valid entries");
            }
        }

        private long createEntityWithProp(KernelTransaction tx, Value value) throws KernelException {
            int tokenId = this.entityParams.entityTokenId(tx, ENTITY_TOKEN);
            int propKeyId = tx.tokenWrite().propertyKeyGetOrCreateForName(PROPERTY_KEY);
            long entityId = this.entityParams.entityCreateNew(tx, tokenId);
            this.entityParams.entitySetProperty(tx, entityId, propKeyId, value);
            return entityId;
        }

        private Set<Long> createEntitiesWithProp(KernelTransaction tx, Stream<Value> values) {
            return values.map(Functions.throwing((ThrowingFunction & Serializable)value -> this.createEntityWithProp(tx, (Value)value))).collect(Collectors.toUnmodifiableSet());
        }

        private long changePropValue(KernelTransaction tx, long entityId, Value value) throws KernelException {
            int propKeyId = tx.tokenWrite().propertyKeyGetOrCreateForName(PROPERTY_KEY);
            this.entityParams.entitySetProperty(tx, entityId, propKeyId, value);
            return entityId;
        }

        private long removeEntity(KernelTransaction tx, long entityId) throws KernelException {
            this.entityParams.entityDelete(tx, entityId);
            return entityId;
        }

        private void assertThatIndexScanContainsExactlyInAnyOrderElementsOf(KernelTransaction tx, ENTITY_VALUE_INDEX_CURSOR entities, Iterable<Long> expected, String description) throws KernelException {
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            IndexReadSession session = tx.dataRead().indexReadSession(index);
            this.entityParams.entityIndexScan(tx, session, entities, IndexQueryConstraints.unconstrained());
            HashSet<Long> found = new HashSet<Long>();
            while (entities.next()) {
                found.add(this.entityParams.entityReference(entities));
            }
            ((ProxyableIterableAssert)this.softly.assertThat(found).as(description, new Object[0])).containsExactlyInAnyOrderElementsOf(expected);
        }
    }

    static abstract class IndexSuite {
        private final IndexType type;

        IndexSuite(IndexType type) {
            this.type = type;
        }

        protected abstract Stream<Value> validValues();

        protected abstract Stream<Value> invalidValues();

        @Nested
        final class Relationship
        extends Entity<RelationshipValueIndexCursor> {
            Relationship() {
                super(IndexSuite.this, new RelationshipParams());
            }
        }

        @Nested
        final class Node
        extends Entity<NodeValueIndexCursor> {
            Node() {
                super(IndexSuite.this, new NodeParams());
            }
        }
    }

    @Nested
    final class Text
    extends IndexSuite {
        Text() {
            super(IndexType.TEXT);
        }

        @Override
        protected Stream<Value> validValues() {
            return Stream.of("abc", "def", "uvw", "xyz").map(Values::of);
        }

        @Override
        protected Stream<Value> invalidValues() {
            return EntityValueIndexCursorLimitedIndexTest.numbers();
        }
    }

    @Nested
    final class Point
    extends IndexSuite {
        Point() {
            super(IndexType.POINT);
        }

        @Override
        protected Stream<Value> validValues() {
            return Stream.of(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-122.322312, 37.563437}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.994807, 55.612088}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-0.101008, 51.503773}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{11.572188, 48.135813}));
        }

        @Override
        protected Stream<Value> invalidValues() {
            return EntityValueIndexCursorLimitedIndexTest.numbers();
        }
    }
}

