/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.config.MEMORY_TRACKING;
import org.neo4j.cypher.internal.config.MemoryTracking;
import org.neo4j.cypher.internal.runtime.memory.MemoryTrackerForOperatorProvider;
import org.neo4j.cypher.internal.runtime.memory.QueryMemoryTracker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.FacadeKernelTransactionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.HeapHighWaterMarkTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.QueryId;
import org.neo4j.procedure.builtin.TransactionId;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@ImpermanentDbmsExtension
class Neo4jTransactionalContextIT {
    @Inject
    private GraphDatabaseAPI graphOps;
    @Inject
    private GraphDatabaseQueryService graph;
    private KernelTransactionFactory transactionFactory;

    Neo4jTransactionalContextIT() {
    }

    private long getPageCacheHits(TransactionalContext ctx) {
        return ctx.transaction().kernelTransaction().executionStatistics().pageHits();
    }

    private long getPageCacheFaults(TransactionalContext ctx) {
        return ctx.transaction().kernelTransaction().executionStatistics().pageFaults();
    }

    private void generatePageCacheHits(TransactionalContext ctx) {
        long previousCacheHits = this.getPageCacheHits(ctx);
        ctx.transaction().getAllNodes().iterator().stream().count();
        long laterCacheHits = this.getPageCacheHits(ctx);
        MatcherAssert.assertThat((String)"Assuming generatePageCacheHits to generate some page cache hits", (Object)laterCacheHits, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(previousCacheHits)));
    }

    private void getLocks(TransactionalContext ctx, String label) {
        ctx.transaction().findNodes(Label.label((String)label)).stream().forEach(Node::delete);
    }

    private long getActiveLockCount(TransactionalContext ctx) {
        return ((KernelStatement)ctx.statement()).locks().activeLockCount();
    }

    private boolean isMarkedForTermination(TransactionalContext ctx) {
        return ctx.transaction().terminationReason().isPresent();
    }

    private TransactionalContext createTransactionContext(InternalTransaction transaction) {
        return Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory).newContext(transaction, "no query", VirtualValues.EMPTY_MAP);
    }

    @BeforeEach
    void setup() {
        this.transactionFactory = new FacadeKernelTransactionFactory(Config.newBuilder().build(), (GraphDatabaseFacade)this.graphOps);
    }

    @Test
    void nestedQueriesWithExceptionsShouldCleanUpProperly() throws KernelException {
        ((GlobalProcedures)this.graphOps.getDependencyResolver().resolveDependency(GlobalProcedures.class)).registerProcedure(Procedures.class);
        InternalTransaction tx = this.graph.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        QueryExecutionException exception = (QueryExecutionException)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> tx.execute("CREATE (c) WITH c CALL test.failingProc()"));
        this.assertNoSuppressedExceptions((Throwable)exception);
        this.assertAllCauses((Throwable)exception, e -> e.getMessage().contains("/ by zero"));
    }

    private void assertAllCauses(Throwable t, Predicate<Throwable> predicate) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)predicate.test(t), (String)("Predicate failed on " + t));
        if (t.getCause() != null) {
            this.assertAllCauses(t.getCause(), predicate);
        }
    }

    private void assertNoSuppressedExceptions(Throwable t) {
        if (t.getSuppressed().length > 0) {
            org.junit.jupiter.api.Assertions.fail((String)("Expected no suppressed exceptions. Got: " + Arrays.toString(t.getSuppressed())));
        }
        if (t.getCause() != null) {
            this.assertNoSuppressedExceptions(t.getCause());
        }
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldUseOuterTransactionIdAndQueryText() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        String queryText = "<query text>";
        TransactionalContext outerCtx = Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory).newContext(outerTx, queryText, MapValue.EMPTY);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        MatcherAssert.assertThat((Object)executingQuery, (Matcher)Matchers.sameInstance((Object)innerCtx.executingQuery()));
        MatcherAssert.assertThat((Object)executingQuery.rawQueryText(), (Matcher)Matchers.equalTo((Object)queryText));
        QuerySnapshot snapshot = executingQuery.snapshot();
        MatcherAssert.assertThat((Object)snapshot.transactionId(), (Matcher)Matchers.equalTo((Object)outerTx.kernelTransaction().getUserTransactionId()));
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpPageHitsFaultsFromInnerAndOuterTransaction() {
        this.graphOps.executeTransactionally("CREATE (n)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(innerCtx);
        long innerHits = this.getPageCacheHits(innerCtx);
        long innerFaults = this.getPageCacheFaults(innerCtx);
        QuerySnapshot snapshot = executingQuery.snapshot();
        MatcherAssert.assertThat((Object)snapshot.pageHits(), (Matcher)Matchers.equalTo((Object)(outerHits + innerHits)));
        MatcherAssert.assertThat((Object)snapshot.pageFaults(), (Matcher)Matchers.equalTo((Object)(outerFaults + innerFaults)));
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpPageHitsFaultsFromInnerAndOuterTransactionsAlsoWhenCommitted() {
        this.graphOps.executeTransactionally("CREATE (n)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        long closedInnerHits = 0L;
        long closedInnerFaults = 0L;
        for (int i = 0; i < 10; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            if (i % 2 == 0) {
                this.generatePageCacheHits(innerCtx);
            }
            closedInnerHits += this.getPageCacheHits(innerCtx);
            closedInnerFaults += this.getPageCacheFaults(innerCtx);
            innerCtx.close();
            innerCtx.transaction().commit();
        }
        TransactionalContext openInnerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(openInnerCtx);
        long openInnerHits = this.getPageCacheHits(openInnerCtx);
        long openInnerFaults = this.getPageCacheFaults(openInnerCtx);
        QuerySnapshot snapshot = executingQuery.snapshot();
        MatcherAssert.assertThat((Object)snapshot.pageHits(), (Matcher)Matchers.equalTo((Object)(outerHits + closedInnerHits + openInnerHits)));
        MatcherAssert.assertThat((Object)snapshot.pageFaults(), (Matcher)Matchers.equalTo((Object)(outerFaults + closedInnerFaults + openInnerFaults)));
    }

    @Test
    void contextWithNewTransactionKernelStatisticsProviderShouldOnlySeePageHitsFaultsFromCurrentTransactionsInPROFILE() {
        this.graphOps.executeTransactionally("CREATE (n)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        for (int i = 0; i < 10; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            if (i % 2 == 0) {
                this.generatePageCacheHits(innerCtx);
            }
            innerCtx.close();
            innerCtx.transaction().commit();
        }
        TransactionalContext openInnerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(openInnerCtx);
        long openInnerHits = this.getPageCacheHits(openInnerCtx);
        long openInnerFaults = this.getPageCacheFaults(openInnerCtx);
        StatisticProvider outerProfileStatisticsProvider = outerCtx.kernelStatisticProvider();
        StatisticProvider innerProfileStatisticsProvider = openInnerCtx.kernelStatisticProvider();
        MatcherAssert.assertThat((Object)outerProfileStatisticsProvider.getPageCacheHits(), (Matcher)Matchers.equalTo((Object)outerHits));
        MatcherAssert.assertThat((Object)outerProfileStatisticsProvider.getPageCacheMisses(), (Matcher)Matchers.equalTo((Object)outerFaults));
        MatcherAssert.assertThat((Object)innerProfileStatisticsProvider.getPageCacheHits(), (Matcher)Matchers.equalTo((Object)openInnerHits));
        MatcherAssert.assertThat((Object)innerProfileStatisticsProvider.getPageCacheMisses(), (Matcher)Matchers.equalTo((Object)openInnerFaults));
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpPageHitsFaultsFromInnerAndOuterTransactionsAlsoWhenRolledBack() {
        this.graphOps.executeTransactionally("CREATE (n)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        long closedInnerHits = 0L;
        long closedInnerFaults = 0L;
        for (int i = 0; i < 10; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            if (i % 2 == 0) {
                this.generatePageCacheHits(innerCtx);
            }
            closedInnerHits += this.getPageCacheHits(innerCtx);
            closedInnerFaults += this.getPageCacheFaults(innerCtx);
            innerCtx.rollback();
        }
        TransactionalContext openInnerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(openInnerCtx);
        long openInnerHits = this.getPageCacheHits(openInnerCtx);
        long openInnerFaults = this.getPageCacheFaults(openInnerCtx);
        QuerySnapshot snapshot = executingQuery.snapshot();
        MatcherAssert.assertThat((Object)snapshot.pageHits(), (Matcher)Matchers.equalTo((Object)(outerHits + closedInnerHits + openInnerHits)));
        MatcherAssert.assertThat((Object)snapshot.pageFaults(), (Matcher)Matchers.equalTo((Object)(outerFaults + closedInnerFaults + openInnerFaults)));
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpActiveLocksFromOpenInnerAndOuterTransactions() {
        this.graphOps.executeTransactionally("CREATE (:A), (:B), (:C)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.getLocks(outerCtx, "A");
        long outerActiveLocks = this.getActiveLockCount(outerCtx);
        TransactionalContext openInnerCtx1 = outerCtx.contextWithNewTransaction();
        this.getLocks(openInnerCtx1, "B");
        long innerActiveLocks1 = this.getActiveLockCount(openInnerCtx1);
        TransactionalContext openInnerCtx2 = outerCtx.contextWithNewTransaction();
        this.getLocks(openInnerCtx2, "C");
        long innerActiveLocks2 = this.getActiveLockCount(openInnerCtx2);
        QuerySnapshot snapshot = executingQuery.snapshot();
        MatcherAssert.assertThat((Object)outerActiveLocks, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)innerActiveLocks1, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)innerActiveLocks2, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)snapshot.activeLockCount(), (Matcher)Matchers.equalTo((Object)(outerActiveLocks + innerActiveLocks1 + innerActiveLocks2)));
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpActiveLocksFromOpenInnerAndOuterTransactionsButNotFromClosedTransactions() {
        this.graphOps.executeTransactionally("CREATE (:A), (:B), (:C), (:D)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.getLocks(outerCtx, "A");
        long outerActiveLocks = this.getActiveLockCount(outerCtx);
        TransactionalContext innerCtxAbort = outerCtx.contextWithNewTransaction();
        this.getLocks(innerCtxAbort, "B");
        long closedInnerActiveLocksAbort = this.getActiveLockCount(innerCtxAbort);
        innerCtxAbort.rollback();
        TransactionalContext innerCtxCommit = outerCtx.contextWithNewTransaction();
        this.getLocks(innerCtxCommit, "C");
        long closedInnerActiveLocksCommit = this.getActiveLockCount(innerCtxCommit);
        innerCtxCommit.close();
        innerCtxCommit.transaction().commit();
        TransactionalContext innerCtxOpen = outerCtx.contextWithNewTransaction();
        this.getLocks(innerCtxOpen, "D");
        long openInnerActiveLocks = this.getActiveLockCount(innerCtxOpen);
        QuerySnapshot snapshot = executingQuery.snapshot();
        MatcherAssert.assertThat((Object)outerActiveLocks, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)closedInnerActiveLocksAbort, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)closedInnerActiveLocksCommit, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)openInnerActiveLocks, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)snapshot.activeLockCount(), (Matcher)Matchers.equalTo((Object)(outerActiveLocks + openInnerActiveLocks)));
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldCalculateHighWaterMarkMemoryUsageAlsoWhenCommittedInQuerySnapshot() {
        long openHighWaterMark = 3L;
        long outerHighWaterMark = 10L;
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        MemoryTracker outerTxMemoryTracker = outerTx.kernelTransaction().memoryTracker();
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        QueryMemoryTracker queryMemoryTracker = QueryMemoryTracker.apply((MemoryTracking)MEMORY_TRACKING.instance());
        MemoryTrackerForOperatorProvider outerTxMemoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider(outerTxMemoryTracker);
        int operatorId = 0;
        LocalMemoryTracker localMem = new LocalMemoryTracker();
        HeapTrackingArrayList ga = HeapTrackingArrayList.newArrayList((MemoryTracker)localMem);
        ga.add(new Object());
        long growingArraySize = localMem.heapHighWaterMark();
        executingQuery.onObfuscatorReady(QueryObfuscator.PASSTHROUGH);
        executingQuery.onCompilationCompleted(null, null, null);
        executingQuery.onExecutionStarted((HeapHighWaterMarkTracker)queryMemoryTracker);
        outerTxMemoryTrackerForOperatorProvider.memoryTrackerForOperator(operatorId).allocateHeap(outerHighWaterMark);
        long innerHighWaterMark = 0L;
        for (int i = 0; i < 10; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            MemoryTracker innerTxMemoryTracker = innerCtx.kernelTransaction().memoryTracker();
            MemoryTrackerForOperatorProvider innerTxMemoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider(innerTxMemoryTracker);
            MemoryTracker operatorMemoryTracker = innerTxMemoryTrackerForOperatorProvider.memoryTrackerForOperator(operatorId);
            int accHighWaterMark = 0;
            if (i % 2 == 0) {
                operatorMemoryTracker.allocateHeap((long)i);
                operatorMemoryTracker.releaseHeap((long)i);
                accHighWaterMark = i;
            }
            innerCtx.close();
            innerCtx.transaction().commit();
            innerHighWaterMark = Math.max(innerHighWaterMark, (long)accHighWaterMark);
        }
        TransactionalContext openCtx = outerCtx.contextWithNewTransaction();
        MemoryTracker openTxMemoryTracker = openCtx.kernelTransaction().memoryTracker();
        MemoryTrackerForOperatorProvider innerTxMemoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider(openTxMemoryTracker);
        innerTxMemoryTrackerForOperatorProvider.memoryTrackerForOperator(operatorId).allocateHeap(openHighWaterMark);
        QuerySnapshot snapshot = executingQuery.snapshot();
        long snapshotBytes = snapshot.allocatedBytes();
        long profilingBytes = queryMemoryTracker.heapHighWaterMark();
        MatcherAssert.assertThat((Object)snapshotBytes, (Matcher)Matchers.equalTo((Object)(growingArraySize + outerHighWaterMark + Math.max(innerHighWaterMark, openHighWaterMark))));
        MatcherAssert.assertThat((Object)profilingBytes, (Matcher)Matchers.equalTo((Object)snapshotBytes));
    }

    @Test
    void contextWithNewTransactionThrowsAfterTransactionTerminate() {
        InternalTransaction tx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(tx);
        tx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionTerminatedException.class, () -> ((TransactionalContext)ctx).contextWithNewTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    void contextWithNewTransactionThrowsAfterTransactionTerminateRace() throws ExecutionException, InterruptedException {
        KernelTransactions ktxs = (KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class);
        try (OtherThreadExecutor otherThreadExecutor = new OtherThreadExecutor("");){
            for (int i = 0; i < 100; ++i) {
                try (InternalTransaction tx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                    TransactionalContext ctx = this.createTransactionContext(tx);
                    BinaryLatch latch = new BinaryLatch();
                    Future future = otherThreadExecutor.executeDontWait(() -> {
                        latch.release();
                        tx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
                        return null;
                    });
                    latch.await();
                    try {
                        TransactionalContext newContext = ctx.contextWithNewTransaction();
                        newContext.transaction().close();
                        newContext.close();
                    }
                    catch (TransactionTerminatedException transactionTerminatedException) {
                    }
                    finally {
                        future.get();
                        ctx.close();
                    }
                }
                Assertions.assertThat((int)ktxs.getNumberOfActiveTransactions()).isZero();
            }
            return;
        }
    }

    @Test
    void contextWithNewTransactionTerminateInnerTransactionOnOuterTransactionTerminate() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        ctx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isMarkedForTermination(innerCtx));
    }

    @Test
    void contextWithNewTransactionDeregisterInnerTransactionOnInnerContextCommit() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.close();
        innerCtx.transaction().commit();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.hasInnerTransaction(ctx));
    }

    @Test
    void contextWithNewTransactionDeregisterInnerTransactionOnInnerContextRollback() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.rollback();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.hasInnerTransaction(ctx));
    }

    @Test
    void contextWithNewTransactionDeregisterInnerTransactionOnInnerContextClose() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.transaction().close();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.hasInnerTransaction(ctx));
    }

    private boolean hasInnerTransaction(TransactionalContext ctx) {
        KernelTransactions kernelTransactions = (KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class);
        KernelTransaction kernelTransaction = ctx.kernelTransaction();
        long transactionCountOnCurrentQuery = kernelTransactions.executingTransactions().stream().flatMap(handle -> handle.executingQuery().stream().map(ExecutingQuery::snapshot).map(QuerySnapshot::transactionId).filter(txnId -> txnId.longValue() == kernelTransaction.getUserTransactionId())).count();
        return transactionCountOnCurrentQuery > 1L;
    }

    @Test
    void contextWithNewTransactionThrowIfInnerTransactionPresentOnOuterTransactionCommit() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        ctx.close();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((InternalTransaction)outerTx).commit());
    }

    @Test
    void contextWithNewTransactionDoesNotThrowIfInnerTransactionDeregisteredOnOuterTransactionCommit() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        innerCtx.close();
        innerTx.commit();
        ctx.close();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((InternalTransaction)outerTx).commit());
    }

    @Test
    void contextWithNewTransactionThrowOnRollbackOfTransactionWithInnerTransactions() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((InternalTransaction)outerTx).rollback());
    }

    @Disabled(value="Strictly speaking this does not need to work, but it would protect us from our own programming mistakes in Cypher")
    @Test
    void contextWithNewTransactionCloseInnerContextOnOuterContextRollback() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        ctx.rollback();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)innerCtx.isOpen());
    }

    @Test
    void contextWithNewTransactionThrowOnCloseOfTransactionWithInnerTransactions() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((InternalTransaction)outerTx).close());
    }

    @Test
    void contextWithNewTransactionDoNotTerminateOuterTransactionOnInnerTransactionTerminate() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isMarkedForTermination(ctx));
    }

    @Test
    void contextWithNewTransactionDoNotCloseOuterContextOnInnerContextRollback() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.rollback();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ctx.isOpen());
    }

    @Test
    void contextWithNewTransactionCloseInnerStatementOnInnerContextCommitClose() throws Exception {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        AutoCloseable outerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        AutoCloseable innerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        outerCtx.statement().registerCloseableResource(outerCloseable);
        innerCtx.statement().registerCloseableResource(innerCloseable);
        innerCtx.close();
        innerCtx.transaction().commit();
        ((AutoCloseable)Mockito.verify((Object)innerCloseable)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{innerCloseable});
        Mockito.verifyNoInteractions((Object[])new Object[]{outerCloseable});
    }

    @Test
    void contextWithNewTransactionCloseInnerStatementOnInnerTransactionCommitClose() throws Exception {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        AutoCloseable outerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        AutoCloseable innerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        outerCtx.statement().registerCloseableResource(outerCloseable);
        innerCtx.statement().registerCloseableResource(innerCloseable);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((InternalTransaction)innerTx).commit());
        ((AutoCloseable)Mockito.verify((Object)innerCloseable)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{innerCloseable});
        Mockito.verifyNoInteractions((Object[])new Object[]{outerCloseable});
    }

    @Test
    void contextWithNewTransactionShouldThrowIfOuterTransactionIsExplicit() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ctx.contextWithNewTransaction());
    }

    @Test
    void contextWithNewTransactionProcedureCalledFromInnerContextShouldUseInnerTransaction() throws ProcedureException {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        GlobalProcedures procsRegistry = (GlobalProcedures)this.graphOps.getDependencyResolver().resolveDependency(GlobalProcedures.class);
        ProcedureHandle txSetMetaData = procsRegistry.procedure(new QualifiedName(new String[]{"tx"}, "setMetaData"));
        int id = txSetMetaData.id();
        ProcedureCallContext procContext = new ProcedureCallContext(id, new String[0], false, "", false);
        AnyValue[] arguments = new AnyValue[]{VirtualValues.map((String[])new String[]{"foo"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"bar")})};
        innerCtx.kernelTransaction().procedures().procedureCallDbms(id, arguments, procContext);
        MatcherAssert.assertThat((Object)innerCtx.kernelTransaction().getMetaData(), (Matcher)Matchers.equalTo(Collections.singletonMap("foo", "bar")));
        MatcherAssert.assertThat((Object)ctx.kernelTransaction().getMetaData(), (Matcher)Matchers.equalTo(Collections.emptyMap()));
    }

    @Test
    void contextWithNewTransactionListTransactions() throws ProcedureException, InvalidArgumentsException {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        String queryText = "<query text>";
        TransactionalContext ctx = Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory).newContext(outerTx, queryText, MapValue.EMPTY);
        ctx.executingQuery().onObfuscatorReady(QueryObfuscator.PASSTHROUGH);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        GlobalProcedures procsRegistry = (GlobalProcedures)this.graphOps.getDependencyResolver().resolveDependency(GlobalProcedures.class);
        ProcedureHandle listTransactions = procsRegistry.procedure(new QualifiedName(new String[]{"dbms"}, "listTransactions"));
        int id = listTransactions.id();
        int transactionIdIndex = listTransactions.signature().outputSignature().indexOf(FieldSignature.outputField((String)"transactionId", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        int currentQueryIndex = listTransactions.signature().outputSignature().indexOf(FieldSignature.outputField((String)"currentQuery", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        int currentQueryIdIndex = listTransactions.signature().outputSignature().indexOf(FieldSignature.outputField((String)"currentQueryId", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        int outerTransactionIdIndex = listTransactions.signature().outputSignature().indexOf(FieldSignature.outputField((String)"outerTransactionId", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        ProcedureCallContext procContext = new ProcedureCallContext(id, new String[]{"transactionId", "currentQuery", "currentQueryId", "outerTransactionId"}, false, "", false);
        List procResult = Iterators.asList((RawIterator)innerCtx.kernelTransaction().procedures().procedureCallDbms(id, new AnyValue[0], procContext));
        DefaultValueMapper mapper = new DefaultValueMapper(innerTx);
        List transactionIds = procResult.stream().map(array -> array[transactionIdIndex].map((ValueMapper)mapper)).collect(Collectors.toUnmodifiableList());
        List currentQueries = procResult.stream().map(array -> array[currentQueryIndex].map((ValueMapper)mapper)).collect(Collectors.toUnmodifiableList());
        List currentQueryIds = procResult.stream().map(array -> array[currentQueryIdIndex].map((ValueMapper)mapper)).collect(Collectors.toUnmodifiableList());
        List outerTransactionIds = procResult.stream().map(array -> array[outerTransactionIdIndex].map((ValueMapper)mapper)).collect(Collectors.toUnmodifiableList());
        String expectedOuterTxId = new TransactionId(outerTx.getDatabaseName(), outerTx.kernelTransaction().getUserTransactionId()).toString();
        String expectedInnerTxId = new TransactionId(innerTx.getDatabaseName(), innerTx.kernelTransaction().getUserTransactionId()).toString();
        String expectedQueryId = String.format("query-%s", ctx.executingQuery().id());
        MatcherAssert.assertThat(transactionIds, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{expectedOuterTxId, expectedInnerTxId}));
        MatcherAssert.assertThat(transactionIds, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(currentQueries, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{queryText, queryText}));
        MatcherAssert.assertThat(currentQueries, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(currentQueryIds, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{expectedQueryId, expectedQueryId}));
        MatcherAssert.assertThat(currentQueryIds, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(outerTransactionIds, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{expectedOuterTxId, ""}));
        MatcherAssert.assertThat(outerTransactionIds, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    void contextWithNewTransactionListQueries() throws ProcedureException, InvalidArgumentsException {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        String queryText = "<query text>";
        TransactionalContext ctx = Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory).newContext(outerTx, queryText, MapValue.EMPTY);
        ctx.executingQuery().onObfuscatorReady(QueryObfuscator.PASSTHROUGH);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        GlobalProcedures procsRegistry = (GlobalProcedures)this.graphOps.getDependencyResolver().resolveDependency(GlobalProcedures.class);
        ProcedureHandle listQueries = procsRegistry.procedure(new QualifiedName(new String[]{"dbms"}, "listQueries"));
        int procedureId = listQueries.id();
        int transactionIdIndex = listQueries.signature().outputSignature().indexOf(FieldSignature.outputField((String)"transactionId", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        int queryIndex = listQueries.signature().outputSignature().indexOf(FieldSignature.outputField((String)"query", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        int queryIdIndex = listQueries.signature().outputSignature().indexOf(FieldSignature.outputField((String)"queryId", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        ProcedureCallContext procContext = new ProcedureCallContext(procedureId, new String[]{"transactionId", "query", "queryId"}, false, "", false);
        List procResult = Iterators.asList((RawIterator)innerCtx.kernelTransaction().procedures().procedureCallDbms(procedureId, new AnyValue[0], procContext));
        DefaultValueMapper mapper = new DefaultValueMapper(innerTx);
        List transactionIds = procResult.stream().map(array -> array[transactionIdIndex].map((ValueMapper)mapper)).collect(Collectors.toUnmodifiableList());
        List queries = procResult.stream().map(array -> array[queryIndex].map((ValueMapper)mapper)).collect(Collectors.toUnmodifiableList());
        List queryIds = procResult.stream().map(array -> array[queryIdIndex].map((ValueMapper)mapper)).collect(Collectors.toUnmodifiableList());
        String expectedTransactionId = new TransactionId(outerTx.getDatabaseName(), outerTx.kernelTransaction().getUserTransactionId()).toString();
        String expectedQueryId = String.format("query-%s", ctx.executingQuery().id());
        MatcherAssert.assertThat(transactionIds, (Matcher)Matchers.equalTo(Collections.singletonList(expectedTransactionId)));
        MatcherAssert.assertThat(queries, (Matcher)Matchers.equalTo(Collections.singletonList(queryText)));
        MatcherAssert.assertThat(queryIds, (Matcher)Matchers.equalTo(Collections.singletonList(expectedQueryId)));
    }

    @Test
    void contextWithNewTransactionKillQuery() throws ProcedureException, InvalidArgumentsException {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        String queryText = "<query text>";
        TransactionalContext ctx = Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory).newContext(outerTx, queryText, MapValue.EMPTY);
        ctx.executingQuery().onObfuscatorReady(QueryObfuscator.PASSTHROUGH);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        GlobalProcedures procedureRegistry = (GlobalProcedures)this.graphOps.getDependencyResolver().resolveDependency(GlobalProcedures.class);
        ProcedureHandle listQueries = procedureRegistry.procedure(new QualifiedName(new String[]{"dbms"}, "killQuery"));
        int procedureId = listQueries.id();
        ProcedureCallContext procContext = new ProcedureCallContext(procedureId, new String[0], false, "", false);
        TextValue argument = Values.stringValue((String)new QueryId(ctx.executingQuery().internalQueryId()).toString());
        innerCtx.kernelTransaction().procedures().procedureCallDbms(procedureId, new AnyValue[]{argument}, procContext);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerTx.terminationReason().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outerTx.terminationReason().isPresent());
    }

    @Test
    void periodicCommitQueryShouldSumUpPageHitsFaultsFromFirstAndSecondTransactionInQuerySnapshot() {
        this.graphOps.executeTransactionally("CREATE (n)");
        InternalTransaction transaction = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(transaction);
        ExecutingQuery executingQuery = ctx.executingQuery();
        long closedTxHits = 0L;
        long closedTxFaults = 0L;
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                this.generatePageCacheHits(ctx);
            }
            closedTxHits += this.getPageCacheHits(ctx);
            closedTxFaults += this.getPageCacheFaults(ctx);
            ctx.commitAndRestartTx();
        }
        this.generatePageCacheHits(ctx);
        long lastHits = this.getPageCacheHits(ctx);
        long lastFaults = this.getPageCacheFaults(ctx);
        InternalTransaction lastTx = ctx.transaction();
        QuerySnapshot snapshot = executingQuery.snapshot();
        MatcherAssert.assertThat((Object)snapshot.transactionId(), (Matcher)Matchers.equalTo((Object)lastTx.kernelTransaction().getUserTransactionId()));
        MatcherAssert.assertThat((Object)snapshot.pageHits(), (Matcher)Matchers.equalTo((Object)(closedTxHits + lastHits)));
        MatcherAssert.assertThat((Object)snapshot.pageFaults(), (Matcher)Matchers.equalTo((Object)(closedTxFaults + lastFaults)));
    }

    @Test
    void periodicCommitQueryShouldSumUpPageHitsFaultsFromFirstAndSecondTransactionInPROFILE() {
        this.graphOps.executeTransactionally("CREATE (n)");
        InternalTransaction transaction = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(transaction);
        long closedTxHits = 0L;
        long closedTxFaults = 0L;
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                this.generatePageCacheHits(ctx);
            }
            closedTxHits += this.getPageCacheHits(ctx);
            closedTxFaults += this.getPageCacheFaults(ctx);
            ctx.commitAndRestartTx();
        }
        this.generatePageCacheHits(ctx);
        long lastHits = this.getPageCacheHits(ctx);
        long lastFaults = this.getPageCacheFaults(ctx);
        StatisticProvider profileStatisticsProvider = ctx.kernelStatisticProvider();
        MatcherAssert.assertThat((Object)profileStatisticsProvider.getPageCacheHits(), (Matcher)Matchers.equalTo((Object)(closedTxHits + lastHits)));
        MatcherAssert.assertThat((Object)profileStatisticsProvider.getPageCacheMisses(), (Matcher)Matchers.equalTo((Object)(closedTxFaults + lastFaults)));
    }

    @Test
    void restartingContextDoesNotLeakKernelTransaction() {
        InternalTransaction transaction = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext transactionContext = this.createTransactionContext(transaction);
        KernelTransactions kernelTransactions = (KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class);
        int initialActiveCount = kernelTransactions.getNumberOfActiveTransactions();
        for (int i = 0; i < 1024; ++i) {
            transactionContext.commitAndRestartTx();
            org.junit.jupiter.api.Assertions.assertEquals((float)initialActiveCount, (float)kernelTransactions.getNumberOfActiveTransactions(), (float)5.0f);
        }
    }

    @Test
    void periodicCommitExecutingQueryShouldBeReusedAfterRestart() {
        InternalTransaction internalTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        KernelTransaction firstKernelTx = internalTx.kernelTransaction();
        TransactionalContext ctx = this.createTransactionContext(internalTx);
        Statement firstStatement = ctx.statement();
        ExecutingQuery firstExecutingQuery = (ExecutingQuery)((KernelStatement)firstStatement).queryRegistry().executingQuery().get();
        ctx.commitAndRestartTx();
        KernelTransaction secondKernelTx = internalTx.kernelTransaction();
        Statement secondStatement = ctx.statement();
        ExecutingQuery secondExecutingQuery = (ExecutingQuery)((KernelStatement)secondStatement).queryRegistry().executingQuery().get();
        MatcherAssert.assertThat((Object)secondKernelTx, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)firstKernelTx)));
        MatcherAssert.assertThat((Object)secondStatement, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)firstStatement)));
        MatcherAssert.assertThat((Object)secondExecutingQuery, (Matcher)Matchers.sameInstance((Object)firstExecutingQuery));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstKernelTx.isOpen());
    }

    public static class Procedures {
        @Context
        public Transaction transaction;

        @Procedure(name="test.failingProc")
        public void stupidProcedure() {
            this.transaction.execute("CREATE (c {prop: 1 / 0})");
        }
    }
}

