/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;

@ExtendWith(value={SoftAssertionsExtension.class})
@PageCacheExtension
@Neo4jLayoutExtension
class CountsComputerTest {
    private static final NullLogProvider LOG_PROVIDER = NullLogProvider.getInstance();
    private static final Config CONFIG = Config.defaults();
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private RecordDatabaseLayout databaseLayout;
    private DatabaseManagementServiceBuilder dbBuilder;
    @InjectSoftAssertions
    private SoftAssertions softly;

    CountsComputerTest() {
    }

    @BeforeEach
    void setup() {
        this.dbBuilder = this.configure((DatabaseManagementServiceBuilder)new TestDatabaseManagementServiceBuilder((DatabaseLayout)this.databaseLayout).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fileSystem)).impermanent());
    }

    DatabaseManagementServiceBuilder configure(DatabaseManagementServiceBuilder builder) {
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void tracePageCacheAccessOnInitialization() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            GBPTreeCountsStore countsStore = (GBPTreeCountsStore)db.getDependencyResolver().resolveDependency(GBPTreeCountsStore.class);
            DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
            CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnInitialization"));
            countsStore.start(cursorContext, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            ((LongAssert)this.softly.assertThat(cursorTracer.pins()).as("Pins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorTracer.unpins()).as("Unpins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorTracer.hits()).as("hits", new Object[0])).isEqualTo(1L);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void skipPopulationWhenNodeAndRelationshipStoresAreEmpty() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        InvocationTrackingProgressReporter progressReporter = new InvocationTrackingProgressReporter();
        this.rebuildCounts(lastCommittedTransactionId, progressReporter);
        try (GBPTreeCountsStore store = this.createCountsStore(this.matchingBuilder(lastCommittedTransactionId));){
            store.start(CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            ((LongAssert)this.softly.assertThat(store.txId()).as("Store Transaction id", new Object[0])).isEqualTo(lastCommittedTransactionId);
            store.accept((CountsVisitor)new AssertEmptyCountStoreVisitor(), CursorContext.NULL);
        }
        ((BooleanAssert)this.softly.assertThat(progressReporter.isCompleteInvoked()).as("Complete", new Object[0])).isTrue();
        ((BooleanAssert)this.softly.assertThat(progressReporter.isStartInvoked()).as("Start", new Object[0])).isFalse();
    }

    @Test
    void shouldCreateAnEmptyCountsStoreFromAnEmptyDatabase() throws IOException {
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore(this.matchingBuilder(lastCommittedTransactionId));){
            store.start(CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            ((LongAssert)this.softly.assertThat(store.txId()).as("Store Transaction id", new Object[0])).isEqualTo(lastCommittedTransactionId);
            store.accept((CountsVisitor)new AssertEmptyCountStoreVisitor(), CursorContext.NULL);
        }
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreNodesInTheDB() throws IOException, KernelException {
        Node[] nodes;
        int[] labelIds;
        Label[] labels;
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            labels = CountsComputerTest.createLabels(4);
            labelIds = CountsComputerTest.getLabelIdsFrom(tx, labels);
            nodes = new Node[]{tx.createNode(new Label[]{labels[0]}), tx.createNode(new Label[]{labels[1]}), tx.createNode(new Label[]{labels[2]}), tx.createNode()};
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            ((LongAssert)this.softly.assertThat(store.txId()).as("Store Transaction id", new Object[0])).isEqualTo(lastCommittedTransactionId);
            ((LongAssert)this.softly.assertThat(store.nodeCount(-1, CursorContext.NULL)).as("count: ()", new Object[0])).isEqualTo((long)nodes.length);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[0], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[0]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[1], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[2], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[2]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[3], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[3]})).isEqualTo(0L);
        }
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreUnusedNodeRecordsInTheDB() throws IOException, KernelException {
        Node[] nodes;
        int[] labelIds;
        Label[] labels;
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            labels = CountsComputerTest.createLabels(4);
            labelIds = CountsComputerTest.getLabelIdsFrom(tx, labels);
            nodes = new Node[]{tx.createNode(new Label[]{labels[0]}), tx.createNode(new Label[]{labels[1]}), tx.createNode(new Label[]{labels[2]}), tx.createNode()};
            nodes[2].delete();
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            ((LongAssert)this.softly.assertThat(store.txId()).as("Store Transaction id", new Object[0])).isEqualTo(lastCommittedTransactionId);
            ((LongAssert)this.softly.assertThat(store.nodeCount(-1, CursorContext.NULL)).as("count: ()", new Object[0])).isEqualTo((long)(nodes.length - 1));
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[0], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[0]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[1], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[2], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[2]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[3], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[3]})).isEqualTo(0L);
        }
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreUnusedRelationshipRecordsInTheDB() throws IOException, KernelException {
        Relationship[] rels;
        Node[] nodes;
        int[] relTypeIds;
        RelationshipType[] relTypes;
        int[] labelIds;
        Label[] labels;
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            labels = CountsComputerTest.createLabels(4);
            labelIds = CountsComputerTest.getLabelIdsFrom(tx, labels);
            relTypes = CountsComputerTest.createRelationShipTypes(2);
            relTypeIds = CountsComputerTest.getRelTypeIdsFrom(tx, relTypes);
            nodes = new Node[]{tx.createNode(new Label[]{labels[0]}), tx.createNode(new Label[]{labels[1]})};
            rels = new Relationship[]{nodes[0].createRelationshipTo(nodes[1], relTypes[0]), nodes[1].createRelationshipTo(nodes[0], relTypes[1])};
            rels[0].delete();
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            ((LongAssert)this.softly.assertThat(store.txId()).as("Store Transaction id", new Object[0])).isEqualTo(lastCommittedTransactionId);
            ((LongAssert)this.softly.assertThat(store.nodeCount(-1, CursorContext.NULL)).as("count: ()", new Object[0])).isEqualTo((long)nodes.length);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[0], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[0]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[1], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[2], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[2]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[3], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[3]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, -1, -1, CursorContext.NULL)).as("()-[]->()", new Object[0])).isEqualTo((long)(rels.length - 1));
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[0], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[0]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[1], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[1]})).isEqualTo(1L);
        }
    }

    @Test
    void shouldCreateACountsStoreWhenThereAreNodesAndRelationshipsInTheDB() throws IOException, KernelException {
        Relationship[] rels;
        Node[] nodes;
        int[] relTypeIds;
        RelationshipType[] relTypes;
        int[] labelIds;
        Label[] labels;
        DatabaseManagementService managementService = this.dbBuilder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            labels = CountsComputerTest.createLabels(4);
            labelIds = CountsComputerTest.getLabelIdsFrom(tx, labels);
            relTypes = CountsComputerTest.createRelationShipTypes(3);
            relTypeIds = CountsComputerTest.getRelTypeIdsFrom(tx, relTypes);
            nodes = new Node[]{tx.createNode(new Label[]{labels[0]}), tx.createNode(new Label[]{labels[1]}), tx.createNode(new Label[]{labels[2]}), tx.createNode()};
            rels = new Relationship[]{nodes[0].createRelationshipTo(nodes[2], relTypes[0]), nodes[3].createRelationshipTo(nodes[1], relTypes[1])};
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            ((LongAssert)this.softly.assertThat(store.txId()).as("Store Transaction id", new Object[0])).isEqualTo(lastCommittedTransactionId);
            ((LongAssert)this.softly.assertThat(store.nodeCount(-1, CursorContext.NULL)).as("count: ()", new Object[0])).isEqualTo((long)nodes.length);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[0], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[0]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[1], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[2], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[2]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[3], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[3]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, -1, -1, CursorContext.NULL)).as("()-[]->()", new Object[0])).isEqualTo((long)rels.length);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[0], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[0]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[1], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[2], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[2]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[1], labelIds[1], CursorContext.NULL)).as("count: ()-[:%s]->(:%s)", new Object[]{relTypes[1], labels[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[0], labelIds[1], CursorContext.NULL)).as("count: ()-[:%s]->(:%s)", new Object[]{relTypes[0], labels[1]})).isEqualTo(0L);
        }
    }

    @Test
    void shouldCreateACountStoreWhenDBContainsDenseNodes() throws IOException, KernelException {
        Relationship[] rels;
        Node[] nodes;
        int[] relTypeIds;
        RelationshipType[] relTypes;
        int[] labelIds;
        Label[] labels;
        DatabaseManagementService managementService = this.dbBuilder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)2).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            labels = CountsComputerTest.createLabels(4);
            labelIds = CountsComputerTest.getLabelIdsFrom(tx, labels);
            relTypes = CountsComputerTest.createRelationShipTypes(5);
            relTypeIds = CountsComputerTest.getRelTypeIdsFrom(tx, relTypes);
            nodes = new Node[]{tx.createNode(new Label[]{labels[0]}), tx.createNode(new Label[]{labels[1]}), tx.createNode(new Label[]{labels[2]})};
            rels = new Relationship[]{nodes[0].createRelationshipTo(nodes[0], relTypes[0]), nodes[0].createRelationshipTo(nodes[1], relTypes[1]), nodes[0].createRelationshipTo(nodes[2], relTypes[2]), nodes[2].createRelationshipTo(nodes[1], relTypes[3])};
            tx.commit();
        }
        long lastCommittedTransactionId = CountsComputerTest.getLastTxId(db);
        managementService.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (GBPTreeCountsStore store = this.createCountsStore();){
            ((LongAssert)this.softly.assertThat(store.txId()).as("Store Transaction id", new Object[0])).isEqualTo(lastCommittedTransactionId);
            ((LongAssert)this.softly.assertThat(store.nodeCount(-1, CursorContext.NULL)).as("count: ()", new Object[0])).isEqualTo((long)nodes.length);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[0], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[0]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[1], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[2], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[2]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.nodeCount(labelIds[3], CursorContext.NULL)).as("count: (:%s)", new Object[]{labels[3]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, -1, -1, CursorContext.NULL)).as("()-[]->()", new Object[0])).isEqualTo((long)rels.length);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[0], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[0]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[1], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[2], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[2]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[3], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[3]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[4], -1, CursorContext.NULL)).as("count: ()-[:%s]->()", new Object[]{relTypes[4]})).isEqualTo(0L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, relTypeIds[1], labelIds[1], CursorContext.NULL)).as("count: ()-[:%s]->(:%s)", new Object[]{relTypes[1], labels[1]})).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(-1, -1, labelIds[1], CursorContext.NULL)).as("count: ()-[]->(:%s)", new Object[]{labels[1]})).isEqualTo(2L);
            ((LongAssert)this.softly.assertThat(store.relationshipCount(labelIds[0], -1, -1, CursorContext.NULL)).as("count: (:%s)-[]->()", new Object[]{labels[0]})).isEqualTo(3L);
        }
    }

    private static Label[] createLabels(int n) {
        return (Label[])IntStream.range(0, n).mapToObj(i -> "Label" + i).map(Label::label).toArray(Label[]::new);
    }

    private static int[] getLabelIdsFrom(Transaction tx, Label ... labels) throws KernelException {
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        TokenWrite tokenWrite = ktx.tokenWrite();
        int[] ids = new int[labels.length];
        tokenWrite.relationshipTypeGetOrCreateForNames((String[])Arrays.stream(labels).map(Label::name).toArray(String[]::new), ids);
        return ids;
    }

    private static RelationshipType[] createRelationShipTypes(int n) {
        return (RelationshipType[])IntStream.range(0, n).mapToObj(i -> "TYPE" + i).map(RelationshipType::withName).toArray(RelationshipType[]::new);
    }

    private static int[] getRelTypeIdsFrom(Transaction tx, RelationshipType ... types) throws KernelException {
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        TokenWrite tokenWrite = ktx.tokenWrite();
        int[] ids = new int[types.length];
        tokenWrite.relationshipTypeGetOrCreateForNames((String[])Arrays.stream(types).map(RelationshipType::name).toArray(String[]::new), ids);
        return ids;
    }

    private Path countsStoreFile() {
        return this.databaseLayout.countStore();
    }

    private static long getLastTxId(GraphDatabaseAPI db) {
        return ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }

    private void cleanupCountsForRebuilding() throws IOException {
        this.fileSystem.deleteFile(this.countsStoreFile());
    }

    private GBPTreeCountsStore createCountsStore() throws IOException {
        return this.createCountsStore(CountsBuilder.EMPTY);
    }

    private GBPTreeCountsStore createCountsStore(CountsBuilder builder) throws IOException {
        return new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.immediate(), builder, DatabaseReadOnlyChecker.writable(), PageCacheTracer.NULL, GBPTreeCountsStore.NO_MONITOR, this.databaseLayout.getDatabaseName(), 1000, (LogProvider)NullLogProvider.getInstance());
    }

    private void rebuildCounts(long lastCommittedTransactionId) throws IOException {
        this.rebuildCounts(lastCommittedTransactionId, ProgressReporter.SILENT);
    }

    private void rebuildCounts(long lastCommittedTransactionId, ProgressReporter progressReporter) throws IOException {
        this.cleanupCountsForRebuilding();
        DefaultIdGeneratorFactory idGenFactory = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate(), this.databaseLayout.getDatabaseName());
        StoreFactory storeFactory = new StoreFactory((DatabaseLayout)this.databaseLayout, CONFIG, (IdGeneratorFactory)idGenFactory, this.pageCache, this.fileSystem, (LogProvider)LOG_PROVIDER, PageCacheTracer.NULL, DatabaseReadOnlyChecker.writable());
        try (NeoStores neoStores = storeFactory.openAllNeoStores();){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
            int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
            CountsComputer countsComputer = new CountsComputer(neoStores, lastCommittedTransactionId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId, NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, (DatabaseLayout)this.databaseLayout, progressReporter, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            try (GBPTreeCountsStore countsStore = this.createCountsStore((CountsBuilder)countsComputer);){
                countsStore.start(CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                countsStore.checkpoint(CursorContext.NULL);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private CountsBuilder matchingBuilder(final long lastCommittedTransactionId) {
        return new CountsBuilder(){

            public void initialize(CountsAccessor.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                throw new UnsupportedOperationException("Expected a matching transaction ID " + lastCommittedTransactionId);
            }

            public long lastCommittedTxId() {
                return lastCommittedTransactionId;
            }
        };
    }

    private static class InvocationTrackingProgressReporter
    implements ProgressReporter {
        private boolean startInvoked;
        private boolean completeInvoked;

        private InvocationTrackingProgressReporter() {
        }

        public void start(long max) {
            this.startInvoked = true;
        }

        public void progress(long add) {
        }

        public void completed() {
            this.completeInvoked = true;
        }

        boolean isStartInvoked() {
            return this.startInvoked;
        }

        boolean isCompleteInvoked() {
            return this.completeInvoked;
        }
    }

    private class AssertEmptyCountStoreVisitor
    extends CountsVisitor.Adapter {
        private AssertEmptyCountStoreVisitor() {
        }

        public void visitNodeCount(int labelId, long count) {
            ((LongAssert)CountsComputerTest.this.softly.assertThat(count).as("count: (%d)", new Object[]{labelId})).isEqualTo(0L);
        }

        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            ((LongAssert)CountsComputerTest.this.softly.assertThat(count).as("count: (%d)-[%d]->(%d)", new Object[]{startLabelId, typeId, endLabelId})).isEqualTo(0L);
        }
    }
}

