/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvents;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class PartialTransactionFailureIT {
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;

    PartialTransactionFailureIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void concurrentlyCommittingTransactionsMustNotRotateOutLoggedCommandsOfFailingTransaction() throws Exception {
        Node d;
        Node c;
        Node b;
        Node a;
        ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, false), new Class[]{Command.RelationshipCommand.class});
        adversary.disable();
        Path storeDir = this.testDirectory.homePath();
        Map<Setting, String> params = Map.of(GraphDatabaseSettings.pagecache_memory, "8m");
        this.managementService = new TestDatabaseManagementServiceBuilder(storeDir).setFileSystem((FileSystemAbstraction)new AdversarialFileSystemAbstraction((Adversary)adversary)).setConfig(params).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            a = tx.createNode();
            b = tx.createNode();
            c = tx.createNode();
            d = tx.createNode();
            tx.commit();
        }
        adversary.enable();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t1 = new Thread(PartialTransactionFailureIT.createRelationship(db, a, b, latch), "T1");
        Thread t2 = new Thread(PartialTransactionFailureIT.createRelationship(db, c, d, latch), "T2");
        t1.start();
        t2.start();
        t1.join(10L);
        t2.join(10L);
        latch.countDown();
        t1.join(25000L);
        t2.join(25000L);
        this.managementService.shutdown();
        this.managementService = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(params).build();
        GraphDatabaseService database = this.managementService.database("neo4j");
        try (Transaction tx = database.beginTx();){
            Relationship rel;
            Node x = tx.getNodeById(a.getId());
            Node y = tx.getNodeById(b.getId());
            Node z = tx.getNodeById(c.getId());
            Node w = tx.getNodeById(d.getId());
            Iterator itrRelX = x.getRelationships().iterator();
            Iterator itrRelY = y.getRelationships().iterator();
            Iterator itrRelZ = z.getRelationships().iterator();
            Iterator itrRelW = w.getRelationships().iterator();
            if (itrRelX.hasNext() != itrRelY.hasNext()) {
                Assertions.fail((String)"Node x and y have inconsistent relationship counts");
            } else if (itrRelX.hasNext()) {
                rel = (Relationship)itrRelX.next();
                Assertions.assertEquals((Object)rel, itrRelY.next());
                Assertions.assertFalse((boolean)itrRelX.hasNext());
                Assertions.assertFalse((boolean)itrRelY.hasNext());
            }
            if (itrRelZ.hasNext() != itrRelW.hasNext()) {
                Assertions.fail((String)"Node z and w have inconsistent relationship counts");
            } else if (itrRelZ.hasNext()) {
                rel = (Relationship)itrRelZ.next();
                Assertions.assertEquals((Object)rel, itrRelW.next());
                Assertions.assertFalse((boolean)itrRelZ.hasNext());
                Assertions.assertFalse((boolean)itrRelW.hasNext());
            }
        }
    }

    private static Runnable createRelationship(GraphDatabaseAPI db, Node x, Node y, CountDownLatch latch) {
        return () -> {
            try (Transaction tx = db.beginTx();){
                x.createRelationshipTo(y, RelationshipType.withName((String)"r"));
                tx.commit();
                latch.await();
                ((LogRotation)db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
                ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }
}

