/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
class LogVersionUpgradeCheckerIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    private DatabaseLayout databaseLayout;

    LogVersionUpgradeCheckerIT() {
    }

    @BeforeEach
    void setUp() {
        this.databaseLayout = DatabaseLayout.ofFlat((Path)this.testDirectory.directory("neo4j"));
    }

    @Test
    void startAsNormalWhenUpgradeIsNotAllowed() {
        this.createGraphDbAndKillIt();
        DatabaseManagementService managementService = this.startDatabaseService(false);
        managementService.database("neo4j");
        managementService.shutdown();
    }

    @Test
    void startFromOlderTransactionLogsIfAllowed() throws Exception {
        this.createStoreWithLogEntryVersion(KernelVersion.V2_3.version(), true);
        DatabaseManagementService managementService = this.startDatabaseService(true);
        managementService.database("neo4j");
        managementService.shutdown();
    }

    private void createGraphDbAndKillIt() {
        DatabaseManagementService managementService = this.startDatabaseService(false);
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"FOO")});
            tx.createNode(new Label[]{Label.label((String)"BAR")});
            tx.commit();
        }
        managementService.shutdown();
    }

    private void createStoreWithLogEntryVersion(byte logEntryVersion, boolean cleanup) throws Exception {
        this.createGraphDbAndKillIt();
        this.appendCheckpoint(logEntryVersion, cleanup);
    }

    private void appendCheckpoint(byte logEntryVersion, boolean removeCheckpointFile) throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory());
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache).withLogEntryReader((LogEntryReader)logEntryReader).withStoreId(StoreId.UNKNOWN).build();
        if (removeCheckpointFile) {
            for (Path file : this.fileSystem.listFiles(logFiles.logFilesDirectory(), path -> path.getFileName().toString().startsWith("checkpoint"))) {
                this.fileSystem.deleteFile(file);
            }
        }
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            LogFile logFile = logFiles.getLogFile();
            TransactionLogWriter transactionLogWriter = logFile.getTransactionLogWriter();
            FlushablePositionAwareChecksumChannel channel = transactionLogWriter.getChannel();
            LogPosition logPosition = transactionLogWriter.getCurrentPosition();
            channel.put(logEntryVersion).put((byte)7).putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
            logFile.flush();
        }
    }

    private DatabaseManagementService startDatabaseService(boolean allowUpgrade) {
        Path rootDirectory = this.databaseLayout.databaseDirectory().getParent();
        return new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fileSystem).impermanent().setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)rootDirectory).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)allowUpgrade).build();
    }
}

