/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryDetachedCheckpoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSets;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;

class DetachedCheckpointLogEntryParserTest {
    private final CommandReaderFactory commandReader = new TestCommandReaderFactory();
    private final LogPositionMarker positionMarker = new LogPositionMarker();

    DetachedCheckpointLogEntryParserTest() {
    }

    @Test
    void parseDetachedCheckpointRecord() throws IOException {
        KernelVersion version = KernelVersion.V4_3_D4;
        StoreId storeId = new StoreId(4L, 5L, 6L, 7L, 8L);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        int checkpointMillis = 3;
        String checkpointDescription = "checkpoint";
        byte[] bytes = Arrays.copyOf(checkpointDescription.getBytes(), 120);
        LogEntryDetachedCheckpoint checkpoint = new LogEntryDetachedCheckpoint(version, new LogPosition(1L, 2L), (long)checkpointMillis, storeId, checkpointDescription);
        channel.putLong(checkpoint.getLogPosition().getLogVersion()).putLong(checkpoint.getLogPosition().getByteOffset()).putLong((long)checkpointMillis).putLong(storeId.getCreationTime()).putLong(storeId.getRandomId()).putLong(storeId.getStoreVersion()).putLong(storeId.getUpgradeTime()).putLong(storeId.getUpgradeTxId()).putShort((short)checkpointDescription.getBytes().length).put(bytes, bytes.length);
        channel.putChecksum();
        LogEntryParser checkpointParser = LogEntryParserSets.parserSet((KernelVersion)version).select((byte)8);
        LogEntry logEntry = checkpointParser.parse(version, (ReadableChecksumChannel)channel, this.positionMarker, this.commandReader);
        Assertions.assertEquals((Object)checkpoint, (Object)logEntry);
    }
}

