/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

@ImpermanentDbmsExtension
class DefaultValueMapperTest {
    @Inject
    private GraphDatabaseService db;

    DefaultValueMapperTest() {
    }

    @Test
    void shouldHandleSingleNodePath() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Path mapped = mapper.mapPath((VirtualPathValue)VirtualValues.pathReference((VirtualNodeValue[])DefaultValueMapperTest.asNodeValues(node), (VirtualRelationshipValue[])DefaultValueMapperTest.asRelationshipsValues(new Relationship[0])));
            Assertions.assertThat((int)mapped.length()).isEqualTo(0);
            Assertions.assertThat((Object)mapped.startNode()).isEqualTo((Object)node);
            Assertions.assertThat((Object)mapped.endNode()).isEqualTo((Object)node);
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.relationships())).hasSize(0);
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.reverseRelationships())).hasSize(0);
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.nodes())).isEqualTo(Collections.singletonList(node));
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.reverseNodes())).isEqualTo(Collections.singletonList(node));
            Assertions.assertThat((Object)mapped.lastRelationship()).isNull();
            Assertions.assertThat((List)Iterators.asList((Iterator)mapped.iterator())).isEqualTo(Collections.singletonList(node));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldHandleSingleRelationshipPath() {
        Relationship relationship;
        Node end;
        Node start;
        try (Transaction tx = this.db.beginTx();){
            start = tx.createNode();
            end = tx.createNode();
            relationship = start.createRelationshipTo(end, RelationshipType.withName((String)"R"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Path mapped = mapper.mapPath((VirtualPathValue)VirtualValues.pathReference((VirtualNodeValue[])DefaultValueMapperTest.asNodeValues(start, end), (VirtualRelationshipValue[])DefaultValueMapperTest.asRelationshipsValues(relationship)));
            Assertions.assertThat((int)mapped.length()).isEqualTo(1);
            Assertions.assertThat((Object)mapped.startNode()).isEqualTo((Object)start);
            Assertions.assertThat((Object)mapped.endNode()).isEqualTo((Object)end);
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.relationships())).isEqualTo(Collections.singletonList(relationship));
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.reverseRelationships())).isEqualTo(Collections.singletonList(relationship));
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.nodes())).isEqualTo(Arrays.asList(start, end));
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.reverseNodes())).isEqualTo(Arrays.asList(end, start));
            Assertions.assertThat((Object)mapped.lastRelationship()).isEqualTo((Object)relationship);
            Assertions.assertThat((List)Iterators.asList((Iterator)mapped.iterator())).isEqualTo(Arrays.asList(start, relationship, end));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldHandleLongPath() {
        Relationship r4;
        Relationship r3;
        Relationship r2;
        Relationship r1;
        Node e;
        Node d;
        Node c;
        Node b;
        Node a;
        try (Transaction tx = this.db.beginTx();){
            a = tx.createNode();
            b = tx.createNode();
            c = tx.createNode();
            d = tx.createNode();
            e = tx.createNode();
            r1 = a.createRelationshipTo(b, RelationshipType.withName((String)"R"));
            r2 = b.createRelationshipTo(c, RelationshipType.withName((String)"R"));
            r3 = c.createRelationshipTo(d, RelationshipType.withName((String)"R"));
            r4 = d.createRelationshipTo(e, RelationshipType.withName((String)"R"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Path mapped = mapper.mapPath((VirtualPathValue)VirtualValues.pathReference((VirtualNodeValue[])DefaultValueMapperTest.asNodeValues(a, b, c, d, e), (VirtualRelationshipValue[])DefaultValueMapperTest.asRelationshipsValues(r1, r2, r3, r4)));
            Assertions.assertThat((int)mapped.length()).isEqualTo(4);
            Assertions.assertThat((Object)mapped.startNode()).isEqualTo((Object)a);
            Assertions.assertThat((Object)mapped.endNode()).isEqualTo((Object)e);
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.relationships())).isEqualTo(Arrays.asList(r1, r2, r3, r4));
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.reverseRelationships())).isEqualTo(Arrays.asList(r4, r3, r2, r1));
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.nodes())).isEqualTo(Arrays.asList(a, b, c, d, e));
            Assertions.assertThat((List)Iterables.asList((Iterable)mapped.reverseNodes())).isEqualTo(Arrays.asList(e, d, c, b, a));
            Assertions.assertThat((Object)mapped.lastRelationship()).isEqualTo((Object)r4);
            Assertions.assertThat((List)Iterators.asList((Iterator)mapped.iterator())).isEqualTo(Arrays.asList(a, r1, b, r2, c, r3, d, r4, e));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldMapDirectRelationship() {
        Relationship relationship;
        Node end;
        Node start;
        try (Transaction tx = this.db.beginTx();){
            start = tx.createNode();
            end = tx.createNode();
            relationship = start.createRelationshipTo(end, RelationshipType.withName((String)"R"));
            tx.commit();
        }
        RelationshipValue relationshipValue = VirtualValues.relationshipValue((long)relationship.getId(), (VirtualNodeValue)VirtualValues.nodeValue((long)start.getId(), (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP), (VirtualNodeValue)VirtualValues.nodeValue((long)start.getId(), (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP), (TextValue)Values.stringValue((String)"R"), (MapValue)VirtualValues.EMPTY_MAP);
        try (Transaction tx = this.db.beginTx();){
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Relationship coreAPIRelationship = mapper.mapRelationship((VirtualRelationshipValue)relationshipValue);
            Assertions.assertThat((long)coreAPIRelationship.getId()).isEqualTo(relationship.getId());
            Assertions.assertThat((Object)coreAPIRelationship.getStartNode()).isEqualTo((Object)start);
            Assertions.assertThat((Object)coreAPIRelationship.getEndNode()).isEqualTo((Object)end);
        }
    }

    private static VirtualNodeValue[] asNodeValues(Node ... nodes) {
        return (VirtualNodeValue[])Arrays.stream(nodes).map(ValueUtils::fromNodeEntity).toArray(VirtualNodeValue[]::new);
    }

    private static VirtualRelationshipValue[] asRelationshipsValues(Relationship ... relationships) {
        return (VirtualRelationshipValue[])Arrays.stream(relationships).map(ValueUtils::fromRelationshipEntity).toArray(VirtualRelationshipValue[]::new);
    }
}

