/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.proc.ProcessUtil;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class TestRecoveryRelationshipTypes {
    @Inject
    private TestDirectory testDirectory;

    TestRecoveryRelationshipTypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoverNeoAndHavingAllRelationshipTypesAfterRecovery() throws Exception {
        Path storeDir = this.testDirectory.homePath();
        Process process = ProcessUtil.start((String[])new String[]{this.getClass().getName(), storeDir.toAbsolutePath().toString()});
        Assertions.assertEquals((int)0, (int)process.waitFor());
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction transaction = db.beginTx();){
            Iterator typeResourceIterator = transaction.getAllRelationshipTypes().iterator();
            Assertions.assertEquals((Object)MyRelTypes.TEST.name(), (Object)((RelationshipType)typeResourceIterator.next()).name());
        }
        finally {
            managementService.shutdown();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.exit(1);
        }
        Path storeDir = Path.of(args[0], new String[0]).toAbsolutePath();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode().createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.commit();
        }
        CheckPointer checkPointer = (CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class);
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        System.exit(0);
    }
}

