/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Timeout;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.Cancelable;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.concurrent.Futures;

@TestDirectoryExtension
class PageCacheCountersIT {
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService db;
    private ExecutorService executors;
    private int numberOfWorkers;
    private DatabaseManagementService managementService;

    PageCacheCountersIT() {
    }

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        this.db = this.managementService.database("neo4j");
        this.numberOfWorkers = Runtime.getRuntime().availableProcessors();
        this.executors = Executors.newFixedThreadPool(this.numberOfWorkers);
    }

    @AfterEach
    void tearDown() throws InterruptedException {
        this.executors.shutdown();
        this.executors.awaitTermination(5L, TimeUnit.SECONDS);
        this.managementService.shutdown();
    }

    @RepeatedTest(value=5)
    @Timeout(value=60L)
    void pageCacheCountersAreSumOfPageCursorCounters() throws Exception {
        ArrayList<NodeCreator> nodeCreators = new ArrayList<NodeCreator>(this.numberOfWorkers);
        ArrayList nodeCreatorFutures = new ArrayList(this.numberOfWorkers);
        PageCacheTracer pageCacheTracer = PageCacheCountersIT.getPageCacheTracer(this.db);
        long initialPins = pageCacheTracer.pins();
        long initialHits = pageCacheTracer.hits();
        long initialUnpins = pageCacheTracer.unpins();
        long initialBytesRead = pageCacheTracer.bytesRead();
        long initialBytesWritten = pageCacheTracer.bytesWritten();
        long initialEvictions = pageCacheTracer.evictions();
        long initialFaults = pageCacheTracer.faults();
        long initialFlushes = pageCacheTracer.flushes();
        long initialMerges = pageCacheTracer.merges();
        this.startNodeCreators(nodeCreators, nodeCreatorFutures);
        while (pageCacheTracer.pins() == 0L || pageCacheTracer.faults() == 0L || pageCacheTracer.unpins() == 0L) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        PageCacheCountersIT.stopNodeCreators(nodeCreators, nodeCreatorFutures);
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.pins()).as("Number of pins events in page cache tracer should equal to the sum of pin events in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getPins, initialPins));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.unpins()).as("Number of unpins events in page cache tracer should equal to the sum of unpin events in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getUnpins, initialUnpins));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.bytesRead()).as("Number of initialBytesRead in page cache tracer should equal to the sum of initialBytesRead in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getBytesRead, initialBytesRead));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.bytesWritten()).as("Number of bytesWritten in page cache tracer should equal to the sum of bytesWritten in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getBytesWritten, initialBytesWritten));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.evictions()).as("Number of evictions in page cache tracer should equal to the sum of evictions in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getEvictions, initialEvictions));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.faults()).as("Number of faults in page cache tracer should equal to the sum of faults in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getFaults, initialFaults));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.flushes()).as("Number of flushes in page cache tracer should equal to the sum of flushes in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getFlushes, initialFlushes));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.merges()).as("Number of merges in page cache tracer should equal to the sum of merges in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getMerges, initialMerges));
        ((AbstractLongAssert)Assertions.assertThat((long)pageCacheTracer.hits()).as("Number of hits in page cache tracer should equal to the sum of hits in page cursor tracers.", new Object[0])).isGreaterThanOrEqualTo(PageCacheCountersIT.sumCounters(nodeCreators, NodeCreator::getHits, initialHits));
    }

    private static void stopNodeCreators(List<NodeCreator> nodeCreators, List<Future<?>> nodeCreatorFutures) throws ExecutionException {
        nodeCreators.forEach(NodeCreator::cancel);
        Futures.getAll(nodeCreatorFutures);
    }

    private void startNodeCreators(List<NodeCreator> nodeCreators, List<Future<?>> nodeCreatorFutures) {
        for (int i = 0; i < this.numberOfWorkers; ++i) {
            NodeCreator nodeCreator = new NodeCreator(this.db);
            nodeCreators.add(nodeCreator);
            nodeCreatorFutures.add(this.executors.submit(nodeCreator));
        }
    }

    private static long sumCounters(List<NodeCreator> nodeCreators, ToLongFunction<NodeCreator> mapper, long initialValue) {
        return nodeCreators.stream().mapToLong(mapper).sum() + initialValue;
    }

    private static PageCacheTracer getPageCacheTracer(GraphDatabaseService db) {
        Tracers tracers = (Tracers)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(Tracers.class);
        return tracers.getPageCacheTracer();
    }

    private static class NodeCreator
    implements Runnable,
    Cancelable {
        private volatile boolean canceled;
        private final GraphDatabaseService db;
        private long pins;
        private long unpins;
        private long hits;
        private long bytesRead;
        private long bytesWritten;
        private long evictions;
        private long faults;
        private long flushes;
        private long merges;

        NodeCreator(GraphDatabaseService db) {
            this.db = db;
        }

        @Override
        public void run() {
            ThreadLocalRandom localRandom = ThreadLocalRandom.current();
            while (!this.canceled) {
                Transaction transaction = this.db.beginTx();
                try {
                    Node node = transaction.createNode();
                    node.setProperty("name", (Object)RandomStringUtils.random((int)localRandom.nextInt(100)));
                    node.setProperty("surname", (Object)RandomStringUtils.random((int)localRandom.nextInt(100)));
                    node.setProperty("age", (Object)localRandom.nextInt(100));
                    this.storeCounters((PageCursorCounters)((InternalTransaction)transaction).kernelTransaction().cursorContext().getCursorTracer());
                    transaction.commit();
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
        }

        private void storeCounters(PageCursorCounters pageCursorCounters) {
            Objects.requireNonNull(pageCursorCounters);
            this.pins += pageCursorCounters.pins();
            this.unpins += pageCursorCounters.unpins();
            this.hits += pageCursorCounters.hits();
            this.bytesRead += pageCursorCounters.bytesRead();
            this.bytesWritten += pageCursorCounters.bytesWritten();
            this.evictions += pageCursorCounters.evictions();
            this.faults += pageCursorCounters.faults();
            this.flushes += pageCursorCounters.flushes();
            this.merges += pageCursorCounters.merges();
        }

        public void cancel() {
            this.canceled = true;
        }

        long getPins() {
            return this.pins;
        }

        long getUnpins() {
            return this.unpins;
        }

        public long getHits() {
            return this.hits;
        }

        long getBytesRead() {
            return this.bytesRead;
        }

        long getBytesWritten() {
            return this.bytesWritten;
        }

        long getEvictions() {
            return this.evictions;
        }

        long getFaults() {
            return this.faults;
        }

        long getFlushes() {
            return this.flushes;
        }

        public long getMerges() {
            return this.merges;
        }
    }
}

