/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
@ImpermanentDbmsExtension
class UpdateCreatedTokenIndexIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    DatabaseManagementService managementService;
    @Inject
    RandomSupport random;
    private static final int NODES = 100;
    private static final int SKIP_NODES = 100;

    UpdateCreatedTokenIndexIT() {
    }

    @BeforeEach
    void before() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    @RepeatedTest(value=5)
    void shouldHandleCreateNodeConcurrentlyWithIndexCreate() throws Throwable {
        this.shouldHandleIndexCreateConcurentlyWithOperation((tx, nodeId) -> tx.createNode(new Label[]{TestLabels.LABEL_ONE}));
    }

    @RepeatedTest(value=5)
    void shouldHandleRemovalOfLabelConcurrentlyWithIndexCreate() throws Throwable {
        this.shouldHandleIndexCreateConcurentlyWithOperation((tx, nodeId) -> tx.getNodeById(nodeId).removeLabel(TestLabels.LABEL_ONE));
    }

    @RepeatedTest(value=5)
    void shouldHandleDeleteNodeConcurrentlyWithIndexCreate() throws Throwable {
        this.shouldHandleIndexCreateConcurentlyWithOperation((tx, nodeId) -> tx.getNodeById(nodeId).delete());
    }

    @RepeatedTest(value=5)
    void shouldHandleNodeDetachDeleteConcurrentlyWithIndexCreate() throws Throwable {
        this.shouldHandleIndexCreateConcurentlyWithOperation((tx, nodeId) -> ((InternalTransaction)tx).kernelTransaction().dataWrite().nodeDetachDelete(nodeId));
    }

    private void shouldHandleIndexCreateConcurentlyWithOperation(NodeOperation operation) throws Throwable {
        long[] nodes = this.createNodes();
        Race race = new Race();
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("myLabelIndex").create();
                tx.commit();
            }
        }, 1);
        for (int i = 0; i < 100; ++i) {
            long nodeId = nodes[i];
            race.addContestant(Race.throwing(() -> {
                try (Transaction tx = this.db.beginTx();){
                    operation.run(tx, nodeId);
                    tx.commit();
                }
            }));
        }
        race.go();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline("myLabelIndex", 5L, TimeUnit.MINUTES);
        }
        tx = this.db.beginTx();
        try {
            long labeledNodes = tx.findNodes(TestLabels.LABEL_ONE).stream().count();
            List allNodex = tx.getAllNodes().stream().collect(Collectors.toList());
            Assertions.assertThat((long)allNodex.stream().filter(n -> n.hasLabel(TestLabels.LABEL_ONE)).count()).isEqualTo(labeledNodes);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private long[] createNodes() {
        int i;
        long[] nodesToDelete = new long[100];
        try (Transaction tx = this.db.beginTx();){
            for (int i2 = 0; i2 < 100; ++i2) {
                nodesToDelete[i2] = tx.createNode(new Label[]{TestLabels.LABEL_ONE}).getId();
            }
            tx.commit();
        }
        long[] nodes = new long[100];
        try (Transaction tx = this.db.beginTx();){
            for (i = 0; i < 100; ++i) {
                Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                nodes[i] = node.getId();
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (i = 0; i < 100; ++i) {
                tx.getNodeById(nodesToDelete[i]).delete();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return nodes;
    }

    private static interface NodeOperation {
        public void run(Transaction var1, long var2) throws Exception;
    }
}

