/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelAPIParallelStress;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;

@DbmsExtension
class KernelAPIParallelTraversalStressIT {
    private static final int N_THREADS = 10;
    private static final int N_NODES = 10000;
    private static final int N_RELATIONSHIPS = 40000;
    private static final TokenHolders tokenHolders = (TokenHolders)Mockito.mock(TokenHolders.class);
    private static final QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private static final TransactionalContextFactory contextFactory = (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class);
    private static final DatabaseAvailabilityGuard availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private Kernel kernel;

    KernelAPIParallelTraversalStressIT() {
    }

    @Test
    void shouldScanNodesAndTraverseInParallel() throws Throwable {
        KernelAPIParallelTraversalStressIT.createRandomGraph(this.kernel);
        KernelAPIParallelStress.parallelStressInTx(this.kernel, 10, tx -> new NodeAndTraverseCursors((KernelTransaction)tx, this.kernel), KernelAPIParallelTraversalStressIT::scanAndTraverse);
    }

    private static void createRandomGraph(Kernel kernel) throws Exception {
        int i;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long[] nodes = new long[10000];
        KernelTransaction setup = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        int relationshipType = setup.token().relationshipTypeCreateForName("R", false);
        for (i = 0; i < 10000; ++i) {
            nodes[i] = setup.dataWrite().nodeCreate();
            if ((i + 1) % 10000 != 0) continue;
            setup.commit();
            setup = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
            new TransactionImpl(tokenHolders, contextFactory, availabilityGuard, engine, setup, null, null);
        }
        for (i = 0; i < 40000; ++i) {
            int n1 = random.nextInt(10000);
            int n2 = random.nextInt(10000);
            while (n2 == n1) {
                n2 = random.nextInt(10000);
            }
            setup.dataWrite().relationshipCreate(nodes[n1], relationshipType, nodes[n2]);
            if ((i + 1) % 10000 != 0) continue;
            setup.commit();
            setup = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
            new TransactionImpl(tokenHolders, contextFactory, availabilityGuard, engine, setup, null, null);
        }
        setup.commit();
    }

    private static Runnable scanAndTraverse(Read read, NodeAndTraverseCursors cursors) {
        return () -> {
            try {
                read.allNodesScan(cursors.nodeCursor);
                int n = 0;
                int r = 0;
                while (cursors.nodeCursor.next()) {
                    cursors.nodeCursor.relationships(cursors.traversalCursor, RelationshipSelection.ALL_RELATIONSHIPS);
                    while (cursors.traversalCursor.next()) {
                        ++r;
                    }
                    ++n;
                }
                Assertions.assertEquals((int)10000, (int)n, (String)"correct number of nodes");
                Assertions.assertEquals((int)80000, (int)r, (String)"correct number of traversals");
            }
            finally {
                cursors.complete();
            }
        };
    }

    static class NodeAndTraverseCursors
    implements AutoCloseable {
        final NodeCursor nodeCursor;
        final RelationshipTraversalCursor traversalCursor;
        private final KernelTransaction.ExecutionContext executionContext;

        NodeAndTraverseCursors(KernelTransaction tx, Kernel kernel) {
            this.executionContext = tx.createExecutionContext();
            this.nodeCursor = kernel.cursors().allocateNodeCursor(this.executionContext.cursorContext());
            this.traversalCursor = kernel.cursors().allocateRelationshipTraversalCursor(this.executionContext.cursorContext());
        }

        @Override
        public void close() throws Exception {
            IOUtils.closeAllUnchecked((AutoCloseable[])new KernelTransaction.ExecutionContext[]{this.executionContext});
        }

        public void complete() {
            IOUtils.closeAllUnchecked((AutoCloseable[])new EntityCursor[]{this.nodeCursor, this.traversalCursor});
            this.executionContext.complete();
        }
    }
}

