/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class PropertyIT
extends KernelIntegrationTest {
    PropertyIT() {
    }

    @Test
    void shouldListAllPropertyKeys() throws Exception {
        this.dbWithNoCache();
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        Iterator propIdsBeforeCommit = transaction.tokenRead().propertyKeyGetAllTokens();
        Assertions.assertThat((Iterable)Iterators.asCollection((Iterator)propIdsBeforeCommit)).contains((Object[])new NamedToken[]{new NamedToken("prop1", prop1), new NamedToken("prop2", prop2)});
        this.commit();
        transaction = this.newTransaction();
        Iterator propIdsAfterCommit = transaction.tokenRead().propertyKeyGetAllTokens();
        Assertions.assertThat((Iterable)Iterators.asCollection((Iterator)propIdsAfterCommit)).contains((Object[])new NamedToken[]{new NamedToken("prop1", prop1), new NamedToken("prop2", prop2)});
        this.commit();
    }

    @Test
    void shouldNotAllowModifyingPropertiesOnDeletedRelationship() throws Exception {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int type = transaction.tokenWrite().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        long rel = transaction.dataWrite().relationshipCreate(startNodeId, type, endNodeId);
        transaction.dataWrite().relationshipSetProperty(rel, prop1, (Value)Values.stringValue((String)"As"));
        transaction.dataWrite().relationshipDelete(rel);
        EntityNotFoundException e = (EntityNotFoundException)org.junit.jupiter.api.Assertions.assertThrows(EntityNotFoundException.class, () -> transaction.dataWrite().relationshipRemoveProperty(rel, prop1));
        Assertions.assertThat((String)e.getMessage()).isEqualTo("Unable to load RELATIONSHIP with id " + rel + ".");
        this.commit();
    }

    @Test
    void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnRelationship() throws Exception {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int prop = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        int type = transaction.tokenWrite().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        long rel = transaction.dataWrite().relationshipCreate(startNodeId, type, endNodeId);
        transaction.dataWrite().relationshipSetProperty(rel, prop, Values.of((Object)"bar"));
        this.commit();
        Write write = this.dataWriteInNewTransaction();
        write.relationshipRemoveProperty(rel, prop);
        write.relationshipSetProperty(rel, prop, Values.of((Object)"bar"));
        write.relationshipRemoveProperty(rel, prop);
        write.relationshipRemoveProperty(rel, prop);
        this.commit();
        transaction = this.newTransaction();
        Assertions.assertThat((Object)PropertyIT.relationshipGetProperty(transaction, rel, prop)).isEqualTo((Object)Values.NO_VALUE);
        this.commit();
    }
}

