/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
public class TestExceptionTypeOnInvalidIds {
    private static final long SMALL_POSITIVE_INTEGER = 5L;
    private static final long SMALL_NEGATIVE_INTEGER = -5L;
    private static final long BIG_POSITIVE_INTEGER = Integer.MAX_VALUE;
    private static final long BIG_NEGATIVE_INTEGER = Integer.MIN_VALUE;
    private static final long SMALL_POSITIVE_LONG = 0x80000000L;
    private static final long SMALL_NEGATIVE_LONG = Integer.MAX_VALUE;
    private static final long BIG_POSITIVE_LONG = Long.MAX_VALUE;
    private static final long BIG_NEGATIVE_LONG = Long.MIN_VALUE;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService writableService;
    private DatabaseManagementService readOnlyService;
    private GraphDatabaseService writableDb;
    private GraphDatabaseService readOnlyDb;

    @BeforeEach
    void createDatabase() {
        Path writableLayout = this.testDirectory.homePath("writable");
        this.writableService = new TestDatabaseManagementServiceBuilder(writableLayout).build();
        this.writableDb = this.writableService.database("neo4j");
        Path readOnlyLayout = this.testDirectory.homePath("readOnly");
        TestDatabaseManagementServiceBuilder readOnlyBuilder = new TestDatabaseManagementServiceBuilder(readOnlyLayout);
        readOnlyBuilder.build().shutdown();
        this.readOnlyService = readOnlyBuilder.setConfig(GraphDatabaseSettings.read_only_database_default, (Object)true).build();
        this.readOnlyDb = this.readOnlyService.database("neo4j");
    }

    @AfterEach
    void destroyDatabase() {
        this.readOnlyService.shutdown();
        this.writableService.shutdown();
        this.writableDb = null;
        this.readOnlyDb = null;
    }

    private static Stream<Long> inputValues() {
        return Stream.of(5L, -5L, Integer.MAX_VALUE, Integer.MIN_VALUE, 0x80000000L, Integer.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE);
    }

    @ParameterizedTest
    @MethodSource(value={"inputValues"})
    void shouldThrowOnGetNodeByIdWithNonExistingId(long id) {
        TestExceptionTypeOnInvalidIds.getNonExistingNodeById(this.writableDb, id);
        TestExceptionTypeOnInvalidIds.getNonExistingNodeById(this.readOnlyDb, id);
    }

    @ParameterizedTest
    @MethodSource(value={"inputValues"})
    void shouldThrowOnGetRelationshipByIdWithNonExistingId(long id) {
        TestExceptionTypeOnInvalidIds.getNonExistingRelationshipById(this.writableDb, id);
        TestExceptionTypeOnInvalidIds.getNonExistingRelationshipById(this.readOnlyDb, id);
    }

    private static void getNonExistingNodeById(GraphDatabaseService db, long index) {
        try (Transaction tx = db.beginTx();){
            Assertions.assertThrows(NotFoundException.class, () -> tx.getNodeById(index));
        }
    }

    private static void getNonExistingRelationshipById(GraphDatabaseService db, long index) {
        try (Transaction tx = db.beginTx();){
            Assertions.assertThrows(NotFoundException.class, () -> tx.getRelationshipById(index));
        }
    }
}

