/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.TokenIndexOrderTestBase;

public class RelationshipTypeIndexOrderTest
extends TokenIndexOrderTestBase<RelationshipTypeIndexCursor> {
    @Override
    protected long entityWithToken(KernelTransaction tx, String name) throws Exception {
        Write write = tx.dataWrite();
        long sourceNode = write.nodeCreate();
        long targetNode = write.nodeCreate();
        return write.relationshipCreate(sourceNode, tx.tokenWrite().relationshipTypeGetOrCreateForName(name), targetNode);
    }

    @Override
    protected RelationshipTypeIndexCursor getIndexCursor(KernelTransaction tx) {
        return tx.cursors().allocateRelationshipTypeIndexCursor(tx.cursorContext());
    }

    @Override
    protected long entityReference(RelationshipTypeIndexCursor cursor) {
        return cursor.relationshipReference();
    }

    @Override
    protected void tokenScan(IndexOrder indexOrder, KernelTransaction tx, int label, RelationshipTypeIndexCursor cursor) throws KernelException {
        IndexDescriptor index = (IndexDescriptor)tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP)).next();
        TokenReadSession tokenReadSession = tx.dataRead().tokenReadSession(index);
        tx.dataRead().relationshipTypeScan(tokenReadSession, cursor, IndexQueryConstraints.ordered((IndexOrder)indexOrder), new TokenPredicate(label), tx.cursorContext());
    }

    @Override
    protected int tokenByName(KernelTransaction tx, String name) {
        return tx.tokenRead().relationshipType(name);
    }
}

