/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@DbmsExtension
class PropertyIndexPopulationIT {
    private static final Label PERSON = Label.label((String)"person");
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"friend");
    @Inject
    private TestDirectory testDir;
    @Inject
    private GraphDatabaseService db;

    PropertyIndexPopulationIT() {
    }

    @Test
    void shouldCreatePropertyIndexUsingTokenIndexes() {
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists(this.db);
        this.populateData();
        IndexDefinition propertyIndex = this.createLabelPropertyIndex();
        IndexDefinition relPropertyIndex = this.createRelationshipTypePropertyIndex();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(propertyIndex.getName(), 5L, TimeUnit.MINUTES);
            tx.schema().awaitIndexOnline(relPropertyIndex.getName(), 5L, TimeUnit.MINUTES);
            PropertyIndexPopulationIT.verifyData(tx);
        }
    }

    @Test
    void shouldCreatePropertyIndexWithoutAnyTokenIndexes() {
        IndexingTestUtil.dropAllIndexes(this.db);
        this.populateData();
        IndexDefinition relationPropertyIndex = this.createRelationshipTypePropertyIndex();
        IndexDefinition labelPropertyIndex = this.createLabelPropertyIndex();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(relationPropertyIndex.getName(), 5L, TimeUnit.MINUTES);
            tx.schema().awaitIndexOnline(labelPropertyIndex.getName(), 5L, TimeUnit.MINUTES);
            PropertyIndexPopulationIT.verifyData(tx);
        }
    }

    @Test
    void shouldCreateTokenAndPropertyIndexesInTheSameTransaction() {
        IndexDefinition relationPropertyIndex;
        IndexDefinition labelPropertyIndex;
        IndexDefinition relTypeIndex;
        IndexDefinition labelIndex;
        IndexingTestUtil.dropAllIndexes(this.db);
        this.populateData();
        try (Transaction tx = this.db.beginTx();){
            labelIndex = tx.schema().indexFor(AnyTokens.ANY_LABELS).create();
            relTypeIndex = tx.schema().indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).create();
            labelPropertyIndex = tx.schema().indexFor(PERSON).on("name").create();
            relationPropertyIndex = tx.schema().indexFor(FRIEND).on("tag").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(relTypeIndex.getName(), 5L, TimeUnit.MINUTES);
            tx.schema().awaitIndexOnline(labelIndex.getName(), 5L, TimeUnit.MINUTES);
            tx.schema().awaitIndexOnline(labelPropertyIndex.getName(), 5L, TimeUnit.MINUTES);
            tx.schema().awaitIndexOnline(relationPropertyIndex.getName(), 5L, TimeUnit.MINUTES);
            PropertyIndexPopulationIT.verifyData(tx);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void verifyData(Transaction tx) {
        Assertions.assertThat((long)tx.findNodes(PERSON).stream().count()).isEqualTo(1L);
        Assertions.assertThat((long)tx.findRelationships(FRIEND).stream().count()).isEqualTo(1L);
        Assertions.assertThat((long)tx.findNodes(PERSON, "name", (Object)"some name").stream().count()).isEqualTo(1L);
        Assertions.assertThat((long)tx.findRelationships(FRIEND, "tag", (Object)"some value").stream().count()).isEqualTo(1L);
    }

    private void populateData() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{PERSON});
            node.setProperty("name", (Object)"some name");
            Relationship relationship = node.createRelationshipTo(tx.createNode(), FRIEND);
            relationship.setProperty("tag", (Object)"some value");
            tx.commit();
        }
    }

    private IndexDefinition createLabelPropertyIndex() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition indexDefinition = tx.schema().indexFor(PERSON).on("name").create();
            tx.commit();
            IndexDefinition indexDefinition2 = indexDefinition;
            return indexDefinition2;
        }
    }

    private IndexDefinition createRelationshipTypePropertyIndex() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition indexDefinition = tx.schema().indexFor(FRIEND).on("tag").create();
            tx.commit();
            IndexDefinition indexDefinition2 = indexDefinition;
            return indexDefinition2;
        }
    }
}

