/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class PageBytesReserveIT {
    @Inject
    private TestDirectory testDirectory;

    PageBytesReserveIT() {
    }

    public static IntStream pageSizes() {
        return IntStream.of(8, 16, 24, 32, 40, 48, 64, 1024, 2048, (int)(ByteUnit.kibiBytes((long)8L) - 256L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"pageSizes"})
    void reserveBytesInPageHeader(int reservedBytes) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(GraphDatabaseInternalSettings.reserved_page_header_bytes, (Object)reservedBytes).build();
        try {
            Label testLabel = Label.label((String)"test");
            RelationshipType testRelType = RelationshipType.withName((String)"test");
            String repPropertyKey = "a";
            String nodePropertyKey = "b";
            String relProperty = RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)8L)));
            String nodeProperty = RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)8L)));
            GraphDatabaseService database = managementService.database("neo4j");
            int iterations = 1024;
            for (int i = 0; i < iterations; ++i) {
                try (Transaction transaction = database.beginTx();){
                    Node start = transaction.createNode(new Label[]{testLabel});
                    Node end = transaction.createNode(new Label[]{testLabel});
                    Relationship relationshipTo = start.createRelationshipTo(end, testRelType);
                    relationshipTo.setProperty(repPropertyKey, (Object)relProperty);
                    start.setProperty(nodePropertyKey, (Object)nodeProperty);
                    transaction.commit();
                    continue;
                }
            }
            try (Transaction transaction = database.beginTx();){
                Assertions.assertEquals((long)(2 * iterations), (long)Iterators.count((Iterator)transaction.findNodes(testLabel)));
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"pageSizes"})
    void reserveBytesInPageHeaderWithAdditionalIndexes(int reservedBytes) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(GraphDatabaseInternalSettings.reserved_page_header_bytes, (Object)reservedBytes).build();
        try {
            Label testLabel = Label.label((String)"test");
            RelationshipType testRelType = RelationshipType.withName((String)"test");
            String repPropertyKey = "a";
            String nodePropertyKey = "b";
            String relProperty = RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)7L)));
            String nodeProperty = RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)7L)));
            GraphDatabaseService database = managementService.database("neo4j");
            try (Transaction tx = database.beginTx();){
                Schema schema = tx.schema();
                schema.indexFor(testLabel).on(nodePropertyKey).withName("nodeIndex").create();
                schema.indexFor(testRelType).on(relProperty).withName("relIndex").create();
                tx.commit();
            }
            PageBytesReserveIT.awaitIndexes(database);
            int iterations = 512;
            for (int i = 0; i < iterations; ++i) {
                try (Transaction transaction = database.beginTx();){
                    Node start = transaction.createNode(new Label[]{testLabel});
                    Node end = transaction.createNode(new Label[]{testLabel});
                    Relationship relationshipTo = start.createRelationshipTo(end, testRelType);
                    relationshipTo.setProperty(repPropertyKey, (Object)relProperty);
                    start.setProperty(nodePropertyKey, (Object)nodeProperty);
                    transaction.commit();
                    continue;
                }
            }
            try (Transaction transaction = database.beginTx();){
                Assertions.assertEquals((long)(2 * iterations), (long)Iterators.count((Iterator)transaction.findNodes(testLabel)));
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    private static void awaitIndexes(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
    }
}

