/*
 * Decompiled with CFR 0.152.
 */
package synchronization;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvents;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;

@DbmsExtension(configurationCallback="configure")
@ExtendWith(value={OtherThreadExtension.class})
public class TestStartTransactionDuringLogRotation {
    @Inject
    public GraphDatabaseAPI database;
    @Inject
    private OtherThread t2;
    @Inject
    private Monitors monitors;
    private ExecutorService executor;
    private CountDownLatch startLogRotationLatch;
    private CountDownLatch completeLogRotationLatch;
    private AtomicBoolean writerStopped;
    private Label label;
    private Future<Void> rotationFuture;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.mebiBytes((long)1L));
    }

    @BeforeEach
    void setUp() throws InterruptedException {
        this.executor = Executors.newCachedThreadPool();
        this.startLogRotationLatch = new CountDownLatch(1);
        this.completeLogRotationLatch = new CountDownLatch(1);
        this.writerStopped = new AtomicBoolean();
        LogRotationMonitorAdapter rotationListener = new LogRotationMonitorAdapter(){

            public void startRotation(long currentLogVersion) {
                TestStartTransactionDuringLogRotation.this.startLogRotationLatch.countDown();
                try {
                    TestStartTransactionDuringLogRotation.this.completeLogRotationLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.monitors.addMonitorListener((Object)rotationListener, new String[0]);
        this.label = Label.label((String)"Label");
        this.rotationFuture = this.t2.execute(this.forceLogRotation(this.database));
        this.startLogRotationLatch.await();
    }

    private Callable<Void> forceLogRotation(GraphDatabaseAPI db) {
        return () -> {
            try (Transaction tx = db.beginTx();){
                tx.createNode(new Label[]{this.label}).setProperty("a", (Object)1);
                tx.commit();
            }
            ((LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class)).getLogFile().getLogRotation().rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
            return null;
        };
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.rotationFuture.get();
        this.writerStopped.set(true);
        this.executor.shutdown();
    }

    @Test
    void logRotationMustNotObstructStartingReadTransaction() {
        try (Transaction tx = this.database.beginTx();){
            tx.getNodeById(0L);
            this.completeLogRotationLatch.countDown();
            tx.commit();
        }
    }

    @Test
    void logRotationMustNotObstructStartingWriteTransaction() {
        try (Transaction tx = this.database.beginTx();){
            tx.createNode();
            this.completeLogRotationLatch.countDown();
            tx.commit();
        }
    }
}

