/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.Schema;

public enum SchemaFacadeMethods implements Consumer<Schema>
{
    INDEX_FOR_LABEL((FacadeMethod<Schema>)new FacadeMethod("IndexCreator indexFor( Label label )", s -> s.indexFor(FacadeMethod.LABEL))),
    INDEX_FOR_REL_TYPE((FacadeMethod<Schema>)new FacadeMethod("IndexCreator indexFor( RelationshipType type )", s -> s.indexFor(FacadeMethod.FOO))),
    INDEX_FOR_TOKENS((FacadeMethod<Schema>)new FacadeMethod("IndexCreator indexFor( AnyTokens tokens )", s -> s.indexFor(AnyTokens.ANY_LABELS))),
    GET_INDEXES_BY_LABEL((FacadeMethod<Schema>)new FacadeMethod("Iterable<IndexDefinition> getIndexes( Label label )", s -> s.getIndexes(FacadeMethod.LABEL))),
    GET_INDEXES_BY_REL_TYPE((FacadeMethod<Schema>)new FacadeMethod("Iterable<IndexDefinition> getIndexes( RelationshipType relationshipType )", s -> s.getIndexes(FacadeMethod.FOO))),
    GET_INDEXES((FacadeMethod<Schema>)new FacadeMethod("Iterable<IndexDefinition> getIndexes()", Schema::getIndexes)),
    GET_INDEX_STATE((FacadeMethod<Schema>)new FacadeMethod("IndexState getIndexState( IndexDefinition index )", s -> s.getIndexState(FacadeMethod.INDEX_DEFINITION))),
    GET_INDEX_FAILURE((FacadeMethod<Schema>)new FacadeMethod("String getIndexFailure( IndexDefinition index )", s -> s.getIndexFailure(FacadeMethod.INDEX_DEFINITION))),
    CONSTRAINT_FOR((FacadeMethod<Schema>)new FacadeMethod("ConstraintCreator constraintFor( Label label )", s -> s.constraintFor(FacadeMethod.LABEL))),
    GET_CONSTRAINTS_BY_LABEL((FacadeMethod<Schema>)new FacadeMethod("Iterable<ConstraintDefinition> getConstraints( Label label )", s -> s.getConstraints(FacadeMethod.LABEL))),
    GET_CONSTRAINTS((FacadeMethod<Schema>)new FacadeMethod("Iterable<ConstraintDefinition> getConstraints()", Schema::getConstraints)),
    AWAIT_INDEX_ONLINE((FacadeMethod<Schema>)new FacadeMethod("void awaitIndexOnline( IndexDefinition index, long duration, TimeUnit unit )", s -> s.awaitIndexOnline(FacadeMethod.INDEX_DEFINITION, 1L, TimeUnit.SECONDS))),
    AWAIT_INDEXES_ONLINE((FacadeMethod<Schema>)new FacadeMethod("void awaitIndexesOnline( long duration, TimeUnit unit )", s -> s.awaitIndexesOnline(1L, TimeUnit.SECONDS)));

    private final FacadeMethod<Schema> facadeMethod;

    private SchemaFacadeMethods(FacadeMethod<Schema> facadeMethod) {
        this.facadeMethod = facadeMethod;
    }

    @Override
    public void accept(Schema schema) {
        this.facadeMethod.accept((Object)schema);
    }

    public String toString() {
        return this.facadeMethod.toString();
    }
}

