/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.annotations.documented.ReporterFactories;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class SimpleIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    SimpleIndexAccessorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    @Test
    void testIndexSeekByPrefix() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apA"}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"b"})));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"a"))})).isEqualTo(Arrays.asList(1L, 3L, 4L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"A"))})).isEqualTo(Collections.singletonList(2L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"ba"))})).isEqualTo((Object)Collections.EMPTY_LIST);
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)""))})).isEqualTo(Arrays.asList(1L, 2L, 3L, 4L, 5L));
    }

    @Test
    void testIndexSeekByPrefixOnNonStrings() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"2a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{2L}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{20L})));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"2"))})).isEqualTo(Collections.singletonList(1L));
    }

    @Test
    void testIndexRangeSeekByDateTimeWithSneakyZones() throws Exception {
        DateTimeValue d1 = DateTimeValue.datetime((long)9999L, (long)100L, (ZoneId)ZoneId.of("+18:00"));
        DateTimeValue d4 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("UTC"));
        DateTimeValue d5 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+01:00"));
        DateTimeValue d6 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("Europe/Stockholm"));
        DateTimeValue d7 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+03:00"));
        DateTimeValue d8 = DateTimeValue.datetime((long)10000L, (long)101L, (ZoneId)ZoneId.of("UTC"));
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{d1}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{d4}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{d5}), IndexQueryHelper.add((long)6L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{d6}), IndexQueryHelper.add((long)7L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{d7}), IndexQueryHelper.add((long)8L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{d8})));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Value)d4, (boolean)true, (Value)d7, (boolean)true)})).containsExactly((Object[])new Long[]{4L, 5L, 6L, 7L});
    }

    @Test
    void tracePageCacheAccessOnConsistencyCheck() {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnConsistencyCheck"));){
            this.accessor.consistencyCheck(ReporterFactories.noopReporterFactory(), cursorContext);
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.faults()).isEqualTo(2L);
        }
    }

    @Test
    void testIndexRangeSeekWithSpatial() throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsSpatial());
        Assumptions.assumeTrue((boolean)this.testSuite.supportsSpatialRangeQueries());
        PointValue p1 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-180.0, -1.0});
        PointValue p2 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-180.0, 1.0});
        PointValue p3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{p1}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{p2}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{p3})));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Value)p1, (boolean)true, (Value)p2, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    void shouldUpdateWithAllValues() throws Exception {
        List<ValueIndexEntryUpdate<?>> updates = this.updates(this.valueSet1);
        this.updateAndCommit(updates);
        int propertyKeyId = this.descriptor.schema().getPropertyId();
        for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
            List<Long> result = this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
            Assertions.assertThat(result).isEqualTo(Collections.singletonList(entry.nodeId));
        }
    }

    @Test
    void shouldScanAllValues() throws Exception {
        List<ValueIndexEntryUpdate<?>> updates = this.updates(this.valueSet1);
        this.updateAndCommit(updates);
        Object[] allNodes = (Long[])this.valueSet1.stream().map(x -> x.nodeId).toArray(Long[]::new);
        List<Long> result = this.query(new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
        Assertions.assertThat(result).contains(allNodes);
    }

    @Test
    void shouldScanAllValuesThatExistWithPropKey() throws Exception {
        List<ValueIndexEntryUpdate<?>> updates = this.updates(this.valueSet1);
        this.updateAndCommit(updates);
        Object[] allNodes = (Long[])this.valueSet1.stream().map(x -> x.nodeId).toArray(Long[]::new);
        int propertyKeyId = this.descriptor.schema().getPropertyId();
        List<Long> result = this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)propertyKeyId)});
        Assertions.assertThat(result).contains(allNodes);
    }

    @Test
    void testIndexRangeSeekByNumber() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextNumberValue());
    }

    @Test
    void testIndexRangeSeekByText() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextTextValue());
    }

    @Test
    void testIndexRangeSeekByChar() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextCharValue());
    }

    @Test
    void testIndexRangeSeekByDateTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextDateTimeValue());
    }

    @Test
    void testIndexRangeSeekByLocalDateTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextLocalDateTimeValue());
    }

    @Test
    void testIndexRangeSeekByDate() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextDateValue());
    }

    @Test
    void testIndexRangeSeekByTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextTimeValue());
    }

    @Test
    void testIndexRangeSeekByLocalTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextLocalTimeValue());
    }

    @Test
    void testIndexRangeSeekByDuration() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextDuration());
    }

    @Test
    void testIndexRangeSeekByPeriod() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextPeriod());
    }

    @Test
    void testIndexRangeSeekByZonedDateTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDateTimeArray());
    }

    @Test
    void testIndexRangeSeekByLocalDateTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextLocalDateTimeArray());
    }

    @Test
    void testIndexRangeSeekByDateArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDateArray());
    }

    @Test
    void testIndexRangeSeekByZonedTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextTimeArray());
    }

    @Test
    void testIndexRangeSeekByLocalTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextLocalTimeArray());
    }

    @Test
    void testIndexRangeSeekByDurationArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDurationArray());
    }

    @Test
    void testIndexRangeSeekByTextArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextBasicMultilingualPlaneTextArray());
    }

    @Test
    void testIndexRangeSeekByCharArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextCharArray());
    }

    @Test
    void testIndexRangeSeekByBooleanArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextBooleanArray());
    }

    @Test
    void testIndexRangeSeekByByteArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextByteArray());
    }

    @Test
    void testIndexRangeSeekByShortArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextShortArray());
    }

    @Test
    void testIndexRangeSeekByIntArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextIntArray());
    }

    @Test
    void testIndexRangeSeekByLongArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextLongArray());
    }

    @Test
    void testIndexRangeSeekByFloatArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextFloatArray());
    }

    @Test
    void testIndexRangeSeekByDoubleArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDoubleArray());
    }

    private void testIndexRangeSeekArray(Supplier<ArrayValue> generator) throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries());
        this.testIndexRangeSeek(generator);
    }

    private void testIndexRangeSeek(Supplier<? extends Value> generator) throws Exception {
        int i;
        int count = this.random.nextInt(5, 10);
        ArrayList<Value> values = new ArrayList<Value>();
        ArrayList updates = new ArrayList();
        HashSet<Value> duplicateCheck = new HashSet<Value>();
        for (i = 0; i < count; ++i) {
            Value value;
            while (!duplicateCheck.add(value = generator.get())) {
            }
            values.add(value);
        }
        values.sort((Comparator<Value>)Values.COMPARATOR);
        for (i = 0; i < count; ++i) {
            updates.add(IndexQueryHelper.add((long)(i + 1), (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{values.get(i)}));
        }
        Collections.shuffle(updates);
        this.updateAndCommit(updates);
        for (int f = 0; f < values.size(); ++f) {
            for (int t = f; t < values.size(); ++t) {
                Value from = (Value)values.get(f);
                Value to = (Value)values.get(t);
                for (boolean fromInclusive : new boolean[]{true, false}) {
                    for (boolean toInclusive : new boolean[]{true, false}) {
                        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive)})).isEqualTo(SimpleIndexAccessorCompatibility.ids(f, fromInclusive, t, toInclusive));
                    }
                }
            }
        }
    }

    private static List<Long> ids(int fromIndex, boolean fromInclusive, int toIndex, boolean toInclusive) {
        ArrayList<Long> ids = new ArrayList<Long>();
        int from = fromInclusive ? fromIndex : fromIndex + 1;
        int to = toInclusive ? toIndex : toIndex - 1;
        for (int i = from; i <= to; ++i) {
            ids.add(Long.valueOf(i + 1));
        }
        return ids;
    }

    @Test
    void shouldRangeSeekInOrderAscendingNumber() throws Exception {
        Integer o0 = 0;
        Integer o1 = 1;
        Integer o2 = 2;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingNumber() throws Exception {
        Integer o0 = 0;
        Integer o1 = 1;
        Integer o2 = 2;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingString() throws Exception {
        String o0 = "0";
        String o1 = "1";
        String o2 = "2";
        String o3 = "3";
        String o4 = "4";
        String o5 = "5";
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingString() throws Exception {
        String o0 = "0";
        String o1 = "1";
        String o2 = "2";
        String o3 = "3";
        String o4 = "4";
        String o5 = "5";
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDate() throws Exception {
        LocalDate o0 = DateValue.epochDateRaw((long)0L);
        LocalDate o1 = DateValue.epochDateRaw((long)1L);
        LocalDate o2 = DateValue.epochDateRaw((long)2L);
        LocalDate o3 = DateValue.epochDateRaw((long)3L);
        LocalDate o4 = DateValue.epochDateRaw((long)4L);
        LocalDate o5 = DateValue.epochDateRaw((long)5L);
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDate() throws Exception {
        LocalDate o0 = DateValue.epochDateRaw((long)0L);
        LocalDate o1 = DateValue.epochDateRaw((long)1L);
        LocalDate o2 = DateValue.epochDateRaw((long)2L);
        LocalDate o3 = DateValue.epochDateRaw((long)3L);
        LocalDate o4 = DateValue.epochDateRaw((long)4L);
        LocalDate o5 = DateValue.epochDateRaw((long)5L);
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalTime() throws Exception {
        LocalTime o0 = LocalTimeValue.localTimeRaw((long)0L);
        LocalTime o1 = LocalTimeValue.localTimeRaw((long)1L);
        LocalTime o2 = LocalTimeValue.localTimeRaw((long)2L);
        LocalTime o3 = LocalTimeValue.localTimeRaw((long)3L);
        LocalTime o4 = LocalTimeValue.localTimeRaw((long)4L);
        LocalTime o5 = LocalTimeValue.localTimeRaw((long)5L);
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalTime() throws Exception {
        LocalTime o0 = LocalTimeValue.localTimeRaw((long)0L);
        LocalTime o1 = LocalTimeValue.localTimeRaw((long)1L);
        LocalTime o2 = LocalTimeValue.localTimeRaw((long)2L);
        LocalTime o3 = LocalTimeValue.localTimeRaw((long)3L);
        LocalTime o4 = LocalTimeValue.localTimeRaw((long)4L);
        LocalTime o5 = LocalTimeValue.localTimeRaw((long)5L);
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingTime() throws Exception {
        OffsetTime o0 = TimeValue.timeRaw((long)0L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o1 = TimeValue.timeRaw((long)1L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o2 = TimeValue.timeRaw((long)2L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o3 = TimeValue.timeRaw((long)3L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o4 = TimeValue.timeRaw((long)4L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o5 = TimeValue.timeRaw((long)5L, (ZoneOffset)ZoneOffset.ofHours(0));
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingTime() throws Exception {
        OffsetTime o0 = TimeValue.timeRaw((long)0L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o1 = TimeValue.timeRaw((long)1L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o2 = TimeValue.timeRaw((long)2L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o3 = TimeValue.timeRaw((long)3L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o4 = TimeValue.timeRaw((long)4L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o5 = TimeValue.timeRaw((long)5L, (ZoneOffset)ZoneOffset.ofHours(0));
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalDateTime() throws Exception {
        LocalDateTime o0 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)0L);
        LocalDateTime o1 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)1L);
        LocalDateTime o2 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)2L);
        LocalDateTime o3 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)3L);
        LocalDateTime o4 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)4L);
        LocalDateTime o5 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)5L);
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalDateTime() throws Exception {
        LocalDateTime o0 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)0L);
        LocalDateTime o1 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)1L);
        LocalDateTime o2 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)2L);
        LocalDateTime o3 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)3L);
        LocalDateTime o4 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)4L);
        LocalDateTime o5 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)5L);
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDateTime() throws Exception {
        ZonedDateTime o0 = DateTimeValue.datetimeRaw((long)1L, (long)0L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o1 = DateTimeValue.datetimeRaw((long)1L, (long)1L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o2 = DateTimeValue.datetimeRaw((long)1L, (long)2L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o3 = DateTimeValue.datetimeRaw((long)1L, (long)3L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o4 = DateTimeValue.datetimeRaw((long)1L, (long)4L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o5 = DateTimeValue.datetimeRaw((long)1L, (long)5L, (ZoneId)ZoneId.of("UTC"));
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDateTime() throws Exception {
        ZonedDateTime o0 = DateTimeValue.datetimeRaw((long)1L, (long)0L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o1 = DateTimeValue.datetimeRaw((long)1L, (long)1L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o2 = DateTimeValue.datetimeRaw((long)1L, (long)2L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o3 = DateTimeValue.datetimeRaw((long)1L, (long)3L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o4 = DateTimeValue.datetimeRaw((long)1L, (long)4L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o5 = DateTimeValue.datetimeRaw((long)1L, (long)5L, (ZoneId)ZoneId.of("UTC"));
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDuration() throws Exception {
        Duration o0 = Duration.ofMillis(0L);
        Duration o1 = Duration.ofMillis(1L);
        Duration o2 = Duration.ofMillis(2L);
        Duration o3 = Duration.ofMillis(3L);
        Duration o4 = Duration.ofMillis(4L);
        Duration o5 = Duration.ofMillis(5L);
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDuration() throws Exception {
        Duration o0 = Duration.ofMillis(0L);
        Duration o1 = Duration.ofMillis(1L);
        Duration o2 = Duration.ofMillis(2L);
        Duration o3 = Duration.ofMillis(3L);
        Duration o4 = Duration.ofMillis(4L);
        Duration o5 = Duration.ofMillis(5L);
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingNumberArray() throws Exception {
        int[] o0 = new int[]{0};
        int[] o1 = new int[]{1};
        int[] o2 = new int[]{2};
        int[] o3 = new int[]{3};
        int[] o4 = new int[]{4};
        int[] o5 = new int[]{5};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingNumberArray() throws Exception {
        int[] o0 = new int[]{0};
        int[] o1 = new int[]{1};
        int[] o2 = new int[]{2};
        int[] o3 = new int[]{3};
        int[] o4 = new int[]{4};
        int[] o5 = new int[]{5};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingStringArray() throws Exception {
        String[] o0 = new String[]{"0"};
        String[] o1 = new String[]{"1"};
        String[] o2 = new String[]{"2"};
        String[] o3 = new String[]{"3"};
        String[] o4 = new String[]{"4"};
        String[] o5 = new String[]{"5"};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingStringArray() throws Exception {
        String[] o0 = new String[]{"0"};
        String[] o1 = new String[]{"1"};
        String[] o2 = new String[]{"2"};
        String[] o3 = new String[]{"3"};
        String[] o4 = new String[]{"4"};
        String[] o5 = new String[]{"5"};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingBooleanArray() throws Exception {
        boolean[] o0 = new boolean[]{false};
        boolean[] o1 = new boolean[]{false, false};
        boolean[] o2 = new boolean[]{false, true};
        boolean[] o3 = new boolean[]{true};
        boolean[] o4 = new boolean[]{true, false};
        boolean[] o5 = new boolean[]{true, true};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingBooleanArray() throws Exception {
        boolean[] o0 = new boolean[]{false};
        boolean[] o1 = new boolean[]{false, false};
        boolean[] o2 = new boolean[]{false, true};
        boolean[] o3 = new boolean[]{true};
        boolean[] o4 = new boolean[]{true, false};
        boolean[] o5 = new boolean[]{true, true};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDateTimeArray() throws Exception {
        ZonedDateTime[] o0 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 0, ZoneId.of("UTC"))};
        ZonedDateTime[] o1 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 1, ZoneId.of("UTC"))};
        ZonedDateTime[] o2 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 2, ZoneId.of("UTC"))};
        ZonedDateTime[] o3 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 3, ZoneId.of("UTC"))};
        ZonedDateTime[] o4 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 4, ZoneId.of("UTC"))};
        ZonedDateTime[] o5 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 5, ZoneId.of("UTC"))};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDateTimeArray() throws Exception {
        ZonedDateTime[] o0 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 0, ZoneId.of("UTC"))};
        ZonedDateTime[] o1 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 1, ZoneId.of("UTC"))};
        ZonedDateTime[] o2 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 2, ZoneId.of("UTC"))};
        ZonedDateTime[] o3 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 3, ZoneId.of("UTC"))};
        ZonedDateTime[] o4 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 4, ZoneId.of("UTC"))};
        ZonedDateTime[] o5 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 5, ZoneId.of("UTC"))};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalDateTimeArray() throws Exception {
        LocalDateTime[] o0 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 0)};
        LocalDateTime[] o1 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 1)};
        LocalDateTime[] o2 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 2)};
        LocalDateTime[] o3 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 3)};
        LocalDateTime[] o4 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 4)};
        LocalDateTime[] o5 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 5)};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalDateTimeArray() throws Exception {
        LocalDateTime[] o0 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 0)};
        LocalDateTime[] o1 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 1)};
        LocalDateTime[] o2 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 2)};
        LocalDateTime[] o3 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 3)};
        LocalDateTime[] o4 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 4)};
        LocalDateTime[] o5 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 5)};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingTimeArray() throws Exception {
        OffsetTime[] o0 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 0, ZoneOffset.ofHours(0))};
        OffsetTime[] o1 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 1, ZoneOffset.ofHours(0))};
        OffsetTime[] o2 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 2, ZoneOffset.ofHours(0))};
        OffsetTime[] o3 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 3, ZoneOffset.ofHours(0))};
        OffsetTime[] o4 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 4, ZoneOffset.ofHours(0))};
        OffsetTime[] o5 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 5, ZoneOffset.ofHours(0))};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingTimeArray() throws Exception {
        OffsetTime[] o0 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 0, ZoneOffset.ofHours(0))};
        OffsetTime[] o1 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 1, ZoneOffset.ofHours(0))};
        OffsetTime[] o2 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 2, ZoneOffset.ofHours(0))};
        OffsetTime[] o3 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 3, ZoneOffset.ofHours(0))};
        OffsetTime[] o4 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 4, ZoneOffset.ofHours(0))};
        OffsetTime[] o5 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 5, ZoneOffset.ofHours(0))};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDateArray() throws Exception {
        LocalDate[] o0 = new LocalDate[]{LocalDate.of(10, 10, 1)};
        LocalDate[] o1 = new LocalDate[]{LocalDate.of(10, 10, 2)};
        LocalDate[] o2 = new LocalDate[]{LocalDate.of(10, 10, 3)};
        LocalDate[] o3 = new LocalDate[]{LocalDate.of(10, 10, 4)};
        LocalDate[] o4 = new LocalDate[]{LocalDate.of(10, 10, 5)};
        LocalDate[] o5 = new LocalDate[]{LocalDate.of(10, 10, 6)};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDateArray() throws Exception {
        LocalDate[] o0 = new LocalDate[]{LocalDate.of(10, 10, 1)};
        LocalDate[] o1 = new LocalDate[]{LocalDate.of(10, 10, 2)};
        LocalDate[] o2 = new LocalDate[]{LocalDate.of(10, 10, 3)};
        LocalDate[] o3 = new LocalDate[]{LocalDate.of(10, 10, 4)};
        LocalDate[] o4 = new LocalDate[]{LocalDate.of(10, 10, 5)};
        LocalDate[] o5 = new LocalDate[]{LocalDate.of(10, 10, 6)};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalTimeArray() throws Exception {
        LocalTime[] o0 = new LocalTime[]{LocalTime.of(10, 0)};
        LocalTime[] o1 = new LocalTime[]{LocalTime.of(10, 1)};
        LocalTime[] o2 = new LocalTime[]{LocalTime.of(10, 2)};
        LocalTime[] o3 = new LocalTime[]{LocalTime.of(10, 3)};
        LocalTime[] o4 = new LocalTime[]{LocalTime.of(10, 4)};
        LocalTime[] o5 = new LocalTime[]{LocalTime.of(10, 5)};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalTimeArray() throws Exception {
        LocalTime[] o0 = new LocalTime[]{LocalTime.of(10, 0)};
        LocalTime[] o1 = new LocalTime[]{LocalTime.of(10, 1)};
        LocalTime[] o2 = new LocalTime[]{LocalTime.of(10, 2)};
        LocalTime[] o3 = new LocalTime[]{LocalTime.of(10, 3)};
        LocalTime[] o4 = new LocalTime[]{LocalTime.of(10, 4)};
        LocalTime[] o5 = new LocalTime[]{LocalTime.of(10, 5)};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDurationArray() throws Exception {
        Duration[] o0 = new Duration[]{Duration.of(0L, ChronoUnit.SECONDS)};
        Duration[] o1 = new Duration[]{Duration.of(1L, ChronoUnit.SECONDS)};
        Duration[] o2 = new Duration[]{Duration.of(2L, ChronoUnit.SECONDS)};
        Duration[] o3 = new Duration[]{Duration.of(3L, ChronoUnit.SECONDS)};
        Duration[] o4 = new Duration[]{Duration.of(4L, ChronoUnit.SECONDS)};
        Duration[] o5 = new Duration[]{Duration.of(5L, ChronoUnit.SECONDS)};
        this.shouldRangeSeekInOrder(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDurationArray() throws Exception {
        Duration[] o0 = new Duration[]{Duration.of(0L, ChronoUnit.SECONDS)};
        Duration[] o1 = new Duration[]{Duration.of(1L, ChronoUnit.SECONDS)};
        Duration[] o2 = new Duration[]{Duration.of(2L, ChronoUnit.SECONDS)};
        Duration[] o3 = new Duration[]{Duration.of(3L, ChronoUnit.SECONDS)};
        Duration[] o4 = new Duration[]{Duration.of(4L, ChronoUnit.SECONDS)};
        Duration[] o5 = new Duration[]{Duration.of(5L, ChronoUnit.SECONDS)};
        this.shouldRangeSeekInOrder(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekAscendingWithoutFindingNanForOpenEnd() throws Exception {
        Integer o0 = 0;
        Double o1 = 1.0;
        Double o2 = 2.5;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        Double o6 = Double.POSITIVE_INFINITY;
        Double o7 = Double.NaN;
        this.shouldRangeSeekInOrderWithExpectedSize(IndexOrder.ASCENDING, RangeSeekMode.OPEN_END, 7, o0, o1, o2, o3, o4, o5, o6, o7);
    }

    @Test
    void shouldRangeSeekDescendingWithoutFindingNanForOpenEnd() throws Exception {
        Integer o0 = 0;
        Double o1 = 1.0;
        Double o2 = 2.5;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        Double o6 = Double.POSITIVE_INFINITY;
        Double o7 = Double.NaN;
        this.shouldRangeSeekInOrderWithExpectedSize(IndexOrder.DESCENDING, RangeSeekMode.OPEN_END, 7, o0, o1, o2, o3, o4, o5, o6, o7);
    }

    @Test
    void shouldRangeSeekAscendingWithoutFindingNanForOpenStart() throws Exception {
        Double o0 = Double.NaN;
        Double o1 = 1.0;
        Double o2 = 2.5;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        Double o6 = Double.POSITIVE_INFINITY;
        this.shouldRangeSeekInOrderWithExpectedSize(IndexOrder.ASCENDING, RangeSeekMode.OPEN_START, 6, o0, o1, o2, o3, o4, o5, o6);
    }

    @Test
    void shouldRangeSeekDescendingWithoutFindingNanForOpenStart() throws Exception {
        Double o0 = Double.NaN;
        Double o1 = 1.0;
        Double o2 = 2.5;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        Double o6 = Double.POSITIVE_INFINITY;
        this.shouldRangeSeekInOrderWithExpectedSize(IndexOrder.DESCENDING, RangeSeekMode.OPEN_START, 6, o0, o1, o2, o3, o4, o5, o6);
    }

    private void shouldRangeSeekInOrder(IndexOrder order, Object ... objects) throws Exception {
        this.shouldRangeSeekInOrderWithExpectedSize(order, RangeSeekMode.CLOSED, objects.length, objects);
    }

    private void shouldRangeSeekInOrderWithExpectedSize(IndexOrder order, RangeSeekMode rangeSeekMode, int expectedSize, Object ... objects) throws Exception {
        PropertyIndexQuery.RangePredicate range;
        switch (rangeSeekMode) {
            case CLOSED: {
                range = PropertyIndexQuery.range((int)100, (Value)Values.of((Object)objects[0]), (boolean)true, (Value)Values.of((Object)objects[objects.length - 1]), (boolean)true);
                break;
            }
            case OPEN_END: {
                range = PropertyIndexQuery.range((int)100, (Value)Values.of((Object)objects[0]), (boolean)true, null, (boolean)false);
                break;
            }
            case OPEN_START: {
                range = PropertyIndexQuery.range((int)100, null, (boolean)false, (Value)Values.of((Object)objects[objects.length - 1]), (boolean)true);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        IndexOrderCapability indexOrders = this.orderCapability(new PropertyIndexQuery[]{range});
        if (order == IndexOrder.ASCENDING) {
            Assumptions.assumeTrue((boolean)indexOrders.supportsAsc(), (String)("Assume support for order " + String.valueOf(order)));
        } else if (order == IndexOrder.DESCENDING) {
            Assumptions.assumeTrue((boolean)indexOrders.supportsDesc(), (String)("Assume support for order " + String.valueOf(order)));
        }
        List<ValueIndexEntryUpdate<?>> additions = Arrays.stream(objects).map(o -> IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{o})).collect(Collectors.toList());
        Collections.shuffle(additions, this.random.random());
        this.updateAndCommit(additions);
        SimpleEntityValueClient client = new SimpleEntityValueClient();
        try (AutoCloseable ignored = this.query(client, order, new PropertyIndexQuery[]{range});){
            List<Long> seenIds = SimpleIndexAccessorCompatibility.assertClientReturnValuesInOrder(client, order);
            Assertions.assertThat((int)seenIds.size()).isEqualTo(expectedSize);
        }
    }

    @Test
    void shouldUpdateEntries() throws Exception {
        ValueType[] valueTypes = this.testSuite.supportedValueTypes();
        long entityId = this.random.nextLong(1000000000L);
        for (ValueType valueType : valueTypes) {
            Value newValue;
            Value value = this.random.nextValue(valueType);
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value})));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(entityId), this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)value)}));
            while (value.equals(newValue = this.random.nextValue(valueType))) {
            }
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)this.descriptor, (Value)value, (Value)newValue)));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)value)}));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(entityId), this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)newValue)}));
        }
    }

    @Test
    void shouldRemoveEntries() throws Exception {
        ValueType[] valueTypes = this.testSuite.supportedValueTypes();
        long entityId = this.random.nextLong(1000000000L);
        for (ValueType valueType : valueTypes) {
            Value value = this.random.nextValue(valueType);
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value})));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(entityId), this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)value)}));
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.remove((long)entityId, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value})));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)value)}).isEmpty());
        }
    }

    private static enum RangeSeekMode {
        CLOSED,
        OPEN_END,
        OPEN_START;

    }

    static abstract class Unique
    extends SimpleIndexAccessorCompatibility {
        Unique(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.uniqueIndexPrototype());
        }

        @Test
        void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)1, (Object)"a")})).containsExactly((Object[])new Long[]{1L, 2L});
        }

        @Test
        void testIndexSeekAndScan() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"b"}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"c"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)1, (Object)"a")})).containsExactly((Object[])new Long[]{1L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
        }
    }

    static abstract class General
    extends SimpleIndexAccessorCompatibility {
        General(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.indexPrototype());
        }

        @Test
        void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)1, (Object)"a")})).containsExactly((Object[])new Long[]{1L, 2L});
        }

        @Test
        void testIndexSeekAndScan() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"b"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)1, (Object)"a")})).containsExactly((Object[])new Long[]{1L, 2L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
        }

        @Test
        void testIndexRangeSeekByNumberWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{-5}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{-5}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{0}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{5}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{5})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)5, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Number)-3, (boolean)true, (Number)-1, (boolean)true)})).isEmpty();
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)4, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Number)-4, (boolean)true, (Number)5, (boolean)true)})).containsExactly((Object[])new Long[]{3L, 4L, 5L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)5, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
        }

        @Test
        void testIndexRangeSeekByStringWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"Anna"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"Anna"}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"Bob"}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"William"}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"William"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (String)"Anna", (boolean)false, (String)"William", (boolean)false)})).containsExactly((Object[])new Long[]{3L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (String)"Arabella", (boolean)false, (String)"Bob", (boolean)false)})).isEmpty();
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (String)"Anna", (boolean)true, (String)"William", (boolean)false)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (String)"Anna", (boolean)false, (String)"William", (boolean)true)})).containsExactly((Object[])new Long[]{3L, 4L, 5L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, (String)"Anna", (boolean)true, (String)"William", (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
        }

        @Test
        void testIndexRangeSeekByDateWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(DateValue.epochDate((long)100L), DateValue.epochDate((long)101L), DateValue.epochDate((long)200L), DateValue.epochDate((long)300L));
        }

        @Test
        void testIndexRangeSeekByLocalDateTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(LocalDateTimeValue.localDateTime((long)1000L, (long)10L), LocalDateTimeValue.localDateTime((long)1000L, (long)11L), LocalDateTimeValue.localDateTime((long)2000L, (long)10L), LocalDateTimeValue.localDateTime((long)3000L, (long)10L));
        }

        @Test
        void testIndexRangeSeekByDateTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(DateTimeValue.datetime((long)1000L, (long)10L, (ZoneOffset)ZoneOffset.UTC), DateTimeValue.datetime((long)1000L, (long)11L, (ZoneOffset)ZoneOffset.UTC), DateTimeValue.datetime((long)2000L, (long)10L, (ZoneOffset)ZoneOffset.UTC), DateTimeValue.datetime((long)3000L, (long)10L, (ZoneOffset)ZoneOffset.UTC));
        }

        @Test
        void testIndexRangeSeekByLocalTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(LocalTimeValue.localTime((long)1000L), LocalTimeValue.localTime((long)1001L), LocalTimeValue.localTime((long)2000L), LocalTimeValue.localTime((long)3000L));
        }

        @Test
        void testIndexRangeSeekByTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(TimeValue.time((long)1000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)1001L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)2000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)3000L, (ZoneOffset)ZoneOffset.UTC));
        }

        @Test
        void testIndexRangeSeekByTimeWithZonesAndDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(TimeValue.time((int)20, (int)31, (int)53, (int)4, (ZoneOffset)ZoneOffset.of("+17:02")), TimeValue.time((int)20, (int)31, (int)54, (int)3, (ZoneOffset)ZoneOffset.of("+17:02")), TimeValue.time((int)19, (int)31, (int)54, (int)2, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((int)18, (int)23, (int)27, (int)1, (ZoneOffset)ZoneOffset.of("-18:00")));
        }

        @Test
        void testIndexRangeSeekByDurationWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(DurationValue.duration((long)1L, (long)1L, (long)1L, (long)1L), DurationValue.duration((long)1L, (long)1L, (long)1L, (long)2L), DurationValue.duration((long)2L, (long)1L, (long)1L, (long)1L), DurationValue.duration((long)3L, (long)1L, (long)1L, (long)1L));
        }

        private <VALUE extends Value> void testIndexRangeSeekWithDuplicates(VALUE v1, VALUE v2, VALUE v3, VALUE v4) throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{v1}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{v1}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{v3}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{v4}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{v4})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, v1, (boolean)false, v4, (boolean)false)})).containsExactly((Object[])new Long[]{3L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, v2, (boolean)false, v3, (boolean)false)})).isEmpty();
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, v1, (boolean)true, v4, (boolean)false)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, v1, (boolean)false, v4, (boolean)true)})).containsExactly((Object[])new Long[]{3L, 4L, 5L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)1, v1, (boolean)true, v4, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
        }

        @Test
        void testIndexRangeSeekByPrefixWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"a"))})).containsExactly((Object[])new Long[]{1L, 3L, 4L, 5L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"apa"))})).containsExactly((Object[])new Long[]{3L, 4L, 5L});
        }

        @Test
        void testIndexFullSearchWithDuplicates() throws Exception {
            Assumptions.assumeTrue((boolean)this.testSuite.supportsContainsAndEndsWithQueries());
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apalong"}), IndexQueryHelper.add((long)6L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa apa"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)1, (TextValue)Values.stringValue((String)"a"))})).containsExactly((Object[])new Long[]{1L, 3L, 4L, 5L, 6L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)1, (TextValue)Values.stringValue((String)"apa"))})).containsExactly((Object[])new Long[]{3L, 4L, 5L, 6L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)1, (TextValue)Values.stringValue((String)"apa*"))})).isEmpty();
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)1, (TextValue)Values.stringValue((String)"pa ap"))})).containsExactly((Object[])new Long[]{6L});
        }

        @Test
        void testIndexEndsWithWithDuplicated() throws Exception {
            Assumptions.assumeTrue((boolean)this.testSuite.supportsContainsAndEndsWithQueries());
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)5L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"longapa"}), IndexQueryHelper.add((long)6L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apalong"}), IndexQueryHelper.add((long)7L, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{"apa apa"})));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)1, (TextValue)Values.stringValue((String)"a"))})).containsExactly((Object[])new Long[]{1L, 3L, 4L, 5L, 7L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)1, (TextValue)Values.stringValue((String)"apa"))})).containsExactly((Object[])new Long[]{3L, 4L, 5L, 7L});
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)1, (TextValue)Values.stringValue((String)"apa*"))})).isEmpty();
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)1, (TextValue)Values.stringValue((String)"a apa"))})).containsExactly((Object[])new Long[]{7L});
        }

        @Test
        void testIndexShouldHandleLargeAmountOfDuplicatesStringArray() throws Exception {
            Value arrayValue = this.nextRandomValidArrayValue();
            this.doTestShouldHandleLargeAmountOfDuplicates(arrayValue);
        }

        private void doTestShouldHandleLargeAmountOfDuplicates(Object value) throws Exception {
            ArrayList updates = new ArrayList();
            ArrayList<Long> nodeIds = new ArrayList<Long>();
            for (long i = 0L; i < 1000L; ++i) {
                nodeIds.add(i);
                updates.add(IndexQueryHelper.add((long)i, (SchemaDescriptorSupplier)this.descriptor, (Object[])new Object[]{value}));
            }
            this.updateAndCommit(updates);
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)1)})).containsAll(nodeIds);
        }

        private Value nextRandomValidArrayValue() {
            ArrayValue value;
            do {
                value = this.random.randomValues().nextArray();
            } while (!this.testSuite.supportsSpatial() && Values.isGeometryArray((Value)value));
            return value;
        }
    }
}

