/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public class TextIndexQueryTest
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static final Label PERSON = Label.label((String)"PERSON");
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"FRIEND");
    private static final IndexAccessMonitor MONITOR = new IndexAccessMonitor();
    private static final String NODE_INDEX_NAME = "some_node_text_index";
    private static final String REL_INDEX_NAME = "some_rel_text_index";
    private static final String NAME = "name";
    private static final String ADDRESS = "address";
    private static final String SINCE = "since";

    @BeforeEach
    void setup() {
        MONITOR.reset();
    }

    @Override
    public void createTestGraph(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(PERSON).on(NAME).withName(NODE_INDEX_NAME).withIndexType(org.neo4j.graphdb.schema.IndexType.TEXT).create();
            tx.schema().indexFor(FRIEND).on(SINCE).withName(REL_INDEX_NAME).withIndexType(org.neo4j.graphdb.schema.IndexType.TEXT).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Node mike = tx.createNode(new Label[]{PERSON});
            mike.setProperty(NAME, (Object)"Mike Smith");
            mike.setProperty(ADDRESS, (Object)"United Kingdom");
            Node james = tx.createNode(new Label[]{PERSON});
            james.setProperty(NAME, (Object)"James Smith");
            james.setProperty(ADDRESS, (Object)"Heathrow, United Kingdom");
            james.createRelationshipTo(mike, FRIEND).setProperty(SINCE, (Object)"3 years");
            Node smith = tx.createNode(new Label[]{PERSON});
            smith.setProperty(NAME, (Object)"Smith James Luke");
            smith.setProperty(ADDRESS, (Object)"United Emirates");
            smith.createRelationshipTo(mike, FRIEND).setProperty(SINCE, (Object)"2 years, 2 months");
            smith.createRelationshipTo(james, FRIEND).setProperty(SINCE, (Object)"2 years");
            Node noah = tx.createNode(new Label[]{PERSON});
            noah.setProperty(NAME, (Object)"Noah");
            noah.createRelationshipTo(mike, FRIEND).setProperty(SINCE, (Object)"4 years");
            Node alex = tx.createNode(new Label[]{PERSON});
            alex.setProperty(NAME, (Object)"Alex");
            Node matt = tx.createNode(new Label[]{PERSON});
            matt.setProperty(NAME, (Object)42);
            matt.createRelationshipTo(mike, FRIEND).setProperty(SINCE, (Object)694717800);
            Node jack = tx.createNode(new Label[]{PERSON});
            jack.setProperty(NAME, (Object)"77");
            jack.createRelationshipTo(matt, FRIEND).setProperty(SINCE, (Object)"1 year");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldRejectInvalidConstraints() {
        PropertyIndexQuery.ExactPredicate query = PropertyIndexQuery.exact((int)this.token.propertyKey(NAME), (Object)"Mike Smith");
        IndexQueryConstraints needsValue = IndexQueryConstraints.constrained((IndexOrder)IndexOrder.NONE, (boolean)true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.indexedNodes(needsValue, new PropertyIndexQuery[]{query})).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("%s index has no value capability", new Object[]{IndexType.TEXT});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.indexedRelations(needsValue, new PropertyIndexQuery[]{query})).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("%s index has no value capability", new Object[]{IndexType.TEXT});
    }

    @Test
    void shouldFindNodes() throws Exception {
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()})).isEqualTo(6L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.token.propertyKey(NAME), (Object)"Mike Smith")})).isEqualTo(1L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.token.propertyKey(NAME), (Object)"Unknown")})).isEqualTo(0L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.token.propertyKey(NAME), (Object)"42")})).isEqualTo(0L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.token.propertyKey(NAME), (Object)"77")})).isEqualTo(1L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)this.token.propertyKey(NAME), (TextValue)Values.stringValue((String)"Smith"))})).isEqualTo(1L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)this.token.propertyKey(NAME), (TextValue)Values.stringValue((String)"Smith"))})).isEqualTo(3L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)this.token.propertyKey(NAME), (TextValue)Values.stringValue((String)"Smith"))})).isEqualTo(2L);
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)this.token.propertyKey(NAME), (String)"Mike Smith", (boolean)true, (String)"Noah", (boolean)true)})).isEqualTo(2L);
    }

    @Test
    void shouldFindRelations() throws Exception {
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()})).isEqualTo(5L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.token.propertyKey(SINCE), (Object)"3 years")})).isEqualTo(1L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.token.propertyKey(SINCE), (Object)"694717800")})).isEqualTo(0L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.token.propertyKey(SINCE), (Object)"Unknown")})).isEqualTo(0L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)this.token.propertyKey(SINCE), (TextValue)Values.stringValue((String)"years"))})).isEqualTo(4L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)this.token.propertyKey(SINCE), (TextValue)Values.stringValue((String)"years"))})).isEqualTo(3L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)this.token.propertyKey(SINCE), (TextValue)Values.stringValue((String)"2 years"))})).isEqualTo(2L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)this.token.propertyKey(SINCE), (String)"2 years", (boolean)true, (String)"3 years", (boolean)true)})).isEqualTo(3L);
    }

    @Test
    void shouldFindAllEntries() throws Exception {
        Assertions.assertThat((long)this.indexedNodes(new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()})).isEqualTo(6L);
        Assertions.assertThat((long)this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()})).isEqualTo(5L);
    }

    @Test
    void shouldThrowOnExistsQuery() {
        PropertyIndexQuery.ExistsPredicate query = PropertyIndexQuery.exists((int)this.token.propertyKey(SINCE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$shouldThrowOnExistsQuery$2((PropertyIndexQuery)query)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Index query not supported for %s index. Query: %s", new Object[]{this.getIndex(NODE_INDEX_NAME).getIndexProvider().getKey(), query});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.indexedRelations(new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)this.token.propertyKey(SINCE))})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Index query not supported for %s index. Query: %s", new Object[]{this.getIndex(REL_INDEX_NAME).getIndexProvider().getKey(), query});
    }

    @Test
    void shouldThrowOnNonTextValues() {
        PropertyIndexQuery.ExactPredicate name = PropertyIndexQuery.exact((int)this.token.propertyKey(SINCE), (Object)77);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$shouldThrowOnNonTextValues$4((PropertyIndexQuery)name)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Index query not supported for %s index. Query: %s", new Object[]{this.getIndex(NODE_INDEX_NAME).getIndexProvider().getKey(), name});
        PropertyIndexQuery.ExactPredicate since = PropertyIndexQuery.exact((int)this.token.propertyKey(SINCE), (Object)694717800);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$shouldThrowOnNonTextValues$5((PropertyIndexQuery)since)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Index query not supported for %s index. Query: %s", new Object[]{this.getIndex(REL_INDEX_NAME).getIndexProvider().getKey(), since});
    }

    private long scanNodes() throws Exception {
        MONITOR.reset();
        IndexReadSession index = this.read.indexReadSession(this.getIndex(NODE_INDEX_NAME));
        try (NodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.nodeIndexScan(index, cursor, IndexQueryConstraints.unconstrained());
            Assertions.assertThat((int)MONITOR.accessed(IndexType.TEXT)).isEqualTo(1);
            long l = this.count((Cursor)cursor);
            return l;
        }
    }

    private long scanRelationships() throws Exception {
        MONITOR.reset();
        IndexReadSession index = this.read.indexReadSession(this.getIndex(REL_INDEX_NAME));
        try (RelationshipValueIndexCursor cursor = this.cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.relationshipIndexScan(index, cursor, IndexQueryConstraints.unconstrained());
            Assertions.assertThat((int)MONITOR.accessed(IndexType.TEXT)).isEqualTo(1);
            long l = this.count((Cursor)cursor);
            return l;
        }
    }

    private long indexedNodes(PropertyIndexQuery ... query) throws Exception {
        return this.indexedNodes(IndexQueryConstraints.unconstrained(), query);
    }

    private long indexedNodes(IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws Exception {
        MONITOR.reset();
        IndexReadSession index = this.read.indexReadSession(this.getIndex(NODE_INDEX_NAME));
        try (NodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.nodeIndexSeek(this.tx.queryContext(), index, cursor, constraints, query);
            Assertions.assertThat((int)MONITOR.accessed(IndexType.TEXT)).isEqualTo(1);
            long l = this.count((Cursor)cursor);
            return l;
        }
    }

    private long indexedRelations(PropertyIndexQuery ... query) throws Exception {
        return this.indexedRelations(IndexQueryConstraints.unconstrained(), query);
    }

    private long indexedRelations(IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws Exception {
        MONITOR.reset();
        IndexReadSession index = this.read.indexReadSession(this.getIndex(REL_INDEX_NAME));
        try (RelationshipValueIndexCursor cursor = this.cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.relationshipIndexSeek(this.tx.queryContext(), index, cursor, constraints, query);
            Assertions.assertThat((int)MONITOR.accessed(IndexType.TEXT)).isEqualTo(1);
            long l = this.count((Cursor)cursor);
            return l;
        }
    }

    private IndexDescriptor getIndex(String indexName) {
        return this.schemaRead.indexGetForName(indexName);
    }

    @Override
    public ReadTestSupport newTestSupport() {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)MONITOR, new String[0]);
        ReadTestSupport support = new ReadTestSupport();
        support.setMonitors(monitors);
        return support;
    }

    private long count(Cursor cursor) {
        int result = 0;
        while (cursor.next()) {
            ++result;
        }
        return result;
    }

    private /* synthetic */ void lambda$shouldThrowOnNonTextValues$5(PropertyIndexQuery since) throws Throwable {
        this.indexedRelations(since);
    }

    private /* synthetic */ void lambda$shouldThrowOnNonTextValues$4(PropertyIndexQuery name) throws Throwable {
        this.indexedNodes(name);
    }

    private /* synthetic */ void lambda$shouldThrowOnExistsQuery$2(PropertyIndexQuery query) throws Throwable {
        this.indexedNodes(query);
    }

    private static class IndexAccessMonitor
    extends IndexMonitor.MonitorAdapter {
        private final Map<IndexType, Integer> counts = new HashMap<IndexType, Integer>();

        private IndexAccessMonitor() {
        }

        public void queried(IndexDescriptor descriptor) {
            this.counts.putIfAbsent(descriptor.getIndexType(), 0);
            this.counts.computeIfPresent(descriptor.getIndexType(), (type, value) -> value + 1);
        }

        public int accessed(IndexType type) {
            return this.counts.getOrDefault(type, 0);
        }

        void reset() {
            this.counts.clear();
        }
    }
}

