/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.index.schema.NameOverridingStoreMigrationParticipant;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

abstract class UniqueConstraintCompatibility
extends PropertyIndexProviderCompatibilityTestSuite.Compatibility {
    private DatabaseManagementService managementService;
    private static final long COLLISION_X = 0x4000000000000001L;
    private static final long COLLISION_Y = 0x4000000000000003L;
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private final Label label = Label.label((String)"Cybermen");
    private final String property = "name";
    private Node a;
    private Node b;
    private Node c;
    private Node d;
    private GraphDatabaseService db;
    private final Action success = new Action("tx.success();"){

        @Override
        public void accept(Transaction transaction) {
            transaction.commit();
        }
    };

    UniqueConstraintCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, testSuite.uniqueIndexPrototype());
    }

    @BeforeEach
    void setUp() {
        IndexProviderDescriptor originalDescriptor = this.indexProvider.getProviderDescriptor();
        IndexProviderDescriptor descriptorOverride = new IndexProviderDescriptor("compatibility-test-" + originalDescriptor.getKey(), originalDescriptor.getVersion());
        Config.Builder config = Config.newBuilder();
        config.set(GraphDatabaseSettings.default_schema_provider, (Object)descriptorOverride.name());
        this.testSuite.additionalConfig(config);
        this.managementService = new TestDatabaseManagementServiceBuilder(this.homePath).addExtension((ExtensionFactory)new PredefinedIndexProviderFactory(this.indexProvider, descriptorOverride)).noOpSystemGraphInitializer().impermanent().setConfig(config.build()).build();
        this.db = this.managementService.database("neo4j");
    }

    @Override
    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    @Test
    void onlineConstraintShouldAcceptDistinctValuesInDifferentTransactions() {
        Node n;
        this.givenOnlineConstraint();
        try (Transaction tx = this.db.beginTx();){
            n = tx.createNode(new Label[]{this.label});
            n.setProperty("name", (Object)"n");
            tx.commit();
        }
        this.transaction(this.assertLookupNode("a", this.a), this.assertLookupNode("n", n));
    }

    @Test
    void onlineConstraintShouldAcceptDistinctValuesInSameTransaction() {
        Node m;
        Node n;
        this.givenOnlineConstraint();
        try (Transaction tx = this.db.beginTx();){
            n = tx.createNode(new Label[]{this.label});
            n.setProperty("name", (Object)"n");
            m = tx.createNode(new Label[]{this.label});
            m.setProperty("name", (Object)"m");
            tx.commit();
        }
        this.transaction(this.assertLookupNode("n", n), this.assertLookupNode("m", m));
    }

    @Test
    void onlineConstraintShouldNotFalselyCollideOnFindNodesByLabelAndProperty() {
        Node m;
        Node n;
        this.givenOnlineConstraint();
        try (Transaction tx = this.db.beginTx();){
            n = tx.createNode(new Label[]{this.label});
            n.setProperty("name", (Object)0x4000000000000001L);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            m = tx.createNode(new Label[]{this.label});
            m.setProperty("name", (Object)0x4000000000000003L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.transaction(this.assertLookupNode(0x4000000000000001L, n), this.assertLookupNode(0x4000000000000003L, m));
    }

    @Test
    void onlineConstraintShouldNotConflictOnIntermediateStatesInSameTransaction() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.a, "b"), this.setProperty(this.b, "a"), this.success);
        this.transaction(this.assertLookupNode("a", this.b), this.assertLookupNode("b", this.a));
    }

    @Test
    void onlineConstraintShouldRejectChangingEntryToAlreadyIndexedValue() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.success);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.transaction(this.setProperty(this.b, "a"), this.success, UniqueConstraintCompatibility.fail("Changing a property to an already indexed value should have thrown")));
    }

    @Test
    void onlineConstraintShouldRejectConflictsInTheSameTransaction() {
        this.givenOnlineConstraint();
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.transaction(this.setProperty(this.a, "x"), this.setProperty(this.b, "x"), this.success, UniqueConstraintCompatibility.fail("Should have rejected changes of two node/properties to the same index value")));
    }

    @Test
    void onlineConstraintShouldRejectChangingEntryToAlreadyIndexedValueThatOtherTransactionsAreRemoving() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.success);
        Transaction otherTx = this.db.beginTx();
        otherTx.getNodeById(this.a.getId()).removeLabel(this.label);
        try {
            this.transaction(this.setProperty(this.b, "a"), this.success, UniqueConstraintCompatibility.fail("Changing a property to an already indexed value should have thrown"));
        }
        catch (ConstraintViolationException constraintViolationException) {
        }
        finally {
            otherTx.rollback();
        }
    }

    @Test
    void onlineConstraintShouldAddAndRemoveFromIndexAsPropertiesAndLabelsChange() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.success);
        this.transaction(this.setProperty(this.c, "c"), this.addLabel(this.c, this.label), this.success);
        this.transaction(this.setProperty(this.d, "d"), this.addLabel(this.d, this.label), this.success);
        this.transaction(this.removeProperty(this.a), this.success);
        this.transaction(this.removeProperty(this.b), this.success);
        this.transaction(this.removeProperty(this.c), this.success);
        this.transaction(this.setProperty(this.a, "a"), this.success);
        this.transaction(this.setProperty(this.c, "c2"), this.success);
        this.transaction(this.assertLookupNode("a", this.a), this.assertLookupNode("b", null), this.assertLookupNode("c", null), this.assertLookupNode("d", this.d), this.assertLookupNode("c2", this.c));
    }

    @Test
    void onlineConstraintShouldRejectConflictingPropertyChange() {
        this.givenOnlineConstraint();
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.transaction(this.setProperty(this.b, "a"), this.success, UniqueConstraintCompatibility.fail("Setting b.name = \"a\" should have caused a conflict")));
    }

    @Test
    void onlineConstraintShouldRejectConflictingLabelChange() {
        this.givenOnlineConstraint();
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.transaction(this.addLabel(this.c, this.label), this.success, UniqueConstraintCompatibility.fail("Setting c:Cybermen should have caused a conflict")));
    }

    @Test
    void onlineConstraintShouldRejectAddingEntryForValueAlreadyIndexedByPriorChange() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.a, "a1"), this.success);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.transaction(this.setProperty(this.b, "a1"), this.success, UniqueConstraintCompatibility.fail("Setting b.name = \"a1\" should have caused a conflict")));
    }

    @Test
    void onlineConstraintShouldAcceptUniqueEntries() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.b, "b"), this.addLabel(this.d, this.label), this.success);
        this.transaction(this.setProperty(this.c, "c"), this.addLabel(this.c, this.label), this.success);
        this.transaction(this.assertLookupNode("a", this.a), this.assertLookupNode("b", this.b), this.assertLookupNode("c", this.c), this.assertLookupNode("d", this.d));
    }

    @Test
    void onlineConstraintShouldAcceptUniqueEntryChanges() {
        this.givenOnlineConstraint();
        this.transaction(this.setProperty(this.a, "a1"), this.success);
        this.transaction(this.assertLookupNode("a1", this.a));
    }

    @Test
    void onlineConstraintShouldRejectDuplicateEntriesAddedInSameTransaction() {
        this.givenOnlineConstraint();
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.transaction(this.setProperty(this.b, "d"), this.addLabel(this.d, this.label), this.success, UniqueConstraintCompatibility.fail("Setting b.name = \"d\" and d:Cybermen should have caused a conflict")));
    }

    @Test
    void populatingConstraintMustAcceptDatasetOfUniqueEntries() {
        this.givenUniqueDataset();
        this.createUniqueConstraint();
    }

    @Test
    void populatingConstraintMustRejectDatasetWithDuplicateEntries() {
        this.givenUniqueDataset();
        this.transaction(this.setProperty(this.c, "b"), this.success);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, this::createUniqueConstraint);
    }

    @Test
    void populatingConstraintMustAcceptDatasetWithDalseIndexCollisions() {
        this.givenUniqueDataset();
        this.transaction(this.setProperty(this.b, 0x4000000000000001L), this.setProperty(this.c, 0x4000000000000003L), this.success);
        this.createUniqueConstraint();
    }

    @Test
    void populatingConstraintMustAcceptDatasetThatGetsUpdatedWithUniqueEntries() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "d1"));
        createConstraintTransaction.get();
    }

    @Test
    void populatingConstraintMustRejectDatasetThatGetsUpdatedWithDuplicateAddition() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.createNode("b"));
        try {
            createConstraintTransaction.get();
            org.junit.jupiter.api.Assertions.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assertions.assertThat((Throwable)cause).isInstanceOf(ConstraintViolationException.class);
        }
    }

    @Test
    void populatingConstraintMustRejectDatasetThatGetsUpdatedWithDuplicates() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "b"));
        try {
            createConstraintTransaction.get();
            org.junit.jupiter.api.Assertions.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assertions.assertThat((Throwable)cause).isInstanceOf(ConstraintViolationException.class);
        }
    }

    @Test
    void populatingConstraintMustAcceptDatasetThatGestUpdatedWithFalseIndexCollisions() throws Exception {
        this.givenUniqueDataset();
        this.transaction(this.setProperty(this.a, 0x4000000000000001L), this.success);
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, 0x4000000000000003L));
        createConstraintTransaction.get();
    }

    @Test
    void populatingConstraintMustRejectDatasetThatGetsUpdatedWithDuplicatesInSameTransaction() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "x"), this.setProperty(this.c, "x"));
        try {
            createConstraintTransaction.get();
            org.junit.jupiter.api.Assertions.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assertions.assertThat((Throwable)cause).isInstanceOf(ConstraintViolationException.class);
        }
    }

    @Test
    void populatingConstraintMustAcceptDatasetThatGetsUpdatedWithDuplicatesThatAreLaterResolved() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "b"), this.setProperty(this.b, "c"), this.setProperty(this.c, "d"));
        createConstraintTransaction.get();
    }

    @Test
    void populatingUpdaterMustRejectDatasetWhereAdditionsConflictsWithPriorChanges() throws Exception {
        this.givenUniqueDataset();
        Future<?> createConstraintTransaction = this.applyChangesToPopulatingUpdater(this.d.getId(), this.a.getId(), this.setProperty(this.d, "x"), this.createNode("x"));
        try {
            createConstraintTransaction.get();
            org.junit.jupiter.api.Assertions.fail((String)"expected to throw when PopulatingUpdater got duplicates");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assertions.assertThat((Throwable)cause).isInstanceOf(ConstraintViolationException.class);
        }
    }

    private Future<?> applyChangesToPopulatingUpdater(long blockDataChangeTransactionOnLockOnId, long blockPopulatorOnLockOnId, Action ... actions) throws InterruptedException, ExecutionException {
        CountDownLatch createNodeReadyLatch = new CountDownLatch(1);
        CountDownLatch createNodeCommitLatch = new CountDownLatch(1);
        Future<?> updatingTransaction = executor.submit(() -> {
            try (Transaction tx = this.db.beginTx();){
                for (Action action : actions) {
                    action.accept(tx);
                }
                tx.commit();
                createNodeReadyLatch.countDown();
                UniqueConstraintCompatibility.awaitUninterruptibly(createNodeCommitLatch);
            }
        });
        createNodeReadyLatch.await();
        Lock lockBlockingDataChangeTransaction = this.getLockService().acquireNodeLock(blockDataChangeTransactionOnLockOnId, LockType.EXCLUSIVE);
        Lock lockBlockingIndexPopulator = this.getLockService().acquireNodeLock(blockPopulatorOnLockOnId, LockType.EXCLUSIVE);
        CountDownLatch createConstraintTransactionStarted = new CountDownLatch(1);
        Future<?> createConstraintTransaction = executor.submit(() -> this.createUniqueConstraint(createConstraintTransactionStarted));
        createConstraintTransactionStarted.await();
        createNodeCommitLatch.countDown();
        lockBlockingDataChangeTransaction.release();
        updatingTransaction.get();
        lockBlockingIndexPopulator.release();
        return createConstraintTransaction;
    }

    private void givenOnlineConstraint() {
        this.createUniqueConstraint();
        try (Transaction tx = this.db.beginTx();){
            this.a = tx.createNode(new Label[]{this.label});
            this.a.setProperty("name", (Object)"a");
            this.b = tx.createNode(new Label[]{this.label});
            this.c = tx.createNode();
            this.c.setProperty("name", (Object)"a");
            this.d = tx.createNode();
            this.d.setProperty("name", (Object)"d");
            tx.commit();
        }
    }

    private void givenUniqueDataset() {
        try (Transaction tx = this.db.beginTx();){
            this.a = tx.createNode(new Label[]{this.label});
            this.a.setProperty("name", (Object)"a");
            this.b = tx.createNode(new Label[]{this.label});
            this.b.setProperty("name", (Object)"b");
            this.c = tx.createNode(new Label[]{this.label});
            this.c.setProperty("name", (Object)"c");
            this.d = tx.createNode(new Label[]{this.label});
            this.d.setProperty("name", (Object)"d");
            tx.commit();
        }
    }

    private void createUniqueConstraint() {
        this.createUniqueConstraint(null);
    }

    private void createUniqueConstraint(CountDownLatch preCreateLatch) {
        try (Transaction tx = this.db.beginTx();){
            if (preCreateLatch != null) {
                preCreateLatch.countDown();
            }
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("name").withIndexType(this.testSuite.indexType().toPublicApi()).create();
            tx.commit();
        }
    }

    private Node lookUpNode(Transaction tx, Object value) {
        return tx.findNode(this.label, "name", value);
    }

    void transaction(Action ... actions) {
        int progress = 0;
        try (Transaction tx = this.db.beginTx();){
            for (Action action : actions) {
                action.accept(tx);
                ++progress;
            }
        }
        catch (Throwable ex) {
            StringBuilder sb = new StringBuilder("Transaction failed:\n\n");
            for (int i = 0; i < actions.length; ++i) {
                String mark = progress == i ? " failed --> " : "            ";
                sb.append(mark).append(actions[i]).append('\n');
            }
            ex.addSuppressed((Throwable)((Object)new AssertionError((Object)sb.toString())));
            throw ex;
        }
    }

    private Action createNode(final Object propertyValue) {
        return new Action("Node node = tx.createNode( label ); node.setProperty( property, " + UniqueConstraintCompatibility.reprValue(propertyValue) + " );"){

            @Override
            public void accept(Transaction transaction) {
                Node node = transaction.createNode(new Label[]{UniqueConstraintCompatibility.this.label});
                node.setProperty("name", propertyValue);
            }
        };
    }

    private Action setProperty(final Node node, final Object value) {
        return new Action(this.reprNode(node) + ".setProperty( property, " + UniqueConstraintCompatibility.reprValue(value) + " );"){

            @Override
            public void accept(Transaction transaction) {
                transaction.getNodeById(node.getId()).setProperty("name", value);
            }
        };
    }

    private Action removeProperty(final Node node) {
        return new Action(this.reprNode(node) + ".removeProperty( property );"){

            @Override
            public void accept(Transaction transaction) {
                transaction.getNodeById(node.getId()).removeProperty("name");
            }
        };
    }

    private Action addLabel(final Node node, final Label label) {
        return new Action(this.reprNode(node) + ".addLabel( " + String.valueOf(label) + " );"){

            @Override
            public void accept(Transaction transaction) {
                transaction.getNodeById(node.getId()).addLabel(label);
            }
        };
    }

    private static Action fail(final String message) {
        return new Action("fail( \"" + message + "\" );"){

            @Override
            public void accept(Transaction transaction) {
                org.junit.jupiter.api.Assertions.fail((String)message);
            }
        };
    }

    private Action assertLookupNode(final Object propertyValue, final Object value) {
        return new Action("assertThat( lookUpNode( " + UniqueConstraintCompatibility.reprValue(propertyValue) + " ), " + String.valueOf(value) + " );"){

            @Override
            public void accept(Transaction transaction) {
                Assertions.assertThat((Object)UniqueConstraintCompatibility.this.lookUpNode(transaction, propertyValue)).isEqualTo(value);
            }
        };
    }

    private static String reprValue(Object value) {
        return value instanceof String ? "\"" + String.valueOf(value) + "\"" : String.valueOf(value);
    }

    private String reprNode(Node node) {
        return node == this.a ? "a" : (node == this.b ? "b" : (node == this.c ? "c" : (node == this.d ? "d" : "n")));
    }

    private LockService getLockService() {
        return this.resolveInternalDependency(LockService.class);
    }

    private <T> T resolveInternalDependency(Class<T> type) {
        GraphDatabaseAPI api = (GraphDatabaseAPI)this.db;
        DependencyResolver resolver = api.getDependencyResolver();
        return (T)resolver.resolveDependency(type);
    }

    private static void awaitUninterruptibly(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted", e);
        }
    }

    private static class PredefinedIndexProviderFactory
    extends ExtensionFactory<NoDeps> {
        private final IndexProvider indexProvider;
        private final IndexProviderDescriptor descriptorOverride;

        public Lifecycle newInstance(ExtensionContext context, NoDeps noDeps) {
            return new IndexProvider.Delegating(this.indexProvider){

                public IndexProviderDescriptor getProviderDescriptor() {
                    return descriptorOverride;
                }

                public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
                    return new NameOverridingStoreMigrationParticipant(super.storeMigrationParticipant(fs, pageCache, storageEngineFactory), descriptorOverride.name());
                }
            };
        }

        PredefinedIndexProviderFactory(IndexProvider indexProvider, IndexProviderDescriptor descriptorOverride) {
            super(ExtensionType.DATABASE, indexProvider.getClass().getSimpleName());
            this.indexProvider = indexProvider;
            this.descriptorOverride = descriptorOverride;
        }

        static interface NoDeps {
        }
    }

    private static abstract class Action
    implements Consumer<Transaction> {
        private final String name;

        Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

