/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@Extensions(value={@ExtendWith(value={OtherThreadExtension.class}), @ExtendWith(value={RandomExtension.class})})
abstract class IndexOrderTestBase<ENTITY_VALUE_INDEX_CURSOR extends Cursor & ValueIndexCursor>
extends KernelAPIWriteTestBase<WriteTestSupport> {
    protected static final String DEFAULT_PROPERTY_NAME = "prop";
    protected static final String INDEX_NAME = "myIndex";
    protected static final String COMPOSITE_PROPERTY_1 = "prop1";
    protected static final String COMPOSITE_PROPERTY_2 = "prop2";
    @Inject
    private OtherThread otherThread;
    @Inject
    private RandomSupport random;

    IndexOrderTestBase() {
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldRangeSeekInOrderWithTxState(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "hello"));
            this.entityWithProp(tx, "bellow");
            expected.add(this.entityWithProp(tx, "schmello"));
            expected.add(this.entityWithProp(tx, "low"));
            expected.add(this.entityWithProp(tx, "trello"));
            this.entityWithProp(tx, "yellow");
            expected.add(this.entityWithProp(tx, "loww"));
            this.entityWithProp(tx, "below");
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityWithProp(tx, "allow");
                expected.add(this.entityWithProp(tx, "now"));
                expected.add(this.entityWithProp(tx, "jello"));
                this.entityWithProp(tx, "willow");
                PropertyIndexQuery.RangePredicate query = PropertyIndexQuery.range((int)prop, (String)"hello", (boolean)true, (String)"trello", (boolean)true);
                this.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), (PropertyIndexQuery)query);
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldPrefixSeekInOrder(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "bee hive"));
            this.entityWithProp(tx, "a");
            expected.add(this.entityWithProp(tx, "become"));
            expected.add(this.entityWithProp(tx, "be"));
            expected.add(this.entityWithProp(tx, "bachelor"));
            this.entityWithProp(tx, "street smart");
            expected.add(this.entityWithProp(tx, "builder"));
            this.entityWithProp(tx, "ceasar");
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityWithProp(tx, "allow");
                expected.add(this.entityWithProp(tx, "bastard"));
                expected.add(this.entityWithProp(tx, "bully"));
                this.entityWithProp(tx, "willow");
                PropertyIndexQuery.StringPrefixPredicate query = PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"b"));
                this.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), (PropertyIndexQuery)query);
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderWithPointsWithinSameTile(IndexOrder indexOrder) throws Exception {
        Config config = Config.defaults();
        IndexSpecificSpaceFillingCurveSettings indexSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
        SpaceFillingCurve curve = indexSettings.forCrs(CoordinateReferenceSystem.WGS84);
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "a"));
            expected.add(this.entityWithProp(tx, "b"));
            for (int i = 0; i < nbrOfValues / 8; ++i) {
                double x1 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                double x2 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                double y1 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                double y2 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y1})));
                expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y2})));
                expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y1})));
                expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y2})));
            }
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                for (int i = 0; i < nbrOfValues / 8; ++i) {
                    double x1 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                    double x2 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                    double y1 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                    double y2 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                    expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y1})));
                    expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y2})));
                    expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y1})));
                    expected.add(this.entityWithProp(tx, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y2})));
                }
                expected.add(this.entityWithProp(tx, "c"));
                expected.add(this.entityWithProp(tx, "d"));
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderPointsOnly(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithProp(tx, points.next()));
            }
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                Iterator points = IndexOrderTestBase.generateBox(400000.0).iterator();
                while (points.hasNext()) {
                    expected.add(this.entityWithProp(tx, points.next()));
                }
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderPointArraysOnly(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
            }
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 100000.0).iterator();
                while (arraysOfPoints.hasNext()) {
                    expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
                }
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderWithPointsAndEntitiesBefore(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, new String[]{"a"}));
            expected.add(this.entityWithProp(tx, new String[]{"b"}));
            expected.add(this.entityWithProp(tx, new String[]{"c"}));
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithProp(tx, points.next()));
            }
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                expected.add(this.entityWithProp(tx, new String[]{"d"}));
                Iterator points = IndexOrderTestBase.generateBox(400000.0).iterator();
                while (points.hasNext()) {
                    expected.add(this.entityWithProp(tx, points.next()));
                }
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderWithPointArraysAndEntitiesBefore(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE}));
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
            }
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE, PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
                Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 100000.0).iterator();
                while (arraysOfPoints.hasNext()) {
                    expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
                }
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderWithPointsAndEntitiesAfter(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithProp(tx, points.next()));
            }
            expected.add(this.entityWithProp(tx, "a"));
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                Iterator points = IndexOrderTestBase.generateBox(400000.0).iterator();
                while (points.hasNext()) {
                    expected.add(this.entityWithProp(tx, points.next()));
                }
                expected.add(this.entityWithProp(tx, "b"));
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderWithPointArraysAndEntitiesAfter(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
            }
            expected.add(this.entityWithProp(tx, "a"));
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 100000.0).iterator();
                while (arraysOfPoints.hasNext()) {
                    expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
                }
                expected.add(this.entityWithProp(tx, "b"));
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderWithPointsAndEntitiesOnBothSides(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, new String[]{"a"}));
            expected.add(this.entityWithProp(tx, new String[]{"b"}));
            expected.add(this.entityWithProp(tx, new String[]{"c"}));
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithProp(tx, points.next()));
            }
            expected.add(this.entityWithProp(tx, "a"));
            expected.add(this.entityWithProp(tx, "b"));
            expected.add(this.entityWithProp(tx, "c"));
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                expected.add(this.entityWithProp(tx, new String[]{"d"}));
                Iterator points = IndexOrderTestBase.generateBox(400000.0).iterator();
                while (points.hasNext()) {
                    expected.add(this.entityWithProp(tx, points.next()));
                }
                expected.add(this.entityWithProp(tx, "d"));
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderWithPointArraysAndEntitiesOnBothSides(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE}));
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
            }
            expected.add(this.entityWithProp(tx, "a"));
            expected.add(this.entityWithProp(tx, "b"));
            expected.add(this.entityWithProp(tx, "c"));
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE, PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
                Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 100000.0).iterator();
                while (arraysOfPoints.hasNext()) {
                    expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
                }
                expected.add(this.entityWithProp(tx, "d"));
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderPointsAndPointArrays(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
            }
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithProp(tx, points.next()));
            }
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 100000.0).iterator();
                while (arraysOfPoints.hasNext()) {
                    expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
                }
                Iterator points = IndexOrderTestBase.generateBox(250000.0).iterator();
                while (points.hasNext()) {
                    expected.add(this.entityWithProp(tx, points.next()));
                }
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexScanInOrderPointsAndPointArraysAndEntitiesOnBothSides(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value>> expected = new ArrayList<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE}));
            expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
            }
            expected.add(this.entityWithProp(tx, new String[]{"a"}));
            expected.add(this.entityWithProp(tx, new String[]{"b"}));
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithProp(tx, points.next()));
            }
            expected.add(this.entityWithProp(tx, "a"));
            expected.add(this.entityWithProp(tx, "b"));
            tx.commit();
        }
        this.createIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                expected.add(this.entityWithProp(tx, new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
                Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 100000.0).iterator();
                while (arraysOfPoints.hasNext()) {
                    expected.add(this.entityWithProp(tx, arraysOfPoints.next()));
                }
                expected.add(this.entityWithProp(tx, new String[]{"c"}));
                Iterator points = IndexOrderTestBase.generateBox(250000.0).iterator();
                while (points.hasNext()) {
                    expected.add(this.entityWithProp(tx, points.next()));
                }
                expected.add(this.entityWithProp(tx, "c"));
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsInBothValues(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                PointValue point = (PointValue)points.next();
                expected.add(this.entityWithTwoProps(tx, point, "a"));
                expected.add(this.entityWithTwoProps(tx, point, "b"));
                expected.add(this.entityWithTwoProps(tx, "a", point));
            }
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointArraysInBothValues(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                PointValue[] points = (PointValue[])arraysOfPoints.next();
                expected.add(this.entityWithTwoProps(tx, points, "a"));
                expected.add(this.entityWithTwoProps(tx, points, "b"));
                expected.add(this.entityWithTwoProps(tx, "a", points));
            }
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsAndPointArraysInBothValues(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            List arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).collect(Collectors.toUnmodifiableList());
            List points = IndexOrderTestBase.generateBox(500000.0).collect(Collectors.toUnmodifiableList());
            int length = Math.min(arraysOfPoints.size(), points.size());
            for (int i = 0; i < length; ++i) {
                expected.add(this.entityWithTwoProps(tx, arraysOfPoints.get(i), points.get(i)));
                expected.add(this.entityWithTwoProps(tx, points.get(i), arraysOfPoints.get(i)));
            }
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsInBothValuesWithOneGapBetween(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithTwoProps(tx, new String[]{"a"}, new String[]{"b"}));
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, points.next(), "a"));
            }
            expected.add(this.entityWithTwoProps(tx, "b", new String[]{"b"}));
            points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, "b", points.next()));
            }
            expected.add(this.entityWithTwoProps(tx, "c", new String[]{"b"}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointArraysInBothValuesWithOneGapBetween(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithTwoProps(tx, new PointValue[]{PointValue.MIN_VALUE}, new PointValue[]{PointValue.MIN_VALUE}));
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, arraysOfPoints.next(), "a"));
            }
            expected.add(this.entityWithTwoProps(tx, "b", new PointValue[]{PointValue.MIN_VALUE}));
            arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, "b", arraysOfPoints.next()));
            }
            expected.add(this.entityWithTwoProps(tx, "c", new PointValue[]{PointValue.MIN_VALUE}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsInBothValuesWithTwoGapsBetween(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithTwoProps(tx, new String[]{"a"}, new String[]{"b"}));
            Iterator points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, points.next(), "a"));
            }
            expected.add(this.entityWithTwoProps(tx, "b", new String[]{"b"}));
            expected.add(this.entityWithTwoProps(tx, "b", new String[]{"c"}));
            points = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (points.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, "b", points.next()));
            }
            expected.add(this.entityWithTwoProps(tx, "c", new String[]{"b"}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointArraysInBothValuesWithTwoGapsBetween(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithTwoProps(tx, new PointValue[]{PointValue.MIN_VALUE}, new PointValue[]{PointValue.MIN_VALUE}));
            Iterator arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, arraysOfPoints.next(), "a"));
            }
            expected.add(this.entityWithTwoProps(tx, "b", new PointValue[]{PointValue.MIN_VALUE}));
            expected.add(this.entityWithTwoProps(tx, "b", new PointValue[]{PointValue.MIN_VALUE, PointValue.MIN_VALUE}));
            arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (arraysOfPoints.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, "b", arraysOfPoints.next()));
            }
            expected.add(this.entityWithTwoProps(tx, "c", new PointValue[]{PointValue.MIN_VALUE}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsInBothValuesWithGapsAndMiddlePoint(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            int i;
            expected.add(this.entityWithTwoProps(tx, new String[]{"a"}, new String[]{"b"}));
            List firstPoints = IndexOrderTestBase.generateBox(500000.0).collect(Collectors.toUnmodifiableList());
            for (i = 0; i < firstPoints.size() - 1; ++i) {
                expected.add(this.entityWithTwoProps(tx, firstPoints.get(i), "a"));
            }
            expected.add(this.entityWithTwoProps(tx, "a", firstPoints.get(i)));
            expected.add(this.entityWithTwoProps(tx, "b", new String[]{"c"}));
            Iterator secondPoints = IndexOrderTestBase.generateBox(500000.0).iterator();
            while (secondPoints.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, "b", secondPoints.next()));
            }
            expected.add(this.entityWithTwoProps(tx, "c", new String[]{"b"}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointArraysInBothValuesWithGapsAndMiddlePointArray(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            int i;
            expected.add(this.entityWithTwoProps(tx, new PointValue[]{PointValue.MIN_VALUE}, new PointValue[]{PointValue.MIN_VALUE}));
            List firstArraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).collect(Collectors.toUnmodifiableList());
            for (i = 0; i < firstArraysOfPoints.size() - 1; ++i) {
                expected.add(this.entityWithTwoProps(tx, firstArraysOfPoints.get(i), "a"));
            }
            expected.add(this.entityWithTwoProps(tx, "a", firstArraysOfPoints.get(i)));
            expected.add(this.entityWithTwoProps(tx, "b", new PointValue[]{PointValue.MIN_VALUE}));
            Iterator secondArraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).iterator();
            while (secondArraysOfPoints.hasNext()) {
                expected.add(this.entityWithTwoProps(tx, "b", secondArraysOfPoints.next()));
            }
            expected.add(this.entityWithTwoProps(tx, "c", new PointValue[]{PointValue.MIN_VALUE}));
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldDoOrderedCompositeIndexScanWithPointsAndPointArraysAndEntitiesMixed(IndexOrder indexOrder) throws Exception {
        ArrayList<Pair<Long, Value[]>> expected = new ArrayList<Pair<Long, Value[]>>();
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            List arraysOfPoints = IndexOrderTestBase.generateArraysOfPoints(4, 10000.0).collect(Collectors.toUnmodifiableList());
            List points = IndexOrderTestBase.generateBox(500000.0).collect(Collectors.toUnmodifiableList());
            int length = Math.min(arraysOfPoints.size(), points.size());
            for (int i = 0; i < length; ++i) {
                expected.add(this.entityWithTwoProps(tx, arraysOfPoints.get(i), points.get(i)));
                expected.add(this.entityWithTwoProps(tx, arraysOfPoints.get(i), "a"));
                expected.add(this.entityWithTwoProps(tx, points.get(i), arraysOfPoints.get(i)));
                expected.add(this.entityWithTwoProps(tx, points.get(i), "a"));
                expected.add(this.entityWithTwoProps(tx, "a", arraysOfPoints.get(i)));
                expected.add(this.entityWithTwoProps(tx, "a", points.get(i)));
            }
            tx.commit();
        }
        this.createCompositeIndex();
        tx = IndexOrderTestBase.beginTransaction();
        try {
            IndexReadSession index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            try (ENTITY_VALUE_INDEX_CURSOR cursor = this.getEntityValueIndexCursor(tx);){
                this.entityIndexScan(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true));
                this.assertCompositeResultsInOrder(expected, cursor, indexOrder);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldEntityIndexSeekInOrderWithStringInMemoryAndConcurrentUpdate(IndexOrder indexOrder) throws Exception {
        PropertyIndexQuery.StringPrefixPredicate query;
        Object cursor;
        IndexReadSession index;
        int prop;
        String a = "a";
        String b = "b";
        String c = "c";
        this.createIndex();
        TextValue expectedFirst = indexOrder == IndexOrder.ASCENDING ? Values.stringValue((String)a) : Values.stringValue((String)c);
        TextValue expectedLast = indexOrder == IndexOrder.ASCENDING ? Values.stringValue((String)c) : Values.stringValue((String)a);
        try (KernelTransaction tx = IndexOrderTestBase.beginTransaction();){
            prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            this.entityWithProp(tx, a);
            this.entityWithProp(tx, c);
            index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            cursor = this.getEntityValueIndexCursor(tx);
            try {
                query = PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)""));
                this.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), (PropertyIndexQuery)query);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)((ValueIndexCursor)cursor).propertyValue(0)).isEqualTo((Object)expectedFirst);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)((ValueIndexCursor)cursor).propertyValue(0)).isEqualTo((Object)expectedLast);
                this.concurrentInsert(b);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next(), () -> "Did not expect to find anything more but found " + String.valueOf(((ValueIndexCursor)cursor).propertyValue(0)));
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            tx.commit();
        }
        tx = IndexOrderTestBase.beginTransaction();
        try {
            prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            index = tx.dataRead().indexReadSession(tx.schemaRead().indexGetForName(INDEX_NAME));
            cursor = this.getEntityValueIndexCursor(tx);
            try {
                query = PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)""));
                this.entityIndexSeek(tx, index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)true), (PropertyIndexQuery)query);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)((ValueIndexCursor)cursor).propertyValue(0)).isEqualTo((Object)expectedFirst);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)((ValueIndexCursor)cursor).propertyValue(0)).isEqualTo((Object)Values.stringValue((String)b));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((Object)((ValueIndexCursor)cursor).propertyValue(0)).isEqualTo((Object)expectedLast);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void concurrentInsert(Object value) throws InterruptedException, ExecutionException {
        this.otherThread.execute(() -> {
            try (KernelTransaction otherTx = IndexOrderTestBase.beginTransaction();){
                this.entityWithProp(otherTx, value);
                otherTx.commit();
            }
            return null;
        }).get();
    }

    private static Stream<PointValue> generateBox(double scale) {
        return Stream.of(IntStream.of(-1, -1), IntStream.of(1, -1), IntStream.of(-1, 1), IntStream.of(1, 1)).map(rs -> rs.mapToDouble(r -> (double)r * scale)).map(rs -> Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])rs.toArray()));
    }

    private static Stream<PointValue[]> generateArraysOfPoints(int n, double scale) {
        return IntStream.rangeClosed(1, n).mapToObj(i -> IndexOrderTestBase.generateBox((double)i * scale)).map(points -> (PointValue[])points.toArray(PointValue[]::new));
    }

    protected void assertResultsInOrder(List<Pair<Long, Value>> expected, ENTITY_VALUE_INDEX_CURSOR cursor, IndexOrder indexOrder) {
        Comparator<Pair> comparator = Comparator.comparing(Pair::other, Values.COMPARATOR);
        expected.sort(indexOrder == IndexOrder.ASCENDING ? comparator : comparator.reversed());
        Iterator<Pair<Long, Value>> expectedRows = expected.iterator();
        while (cursor.next() && expectedRows.hasNext()) {
            Pair<Long, Value> expectedRow = expectedRows.next();
            ((AbstractLongAssert)Assertions.assertThat((long)this.entityReference(cursor)).as(String.valueOf(expectedRow.other()) + " == " + String.valueOf(((ValueIndexCursor)cursor).propertyValue(0)), new Object[0])).isEqualTo(expectedRow.first());
            for (int i = 0; i < ((ValueIndexCursor)cursor).numberOfProperties(); ++i) {
                Value value = ((ValueIndexCursor)cursor).propertyValue(i);
                Assertions.assertThat((Object)value).isEqualTo(expectedRow.other());
            }
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)expectedRows.hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
    }

    private void assertCompositeResultsInOrder(List<Pair<Long, Value[]>> expected, ENTITY_VALUE_INDEX_CURSOR cursor, IndexOrder indexOrder) {
        Comparator comparator = (a, b) -> {
            int compare = Values.COMPARATOR.compare(((Value[])a.other())[0], ((Value[])b.other())[0]);
            return compare != 0 ? compare : Values.COMPARATOR.compare(((Value[])a.other())[1], ((Value[])b.other())[1]);
        };
        expected.sort(indexOrder == IndexOrder.ASCENDING ? comparator : comparator.reversed());
        Iterator<Pair<Long, Value[]>> expectedRows = expected.iterator();
        while (cursor.next() && expectedRows.hasNext()) {
            Pair<Long, Value[]> expectedRow = expectedRows.next();
            ((AbstractLongAssert)Assertions.assertThat((long)this.entityReference(cursor)).as(String.valueOf(((Value[])expectedRow.other())[0]) + " == " + String.valueOf(((ValueIndexCursor)cursor).propertyValue(0)) + " && " + String.valueOf(((Value[])expectedRow.other())[1]) + " == " + String.valueOf(((ValueIndexCursor)cursor).propertyValue(1)), new Object[0])).isEqualTo(expectedRow.first());
            for (int i = 0; i < ((ValueIndexCursor)cursor).numberOfProperties(); ++i) {
                Value value = ((ValueIndexCursor)cursor).propertyValue(i);
                Assertions.assertThat((Object)value).isEqualTo((Object)((Value[])expectedRow.other())[i]);
            }
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)expectedRows.hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    protected abstract void createIndex();

    protected abstract void createCompositeIndex();

    protected abstract long entityReference(ENTITY_VALUE_INDEX_CURSOR var1);

    protected abstract Pair<Long, Value> entityWithProp(KernelTransaction var1, Object var2) throws Exception;

    protected abstract Pair<Long, Value[]> entityWithTwoProps(KernelTransaction var1, Object var2, Object var3) throws Exception;

    protected abstract ENTITY_VALUE_INDEX_CURSOR getEntityValueIndexCursor(KernelTransaction var1);

    protected abstract void entityIndexScan(KernelTransaction var1, IndexReadSession var2, ENTITY_VALUE_INDEX_CURSOR var3, IndexQueryConstraints var4) throws KernelException;

    protected abstract void entityIndexSeek(KernelTransaction var1, IndexReadSession var2, ENTITY_VALUE_INDEX_CURSOR var3, IndexQueryConstraints var4, PropertyIndexQuery var5) throws KernelException;
}

