/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexScanPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexSeekPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.TokenIndexScanPartitionedScanTestSuite;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Id;

class PartitionedScanFactories {
    PartitionedScanFactories() {
    }

    static final class PropertyKey
    extends Tag<String> {
        public static final PropertyKey FACTORY = new PropertyKey();

        private PropertyKey() {
        }

        @Override
        protected Tag.TagFromName<String> fromName() {
            return name -> name;
        }

        @Override
        int createId(KernelTransaction tx, String propertyKey) throws KernelException {
            return tx.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
        }
    }

    static final class RelationshipType
    extends Tag<org.neo4j.graphdb.RelationshipType> {
        public static final RelationshipType FACTORY = new RelationshipType();

        private RelationshipType() {
        }

        @Override
        protected Tag.TagFromName<org.neo4j.graphdb.RelationshipType> fromName() {
            return org.neo4j.graphdb.RelationshipType::withName;
        }

        @Override
        int createId(KernelTransaction tx, org.neo4j.graphdb.RelationshipType relType) throws KernelException {
            return tx.tokenWrite().relationshipTypeGetOrCreateForName(relType.name());
        }
    }

    static final class Label
    extends Tag<org.neo4j.graphdb.Label> {
        public static final Label FACTORY = new Label();

        private Label() {
        }

        @Override
        protected Tag.TagFromName<org.neo4j.graphdb.Label> fromName() {
            return org.neo4j.graphdb.Label::label;
        }

        @Override
        int createId(KernelTransaction tx, org.neo4j.graphdb.Label label) throws KernelException {
            return tx.tokenWrite().labelGetOrCreateForName(label.name());
        }
    }

    static abstract class Tag<TAG>
    implements Supplier<TAG> {
        Tag() {
        }

        protected abstract TagFromName<TAG> fromName();

        abstract int createId(KernelTransaction var1, TAG var2) throws KernelException;

        @Override
        public final TAG get() {
            Id id = new Id(UUID.randomUUID());
            return this.fromName().generate(this.name() + "_" + String.valueOf(id));
        }

        final String name() {
            return this.getClass().getSimpleName();
        }

        final List<TAG> generate(int numberOfTags) {
            return Stream.generate(this).limit(numberOfTags).collect(Collectors.toUnmodifiableList());
        }

        final List<Integer> createIds(KernelTransaction tx, Iterable<TAG> tags) throws KernelException {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (TAG tag : tags) {
                ids.add(this.createId(tx, tag));
            }
            return ids;
        }

        final List<Integer> generateAndCreateIds(KernelTransaction tx, int numberOfTags) throws KernelException {
            return this.createIds(tx, this.generate(numberOfTags));
        }

        static interface TagFromName<TAG> {
            public TAG generate(String var1);
        }
    }

    @FunctionalInterface
    static interface CursorWithContext<CURSOR extends Cursor> {
        public CURSOR with(CursorContext var1);
    }

    static final class RelationshipPropertyIndexScan
    extends PropertyIndex<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery, RelationshipValueIndexCursor> {
        public static final RelationshipPropertyIndexScan FACTORY = new RelationshipPropertyIndexScan();

        private RelationshipPropertyIndexScan() {
        }

        NodePropertyIndexScan getEntityTypeComplimentFactory() {
            return NodePropertyIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<RelationshipValueIndexCursor> partitionedScan(KernelTransaction tx, PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery propertyKeyScanQuery, IndexReadSession session, int desiredNumberOfPartitions) throws KernelException {
            return tx.dataRead().relationshipIndexScan(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT);
        }

        @Override
        CursorWithContext<RelationshipValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateRelationshipValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(RelationshipValueIndexCursor cursor) {
            return cursor.relationshipReference();
        }

        RelationshipType getTokenFactory() {
            return RelationshipType.FACTORY;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int relTypeId, int ... propKeyIds) {
            return SchemaDescriptors.forRelType((int)relTypeId, (int[])propKeyIds);
        }
    }

    static final class RelationshipPropertyIndexSeek
    extends PropertyIndex<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery, RelationshipValueIndexCursor> {
        public static final RelationshipPropertyIndexSeek FACTORY = new RelationshipPropertyIndexSeek();

        private RelationshipPropertyIndexSeek() {
        }

        NodePropertyIndexSeek getEntityTypeComplimentFactory() {
            return NodePropertyIndexSeek.FACTORY;
        }

        @Override
        PartitionedScan<RelationshipValueIndexCursor> partitionedScan(KernelTransaction tx, PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery propertyKeySeekQuery, IndexReadSession session, int desiredNumberOfPartitions) throws KernelException {
            return tx.dataRead().relationshipIndexSeek(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT, propertyKeySeekQuery.get());
        }

        @Override
        CursorWithContext<RelationshipValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateRelationshipValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(RelationshipValueIndexCursor cursor) {
            return cursor.relationshipReference();
        }

        RelationshipType getTokenFactory() {
            return RelationshipType.FACTORY;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int relTypeId, int ... propKeyIds) {
            return SchemaDescriptors.forRelType((int)relTypeId, (int[])propKeyIds);
        }
    }

    static final class NodePropertyIndexScan
    extends PropertyIndex<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery, NodeValueIndexCursor> {
        public static final NodePropertyIndexScan FACTORY = new NodePropertyIndexScan();

        private NodePropertyIndexScan() {
        }

        RelationshipPropertyIndexScan getEntityTypeComplimentFactory() {
            return RelationshipPropertyIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<NodeValueIndexCursor> partitionedScan(KernelTransaction tx, PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery propertyKeyScanQuery, IndexReadSession session, int desiredNumberOfPartitions) throws KernelException {
            return tx.dataRead().nodeIndexScan(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT);
        }

        @Override
        CursorWithContext<NodeValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateNodeValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(NodeValueIndexCursor cursor) {
            return cursor.nodeReference();
        }

        Label getTokenFactory() {
            return Label.FACTORY;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int labelId, int ... propKeyIds) {
            return SchemaDescriptors.forLabel((int)labelId, (int[])propKeyIds);
        }
    }

    static final class NodePropertyIndexSeek
    extends PropertyIndex<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery, NodeValueIndexCursor> {
        public static final NodePropertyIndexSeek FACTORY = new NodePropertyIndexSeek();

        private NodePropertyIndexSeek() {
        }

        RelationshipPropertyIndexSeek getEntityTypeComplimentFactory() {
            return RelationshipPropertyIndexSeek.FACTORY;
        }

        @Override
        PartitionedScan<NodeValueIndexCursor> partitionedScan(KernelTransaction tx, PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery propertyKeySeekQuery, IndexReadSession session, int desiredNumberOfPartitions) throws KernelException {
            return tx.dataRead().nodeIndexSeek(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT, propertyKeySeekQuery.get());
        }

        @Override
        CursorWithContext<NodeValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateNodeValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(NodeValueIndexCursor cursor) {
            return cursor.nodeReference();
        }

        Label getTokenFactory() {
            return Label.FACTORY;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int labelId, int ... propKeyIds) {
            return SchemaDescriptors.forLabel((int)labelId, (int[])propKeyIds);
        }
    }

    static abstract class PropertyIndex<QUERY extends PartitionedScanTestSuite.Query<?>, CURSOR extends Cursor>
    extends PartitionedScanFactory<QUERY, IndexReadSession, CURSOR> {
        PropertyIndex() {
        }

        abstract SchemaDescriptor getSchemaDescriptor(int var1, int ... var2);

        abstract Tag<?> getTokenFactory();

        final PropertyKey getPropKeyFactory() {
            return PropertyKey.FACTORY;
        }

        final String getIndexName(int tokenId, int ... propKeyIds) {
            return String.format("%s[%s[%d] {%s}]", this.name(), this.getTokenFactory().name(), tokenId, Arrays.stream(propKeyIds).mapToObj(String::valueOf).collect(Collectors.joining(",")));
        }

        @Override
        protected final IndexReadSession getSession(KernelTransaction tx, QUERY query) throws KernelException {
            IndexDescriptor index = tx.schemaRead().indexGetForName(query.indexName());
            return tx.dataRead().indexReadSession(index);
        }

        protected final IndexDescriptor getIndex(KernelTransaction tx, String name) {
            return tx.schemaRead().indexGetForName(name);
        }

        protected final IndexDescriptor getIndex(KernelTransaction tx, int tokenId, int ... propKeyIds) {
            return this.getIndex(tx, this.getIndexName(tokenId, propKeyIds));
        }
    }

    static final class RelationshipTypeIndexScan
    extends TokenIndex<RelationshipTypeIndexCursor> {
        public static final RelationshipTypeIndexScan FACTORY = new RelationshipTypeIndexScan();

        private RelationshipTypeIndexScan() {
        }

        NodeLabelIndexScan getEntityTypeComplimentFactory() {
            return NodeLabelIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<RelationshipTypeIndexCursor> partitionedScan(KernelTransaction tx, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery tokenScanQuery, TokenReadSession session, int desiredNumberOfPartitions) throws KernelException {
            return tx.dataRead().relationshipTypeScan(session, desiredNumberOfPartitions, CursorContext.NULL, tokenScanQuery.get());
        }

        @Override
        CursorWithContext<RelationshipTypeIndexCursor> getCursor(CursorFactory cursors) {
            return arg_0 -> ((CursorFactory)cursors).allocateRelationshipTypeIndexCursor(arg_0);
        }

        @Override
        long getEntityReference(RelationshipTypeIndexCursor cursor) {
            return cursor.relationshipReference();
        }
    }

    static final class NodeLabelIndexScan
    extends TokenIndex<NodeLabelIndexCursor> {
        public static final NodeLabelIndexScan FACTORY = new NodeLabelIndexScan();

        private NodeLabelIndexScan() {
        }

        RelationshipTypeIndexScan getEntityTypeComplimentFactory() {
            return RelationshipTypeIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<NodeLabelIndexCursor> partitionedScan(KernelTransaction tx, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery tokenScanQuery, TokenReadSession session, int desiredNumberOfPartitions) throws KernelException {
            return tx.dataRead().nodeLabelScan(session, desiredNumberOfPartitions, CursorContext.NULL, tokenScanQuery.get());
        }

        @Override
        CursorWithContext<NodeLabelIndexCursor> getCursor(CursorFactory cursors) {
            return arg_0 -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(arg_0);
        }

        @Override
        long getEntityReference(NodeLabelIndexCursor cursor) {
            return cursor.nodeReference();
        }
    }

    static abstract class TokenIndex<CURSOR extends Cursor>
    extends PartitionedScanFactory<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery, TokenReadSession, CURSOR> {
        TokenIndex() {
        }

        @Override
        protected final TokenReadSession getSession(KernelTransaction tx, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery query) throws KernelException {
            IndexDescriptor index = tx.schemaRead().indexGetForName(query.indexName());
            return tx.dataRead().tokenReadSession(index);
        }
    }

    static abstract class PartitionedScanFactory<QUERY extends PartitionedScanTestSuite.Query<?>, SESSION, CURSOR extends Cursor> {
        PartitionedScanFactory() {
        }

        abstract PartitionedScanFactory<QUERY, SESSION, ? extends Cursor> getEntityTypeComplimentFactory();

        abstract SESSION getSession(KernelTransaction var1, QUERY var2) throws KernelException;

        abstract CursorWithContext<CURSOR> getCursor(CursorFactory var1);

        abstract long getEntityReference(CURSOR var1);

        abstract PartitionedScan<CURSOR> partitionedScan(KernelTransaction var1, QUERY var2, SESSION var3, int var4) throws KernelException;

        final PartitionedScan<CURSOR> partitionedScan(KernelTransaction tx, QUERY query, int desiredNumberOfPartitions) throws KernelException {
            return this.partitionedScan(tx, query, this.getSession(tx, query), desiredNumberOfPartitions);
        }

        final String name() {
            return this.getClass().getSimpleName();
        }
    }
}

