/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexReadAsserts;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestKernelReadTracer;

abstract class RelationshipTypeIndexCursorTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private final int typeOne = 1;
    private final int typeTwo = 2;
    private final int typeThree = 3;

    RelationshipTypeIndexCursorTestBase() {
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class)
    void shouldFindRelationshipsByType(IndexOrder order) throws KernelException {
        long relThree3;
        long relThree2;
        long relTwo2;
        long toDelete;
        long relThree;
        long relTwo;
        try (KernelTransaction tx = RelationshipTypeIndexCursorTestBase.beginTransaction();){
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            relTwo = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            relThree = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 3);
            toDelete = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            relTwo2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            relThree2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 3);
            relThree3 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 3);
            tx.commit();
        }
        tx = RelationshipTypeIndexCursorTestBase.beginTransaction();
        try {
            tx.dataWrite().relationshipDelete(toDelete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = RelationshipTypeIndexCursorTestBase.beginTransaction();
        try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL);){
            LongHashSet uniqueIds = new LongHashSet();
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, order);
            IndexReadAsserts.assertRelationshipCount((RelationshipIndexCursor)cursor, 1, (MutableLongSet)uniqueIds);
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 2, cursor, order);
            IndexReadAsserts.assertRelationships((RelationshipIndexCursor)cursor, (MutableLongSet)uniqueIds, order, relTwo, relTwo2);
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 3, cursor, order);
            IndexReadAsserts.assertRelationships((RelationshipIndexCursor)cursor, (MutableLongSet)uniqueIds, order, relThree, relThree2, relThree3);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class)
    void shouldFindRelationshipsByTypeInTx(IndexOrder order) throws KernelException {
        long inStore2;
        long deletedInTx;
        long inStore;
        try (KernelTransaction tx = RelationshipTypeIndexCursorTestBase.beginTransaction();){
            inStore = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            deletedInTx = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            inStore2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            tx.commit();
        }
        tx = RelationshipTypeIndexCursorTestBase.beginTransaction();
        try {
            tx.dataWrite().relationshipDelete(deletedInTx);
            long createdInTx = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            long createdInTx2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL);){
                LongHashSet uniqueIds = new LongHashSet();
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, order);
                IndexReadAsserts.assertRelationships((RelationshipIndexCursor)cursor, (MutableLongSet)uniqueIds, order, inStore, inStore2, createdInTx, createdInTx2);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldTraceRelationshipTypeScanEvents() throws KernelException {
        long third;
        long second;
        long first;
        try (KernelTransaction tx = RelationshipTypeIndexCursorTestBase.beginTransaction();){
            first = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            second = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            third = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            tx.commit();
        }
        tx = RelationshipTypeIndexCursorTestBase.beginTransaction();
        try {
            Read read = tx.dataRead();
            try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL);){
                TestKernelReadTracer tracer = new TestKernelReadTracer();
                cursor.setTracer((KernelReadTracer)tracer);
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, IndexOrder.NONE);
                RelationshipTypeIndexCursorTestBase.exhaustCursor(cursor);
                tracer.assertEvents(new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.RelationshipTypeScan, 1L), new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.Relationship, first));
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 2, cursor, IndexOrder.NONE);
                RelationshipTypeIndexCursorTestBase.exhaustCursor(cursor);
                tracer.assertEvents(new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.RelationshipTypeScan, 2L), new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.Relationship, second), new TestKernelReadTracer.TraceEvent(TestKernelReadTracer.TraceEventKind.Relationship, third));
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void exhaustCursor(RelationshipTypeIndexCursor cursor) {
        while (cursor.next()) {
        }
    }

    private static long createRelationship(Write write, int type) throws KernelException {
        long sourceNode = write.nodeCreate();
        long targetNode = write.nodeCreate();
        return write.relationshipCreate(sourceNode, type, targetNode);
    }

    private static void relationshipTypeScan(KernelTransaction tx, int label, RelationshipTypeIndexCursor cursor, IndexOrder indexOrder) throws KernelException {
        IndexDescriptor index = tx.schemaRead().indexGetForName("rti");
        TokenReadSession tokenReadSession = tx.dataRead().tokenReadSession(index);
        tx.dataRead().relationshipTypeScan(tokenReadSession, cursor, IndexQueryConstraints.ordered((IndexOrder)indexOrder), new TokenPredicate(label), tx.cursorContext());
    }
}

