/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenOverwritingIdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.LogsUpgrader;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
public class StoreUpgraderTest {
    private static final String INTERNAL_LOG_FILE = "debug.log";
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fileSystem;
    private RecordDatabaseLayout databaseLayout;
    private JobScheduler jobScheduler;
    private final Config allowMigrateConfig = Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)true);
    private Path prepareDatabaseDirectory;

    private static Collection<Arguments> versions() {
        return Collections.singletonList(Arguments.arguments((Object[])new Object[]{StandardV3_4.RECORD_FORMATS}));
    }

    @BeforeEach
    void prepareDb() {
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    private void init(RecordFormats formats) throws IOException {
        String version = formats.storeVersion();
        this.databaseLayout = RecordDatabaseLayout.of((Neo4jLayout)this.neo4jLayout, (String)("db-" + version));
        this.prepareDatabaseDirectory = this.testDirectory.directory("prepare_" + version);
        this.prepareSampleDatabase(version, this.fileSystem, (DatabaseLayout)this.databaseLayout, this.prepareDatabaseDirectory);
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void forbidRegistrationOfParticipantsWithSameName(RecordFormats formats) throws IOException {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        StoreUpgrader upgrader = this.newUpgrader(check, this.allowMigrateConfig, this.pageCache);
        upgrader.addParticipant((StoreMigrationParticipant)new EmptyNamedMigrationParticipant("foo"));
        Assertions.assertThrows(IllegalStateException.class, () -> upgrader.addParticipant((StoreMigrationParticipant)new EmptyNamedMigrationParticipant("foo")));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldHaltUpgradeIfUpgradeConfigurationVetoesTheProcess(RecordFormats formats) throws IOException {
        this.init(formats);
        Config deniedMigrationConfig = Config.newBuilder().set(GraphDatabaseSettings.allow_upgrade, (Object)false).set(GraphDatabaseSettings.record_format, (Object)Standard.LATEST_NAME).build();
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Assertions.assertThrows(UpgradeNotAllowedException.class, () -> this.newUpgrader(check, deniedMigrationConfig, this.pageCache).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldRefuseToUpgradeIfAnyOfTheStoresWereNotShutDownCleanly(RecordFormats formats) throws IOException {
        this.init(formats);
        Path comparisonDirectory = this.testDirectory.directory("shouldRefuseToUpgradeIfAnyOfTheStoresWereNotShutDownCleanly-comparison");
        StoreUpgraderTest.removeCheckPointFromTxLog(this.fileSystem, this.databaseLayout.databaseDirectory());
        this.fileSystem.deleteRecursively(comparisonDirectory);
        this.fileSystem.copyRecursively(this.databaseLayout.databaseDirectory(), comparisonDirectory);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Assertions.assertThrows(StoreUpgrader.UnableToUpgradeException.class, () -> this.newUpgrader(check, this.pageCache).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false));
        MigrationTestUtils.verifyFilesHaveSameContent((FileSystemAbstraction)this.fileSystem, (Path)comparisonDirectory, (Path)this.databaseLayout.databaseDirectory());
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldRefuseToUpgradeIfAllOfTheStoresWereNotShutDownCleanly(RecordFormats formats) throws IOException {
        this.init(formats);
        Path comparisonDirectory = this.testDirectory.directory("shouldRefuseToUpgradeIfAllOfTheStoresWereNotShutDownCleanly-comparison");
        StoreUpgraderTest.removeCheckPointFromTxLog(this.fileSystem, this.databaseLayout.databaseDirectory());
        this.fileSystem.deleteRecursively(comparisonDirectory);
        this.fileSystem.copyRecursively(this.databaseLayout.databaseDirectory(), comparisonDirectory);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Assertions.assertThrows(StoreUpgrader.UnableToUpgradeException.class, () -> this.newUpgrader(check, this.pageCache).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false));
        MigrationTestUtils.verifyFilesHaveSameContent((FileSystemAbstraction)this.fileSystem, (Path)comparisonDirectory, (Path)this.databaseLayout.databaseDirectory());
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void shouldContinueMovingFilesIfUpgradeCancelledWhileMoving(RecordFormats formats) throws Exception {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        String versionToMigrateTo = check.configuredVersion();
        StoreVersionCheck.Result upgradeResult = check.checkUpgrade(check.configuredVersion(), CursorContext.NULL);
        Assertions.assertTrue((boolean)upgradeResult.outcome.isSuccessful());
        String versionToMigrateFrom = upgradeResult.actualVersion;
        StoreUpgrader upgrader = this.newUpgrader(check, this.allowMigrateConfig, this.pageCache);
        String failureMessage = "Just failing";
        upgrader.addParticipant(StoreUpgraderTest.participantThatWillFailWhenMoving(failureMessage));
        StoreUpgrader.UnableToUpgradeException e = (StoreUpgrader.UnableToUpgradeException)Assertions.assertThrows(StoreUpgrader.UnableToUpgradeException.class, () -> upgrader.migrateIfNeeded((DatabaseLayout)this.databaseLayout, false));
        Assertions.assertTrue((boolean)(e.getCause() instanceof IOException));
        Assertions.assertEquals((Object)failureMessage, (Object)e.getCause().getMessage());
        upgrader = this.newUpgrader(check, this.pageCache);
        StoreMigrationParticipant observingParticipant = (StoreMigrationParticipant)Mockito.mock(StoreMigrationParticipant.class);
        upgrader.addParticipant(observingParticipant);
        upgrader.migrateIfNeeded((DatabaseLayout)this.databaseLayout, false);
        ((StoreMigrationParticipant)Mockito.verify((Object)observingParticipant, (VerificationMode)Mockito.never())).migrate((DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (ProgressReporter)ArgumentMatchers.any(ProgressReporter.class), (String)ArgumentMatchers.eq((Object)versionToMigrateFrom), (String)ArgumentMatchers.eq((Object)versionToMigrateTo), (IndexImporterFactory)ArgumentMatchers.eq((Object)IndexImporterFactory.EMPTY));
        ((StoreMigrationParticipant)Mockito.verify((Object)observingParticipant)).moveMigratedFiles((DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class), (String)ArgumentMatchers.eq((Object)versionToMigrateFrom), (String)ArgumentMatchers.eq((Object)versionToMigrateTo));
        ((StoreMigrationParticipant)Mockito.verify((Object)observingParticipant)).cleanup((DatabaseLayout)ArgumentMatchers.any(DatabaseLayout.class));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradedNeoStoreShouldHaveNewUpgradeTimeAndUpgradeId(RecordFormats formats) throws Exception {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        this.newUpgrader(check, this.allowMigrateConfig, this.pageCache).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false);
        this.verifyStoreUpgradedWithin(1L, TimeUnit.MINUTES);
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void tracePageCacheAccessOnStoreUpgrade(RecordFormats formats) throws IOException {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        this.newUpgrader(check, this.allowMigrateConfig, this.pageCache, (PageCacheTracer)pageCacheTracer).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false);
        LogAssertions.assertThat((long)pageCacheTracer.hits()).isGreaterThan(0L);
        LogAssertions.assertThat((long)pageCacheTracer.pins()).isGreaterThan(0L);
        LogAssertions.assertThat((long)pageCacheTracer.unpins()).isGreaterThan(0L);
        LogAssertions.assertThat((long)pageCacheTracer.faults()).isGreaterThan(0L);
        StoreFactory factory = new StoreFactory((DatabaseLayout)this.databaseLayout, this.allowMigrateConfig, (IdGeneratorFactory)new ScanOnOpenOverwritingIdGeneratorFactory(this.fileSystem, this.databaseLayout.getDatabaseName()), this.pageCache, this.fileSystem, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL, DatabaseReadOnlyChecker.writable());
        try (NeoStores neoStores = factory.openAllNeoStores();){
            LogAssertions.assertThat((Object)neoStores.getMetaDataStore().getUpgradeTransaction()).isEqualTo((Object)neoStores.getMetaDataStore().getLastCommittedTransaction());
            LogAssertions.assertThat((long)neoStores.getMetaDataStore().getUpgradeTime()).isPositive();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void tracePageCacheAccessOnVersionCheck(RecordFormats formats) throws IOException {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        new RecordStoreVersionCheck(this.fileSystem, this.pageCache, this.databaseLayout, (LogProvider)NullLogProvider.getInstance(), Config.defaults(), (PageCacheTracer)pageCacheTracer);
        LogAssertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(0L);
        LogAssertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(1L);
        LogAssertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(1L);
        LogAssertions.assertThat((long)pageCacheTracer.faults()).isEqualTo(1L);
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeShouldNotLeaveLeftoverAndMigrationDirs(RecordFormats formats) throws Exception {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        this.newUpgrader(check, this.allowMigrateConfig, this.pageCache).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false);
        LogAssertions.assertThat(this.migrationHelperDirs()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeShouldGiveProgressMonitorProgressMessages(RecordFormats formats) throws Exception {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.newUpgrader(check, this.pageCache, this.allowMigrateConfig, (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Store files", "Indexes", "Successfully finished"});
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgraderShouldCleanupLegacyLeftoverAndMigrationDirs(RecordFormats formats) throws Exception {
        this.init(formats);
        this.fileSystem.deleteFile(this.databaseLayout.file(INTERNAL_LOG_FILE));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup_1"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup_2"));
        this.fileSystem.mkdir(this.databaseLayout.file("upgrade_backup_42"));
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        StoreUpgrader storeUpgrader = this.newUpgrader(check, this.pageCache);
        storeUpgrader.migrateIfNeeded((DatabaseLayout)this.databaseLayout, false);
        LogAssertions.assertThat(this.migrationHelperDirs()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeFailsIfMigrationIsNotAllowed(RecordFormats formats) throws IOException {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Assertions.assertThrows(UpgradeNotAllowedException.class, () -> this.newUpgrader(check, this.pageCache, Config.defaults(), (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded((DatabaseLayout)this.databaseLayout, false));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void upgradeMoveTransactionLogs(RecordFormats formats) throws IOException {
        this.init(formats);
        Path txRoot = this.testDirectory.directory("customTxRoot");
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Config config = Config.newBuilder().fromConfig(this.allowMigrateConfig).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)txRoot.toAbsolutePath()).set(GraphDatabaseSettings.default_database, (Object)this.databaseLayout.getDatabaseName()).build();
        DatabaseLayout migrationLayout = DatabaseLayout.of((Config)config);
        this.newUpgrader(check, this.pageCache, config, (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded(migrationLayout, false);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Starting transaction logs migration.", "Transaction logs migration completed."});
        LogAssertions.assertThat((Object[])this.getLogFiles(migrationLayout.databaseDirectory())).isEmpty();
        Path databaseTransactionLogsHome = txRoot.resolve(migrationLayout.getDatabaseName());
        Assertions.assertTrue((boolean)this.fileSystem.fileExists(databaseTransactionLogsHome));
        Set<String> logFileNames = this.getLogFileNames(databaseTransactionLogsHome);
        LogAssertions.assertThat(logFileNames).isNotEmpty();
        LogAssertions.assertThat(logFileNames).containsAll(this.getLogFileNames(this.prepareDatabaseDirectory));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void failToMoveTransactionLogsIfTheyAlreadyExist(RecordFormats formats) throws IOException {
        this.init(formats);
        Path txRoot = this.testDirectory.directory("customTxRoot");
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        Config config = Config.newBuilder().fromConfig(this.allowMigrateConfig).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)txRoot.toAbsolutePath()).set(GraphDatabaseSettings.default_database, (Object)this.databaseLayout.getDatabaseName()).build();
        DatabaseLayout migrationLayout = DatabaseLayout.of((Config)config);
        Path databaseTransactionLogsHome = txRoot.resolve(migrationLayout.getDatabaseName());
        this.fileSystem.mkdir(databaseTransactionLogsHome);
        this.createDummyTxLogFiles(databaseTransactionLogsHome);
        Assertions.assertThrows(StoreUpgrader.TransactionLogsRelocationException.class, () -> this.newUpgrader(check, this.pageCache, config, (MigrationProgressMonitor)new VisibleMigrationProgressMonitor(logProvider.getLog("test"))).migrateIfNeeded(migrationLayout, false));
    }

    @ParameterizedTest
    @MethodSource(value={"versions"})
    void notParticipatingParticipantsAreNotPartOfMigration(RecordFormats formats) throws IOException {
        this.init(formats);
        StoreVersionCheck check = this.getVersionCheck(this.pageCache);
        StoreUpgrader storeUpgrader = this.newUpgrader(check, this.pageCache);
        LogAssertions.assertThat((List)storeUpgrader.getParticipants()).hasSize(2);
    }

    private void createDummyTxLogFiles(Path databaseTransactionLogsHome) throws IOException {
        Set<String> preparedLogFiles = this.getLogFileNames(this.prepareDatabaseDirectory);
        LogAssertions.assertThat(preparedLogFiles).isNotEmpty();
        for (String preparedLogFile : preparedLogFiles) {
            this.fileSystem.write(databaseTransactionLogsHome.resolve(preparedLogFile)).close();
        }
    }

    private Path[] getLogFiles(Path directory) throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)directory, (FileSystemAbstraction)this.fileSystem).build().logFiles();
    }

    private Set<String> getLogFileNames(Path directory) throws IOException {
        return Arrays.stream(LogFilesBuilder.logFilesBasedOnlyBuilder((Path)directory, (FileSystemAbstraction)this.fileSystem).build().logFiles()).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
    }

    protected void prepareSampleDatabase(String version, FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, Path databaseDirectory) throws IOException {
        MigrationTestUtils.prepareSampleLegacyDatabase((String)version, (FileSystemAbstraction)fileSystem, (Path)databaseLayout.databaseDirectory(), (Path)databaseDirectory);
    }

    private StoreVersionCheck getVersionCheck(PageCache pageCache) {
        return this.getVersionCheck(pageCache, PageCacheTracer.NULL);
    }

    private StoreVersionCheck getVersionCheck(PageCache pageCache, PageCacheTracer cacheTracer) {
        return new RecordStoreVersionCheck(this.fileSystem, pageCache, this.databaseLayout, (LogProvider)NullLogProvider.getInstance(), this.getTuningConfig(), cacheTracer);
    }

    private static StoreMigrationParticipant participantThatWillFailWhenMoving(final String failureMessage) {
        return new AbstractStoreMigrationParticipant("Failing"){

            public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progress, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) {
            }

            public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
                throw new IOException(failureMessage);
            }

            public void cleanup(DatabaseLayout migrationLayout) {
            }
        };
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, Config config, PageCache pageCache, PageCacheTracer pageCacheTracer) {
        return this.newUpgrader(storeVersionCheck, pageCache, config, pageCacheTracer);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, Config config, PageCache pageCache) {
        return this.newUpgrader(storeVersionCheck, pageCache, config, PageCacheTracer.NULL);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, PageCache pageCache) {
        return this.newUpgrader(storeVersionCheck, pageCache, this.allowMigrateConfig, PageCacheTracer.NULL);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, PageCache pageCache, Config config, PageCacheTracer pageCacheTracer) {
        return this.newUpgrader(storeVersionCheck, pageCache, config, MigrationProgressMonitor.SILENT, pageCacheTracer);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, PageCache pageCache, Config config, MigrationProgressMonitor progressMonitor) {
        return this.newUpgrader(storeVersionCheck, pageCache, config, progressMonitor, PageCacheTracer.NULL);
    }

    private StoreUpgrader newUpgrader(StoreVersionCheck storeVersionCheck, PageCache pageCache, Config config, MigrationProgressMonitor progressMonitor, PageCacheTracer pageCacheTracer) {
        NullLogService instance = NullLogService.getInstance();
        BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();
        RecordStorageMigrator defaultMigrator = new RecordStorageMigrator(this.fileSystem, pageCache, this.getTuningConfig(), (LogService)instance, this.jobScheduler, pageCacheTracer, batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.defaultStorageEngine();
        SchemaIndexMigrator indexMigrator = new SchemaIndexMigrator("Indexes", this.fileSystem, pageCache, IndexProvider.EMPTY.directoryStructure(), storageEngineFactory, true);
        LegacyTransactionLogsLocator logsLocator = new LegacyTransactionLogsLocator(config, (DatabaseLayout)this.databaseLayout);
        DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{new Monitors()});
        LogsUpgrader logsUpgrader = new LogsUpgrader(this.fileSystem, storageEngineFactory, (DatabaseLayout)this.databaseLayout, pageCache, logsLocator, config, (DependencyResolver)dependencies, pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE, databaseHealth);
        StoreUpgrader upgrader = new StoreUpgrader(storageEngineFactory, storeVersionCheck, progressMonitor, config, this.fileSystem, (LogProvider)NullLogProvider.getInstance(), logsUpgrader, pageCacheTracer);
        upgrader.addParticipant((StoreMigrationParticipant)indexMigrator);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant(StoreMigrationParticipant.NOT_PARTICIPATING);
        upgrader.addParticipant((StoreMigrationParticipant)defaultMigrator);
        return upgrader;
    }

    private List<Path> migrationHelperDirs() {
        Path[] tmpDirs = this.databaseLayout.listDatabaseFiles(file -> Files.isDirectory(file, new LinkOption[0]) && (file.getFileName().toString().equals("upgrade") || file.getFileName().toString().startsWith("upgrade_backup")));
        Assertions.assertNotNull((Object)tmpDirs, (String)"Some IO errors occurred");
        return Arrays.asList(tmpDirs);
    }

    private Config getTuningConfig() {
        return Config.defaults((Setting)GraphDatabaseSettings.record_format, (Object)this.getRecordFormatsName());
    }

    protected String getRecordFormatsName() {
        return Standard.LATEST_NAME;
    }

    public static void removeCheckPointFromTxLog(FileSystemAbstraction fileSystem, Path databaseDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)databaseDirectory, (FileSystemAbstraction)fileSystem).withStorageEngineFactory(StorageEngineFactory.defaultStorageEngine()).build();
        LogTailInformation logTailInformation = logFiles.getTailInformation();
        if (logTailInformation.commitsAfterLastCheckpoint()) {
            return;
        }
        Assertions.assertNotNull((Object)logTailInformation.lastCheckPoint);
        LogPosition logPosition = logTailInformation.lastCheckPoint.getTransactionLogPosition();
        Path logFile = logFiles.getLogFile().getLogFileForVersion(logPosition.getLogVersion());
        long byteOffset = logPosition.getByteOffset();
        fileSystem.truncate(logFile, byteOffset);
    }

    private void verifyStoreUpgradedWithin(long duration, TimeUnit unit) {
        StoreFactory factory = new StoreFactory((DatabaseLayout)this.databaseLayout, this.allowMigrateConfig, (IdGeneratorFactory)new ScanOnOpenOverwritingIdGeneratorFactory(this.fileSystem, this.databaseLayout.getDatabaseName()), this.pageCache, this.fileSystem, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL, DatabaseReadOnlyChecker.writable());
        try (NeoStores neoStores = factory.openAllNeoStores();){
            LogAssertions.assertThat((Object)neoStores.getMetaDataStore().getUpgradeTransaction()).isEqualTo((Object)neoStores.getMetaDataStore().getLastCommittedTransaction());
            LogAssertions.assertThat((long)neoStores.getMetaDataStore().getUpgradeTime()).isPositive();
            long minuteAgo = System.currentTimeMillis() - unit.toMillis(duration);
            LogAssertions.assertThat((long)neoStores.getMetaDataStore().getUpgradeTime()).isGreaterThan(minuteAgo);
        }
    }

    private static class EmptyNamedMigrationParticipant
    extends AbstractStoreMigrationParticipant {
        protected EmptyNamedMigrationParticipant(String name) {
            super(name);
        }

        public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progress, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) {
        }

        public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToMigrateFrom, String versionToMigrateTo) {
        }

        public void cleanup(DatabaseLayout migrationLayout) {
        }
    }
}

