/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvents;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@DbmsExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogFileIT {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    @Inject
    private LogVersionRepository logVersionRepository;
    @Inject
    private TransactionIdStore transactionIdStore;

    TransactionLogFileIT() {
    }

    @Test
    void tracePageCacheAccessOnRotate() throws IOException {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withStoreId(StoreId.UNKNOWN).withDatabaseTracers(new DatabaseTracers(DatabaseTracer.NULL, LockTracer.NONE, (PageCacheTracer)cacheTracer)).build();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        Assertions.assertThat((long)cacheTracer.pins()).isZero();
        Assertions.assertThat((long)cacheTracer.unpins()).isZero();
        Assertions.assertThat((long)cacheTracer.pins()).isZero();
        LogFile logFile = logFiles.getLogFile();
        logFile.rotate();
        Assertions.assertThat((long)cacheTracer.pins()).isEqualTo(1L);
        Assertions.assertThat((long)cacheTracer.unpins()).isEqualTo(1L);
        Assertions.assertThat((long)cacheTracer.hits()).isEqualTo(1L);
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void doNotScanDirectoryOnRotate() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        final MutableLong rotationObservedVersion = new MutableLong();
        LogRotation logRotation = FileLogRotation.transactionLogRotation((LogFile)logFiles.getLogFile(), (Clock)Clock.systemUTC(), (Health)new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance()), (LogRotationMonitor)new LogRotationMonitorAdapter(){

            public void startRotation(long currentLogVersion) {
                rotationObservedVersion.setValue(currentLogVersion);
            }
        });
        for (int i = 0; i < 6; ++i) {
            for (Path path : logFiles.logFiles()) {
                FileUtils.deleteFile((Path)path);
            }
            logRotation.rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (Long)rotationObservedVersion.getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)6L, (long)logFiles.getLogFile().getCurrentLogVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void trackTransactionLogFileMemory() throws IOException {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withStoreId(StoreId.UNKNOWN).withMemoryTracker((MemoryTracker)memoryTracker).build();
        life.add((Lifecycle)logFiles);
        try {
            life.start();
            Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isZero();
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isGreaterThan(0L);
        }
        finally {
            life.stop();
            life.shutdown();
        }
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
        Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isZero();
    }
}

