/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.storageengine.api.RelationshipSelection;

public abstract class RandomRelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final int N_TRAVERSALS = 10000;
    private static final int N_NODES = 100;
    private static final int N_RELATIONSHIPS = 1000;
    private static final long SEED = new Random().nextInt();
    private static final Random RANDOM = new Random(SEED);
    private static final List<Long> NODE_IDS = new ArrayList<Long>();

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        int i;
        try (Transaction tx = graphDb.beginTx();){
            for (i = 0; i < 100; ++i) {
                NODE_IDS.add(tx.createNode(new Label[]{Label.label((String)("LABEL" + i))}).getId());
            }
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            for (i = 0; i < 1000; ++i) {
                Long source = NODE_IDS.get(RANDOM.nextInt(100));
                Long target = NODE_IDS.get(RANDOM.nextInt(100));
                tx.getNodeById(source.longValue()).createRelationshipTo(tx.getNodeById(target.longValue()), RelationshipType.withName((String)("REL" + i % 10)));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldManageRandomTraversals() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor(CursorContext.NULL);){
            for (int i = 0; i < 10000; ++i) {
                long nodeId = NODE_IDS.get(RANDOM.nextInt(100));
                this.read.singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"access root node");
                int[] types = node.relationshipTypes();
                Assertions.assertFalse((boolean)node.next(), (String)"single root");
                for (int type : types) {
                    node.relationships(relationship, RelationshipSelection.selection((int)type, (Direction)Direction.INCOMING));
                    while (relationship.next()) {
                        Assertions.assertEquals((long)nodeId, (long)relationship.originNodeReference(), (String)"incoming origin");
                        relationship.otherNode(node);
                    }
                    node.relationships(relationship, RelationshipSelection.selection((int)type, (Direction)Direction.OUTGOING));
                    while (relationship.next()) {
                        Assertions.assertEquals((long)nodeId, (long)relationship.originNodeReference(), (String)"outgoing origin");
                        relationship.otherNode(node);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed with random seed " + SEED, t);
        }
    }
}

