/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.internal.nativeimpl.AbsentNativeAccess;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class DatabasePanicIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private Config config;
    @Inject
    private DatabaseHealth databaseHealth;
    @Inject
    private Monitors monitors;
    private FailingNativeAccess nativeAccess;

    DatabasePanicIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        Dependencies dependencies = new Dependencies();
        this.nativeAccess = new FailingNativeAccess();
        dependencies.satisfyDependency((Object)this.nativeAccess);
        builder.setExternalDependencies((DependencyResolver)dependencies);
    }

    @Test
    void panicOnLogRotationFailure() {
        long rotationThreshold = ByteUnit.kibiBytes((long)128L);
        Assertions.assertDoesNotThrow(() -> {
            try (Transaction transaction = this.database.beginTx();){
                for (int i = 0; i < 100; ++i) {
                    transaction.createNode();
                }
                transaction.commit();
            }
        });
        this.config.setDynamic(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)rotationThreshold, "test");
        this.nativeAccess.startFailing();
        Assertions.assertThrows(Exception.class, () -> {
            try (Transaction transaction = this.database.beginTx();){
                Node node = transaction.createNode();
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)((int)(rotationThreshold + 100L))));
                transaction.commit();
            }
        });
        Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction transaction = this.database.beginTx();){
                transaction.createNode();
                transaction.commit();
            }
        });
        Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction transaction = this.database.beginTx();){
                transaction.getNodeById(1L);
            }
        });
        Assertions.assertFalse((boolean)this.databaseHealth.isHealthy());
    }

    private static class FailingNativeAccess
    extends AbsentNativeAccess {
        private final AtomicBoolean fail = new AtomicBoolean();

        private FailingNativeAccess() {
        }

        public NativeCallResult tryPreallocateSpace(int fd, long bytes) {
            if (this.fail.get()) {
                throw new RuntimeException("Something really wrong.");
            }
            return super.tryPreallocateSpace(fd, bytes);
        }

        public void startFailing() {
            this.fail.set(true);
        }
    }
}

