/*
 * Decompiled with CFR 0.152.
 */
package synchronization;

import java.io.OutputStream;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.SuppressOutputExtension;

@Neo4jLayoutExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class ConcurrentChangesOnEntitiesTest {
    @Inject
    private DatabaseLayout databaseLayout;
    private final CyclicBarrier barrier = new CyclicBarrier(2);
    private final AtomicReference<Exception> ex = new AtomicReference();
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    ConcurrentChangesOnEntitiesTest() {
    }

    @BeforeEach
    void setup() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        this.db = this.managementService.database("neo4j");
    }

    @Test
    void addConcurrentlySameLabelToANode() throws Throwable {
        long nodeId = ConcurrentChangesOnEntitiesTest.initWithNode(this.db);
        Thread t1 = this.newThreadForNodeAction(nodeId, node -> node.addLabel(Label.label((String)"A")));
        Thread t2 = this.newThreadForNodeAction(nodeId, node -> node.addLabel(Label.label((String)"A")));
        this.startAndWait(t1, t2);
        this.managementService.shutdown();
        this.assertDatabaseConsistent();
    }

    @Test
    void setConcurrentlySamePropertyWithDifferentValuesOnANode() throws Throwable {
        long nodeId = ConcurrentChangesOnEntitiesTest.initWithNode(this.db);
        Thread t1 = this.newThreadForNodeAction(nodeId, node -> node.setProperty("a", (Object)0.788));
        Thread t2 = this.newThreadForNodeAction(nodeId, node -> node.setProperty("a", (Object)new double[]{0.999, 0.77}));
        this.startAndWait(t1, t2);
        this.managementService.shutdown();
        this.assertDatabaseConsistent();
    }

    @Test
    void setConcurrentlySamePropertyWithDifferentValuesOnARelationship() throws Throwable {
        long relId = ConcurrentChangesOnEntitiesTest.initWithRel(this.db);
        Thread t1 = this.newThreadForRelationshipAction(relId, relationship -> relationship.setProperty("a", (Object)0.788));
        Thread t2 = this.newThreadForRelationshipAction(relId, relationship -> relationship.setProperty("a", (Object)new double[]{0.999, 0.77}));
        this.startAndWait(t1, t2);
        this.managementService.shutdown();
        this.assertDatabaseConsistent();
    }

    private static long initWithNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node theNode = tx.createNode();
            long id = theNode.getId();
            tx.commit();
            long l = id;
            return l;
        }
    }

    private static long initWithRel(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            node.setProperty("a", (Object)"prop");
            Relationship rel = node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"T"));
            long id = rel.getId();
            tx.commit();
            long l = id;
            return l;
        }
    }

    private Thread newThreadForNodeAction(long nodeId, Consumer<Node> nodeConsumer) {
        return new Thread(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.getNodeById(nodeId);
                this.barrier.await();
                nodeConsumer.accept(node);
                tx.commit();
            }
            catch (Exception e) {
                this.ex.set(e);
            }
        });
    }

    private Thread newThreadForRelationshipAction(long relationshipId, Consumer<Relationship> relConsumer) {
        return new Thread(() -> {
            try (Transaction tx = this.db.beginTx();){
                Relationship relationship = tx.getRelationshipById(relationshipId);
                this.barrier.await();
                relConsumer.accept(relationship);
                tx.commit();
            }
            catch (Exception e) {
                this.ex.set(e);
            }
        });
    }

    private void startAndWait(Thread t1, Thread t2) throws Exception {
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.ex.get() != null) {
            throw this.ex.get();
        }
    }

    private void assertDatabaseConsistent() {
        Log4jLogProvider logProvider = new Log4jLogProvider((OutputStream)System.out);
        Assertions.assertDoesNotThrow(() -> this.lambda$assertDatabaseConsistent$8((LogProvider)logProvider));
    }

    private /* synthetic */ void lambda$assertDatabaseConsistent$8(LogProvider logProvider) throws Throwable {
        ConsistencyCheckService.Result result = new ConsistencyCheckService().runFullConsistencyCheck(this.databaseLayout, Config.defaults(), ProgressMonitorFactory.textual((OutputStream)System.err), logProvider, false);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

