/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
public abstract class NodeWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private static final String propertyKey = "prop";
    private static final String labelName = "Town";
    @Inject
    private RandomSupport random;

    @Test
    void shouldCreateNode() throws Exception {
        long node;
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)node, (long)tx.getNodeById(node).getId());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldRollbackOnFailure() throws Exception {
        long node;
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.rollback();
        }
        try {
            tx = graphDb.beginTx();
            try {
                tx.getNodeById(node);
                org.junit.jupiter.api.Assertions.fail((String)"There should be no node");
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    void shouldRemoveNode() throws Exception {
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            tx.dataWrite().nodeDelete(node);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            try {
                tx.getNodeById(node);
                org.junit.jupiter.api.Assertions.fail((String)"Did not remove node");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotRemoveNodeThatDoesNotExist() throws Exception {
        long node = 0L;
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().nodeDelete(node));
            tx.rollback();
        }
        tx = NodeWriteTestBase.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().nodeDelete(node));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAddLabelNode() throws Exception {
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().nodeAddLabel(node, labelId));
            tx.commit();
        }
        NodeWriteTestBase.assertLabels(node, labelName);
    }

    @Test
    void shouldAddLabelNodeOnce() throws Exception {
        long node = NodeWriteTestBase.createNodeWithLabels(labelName);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().nodeAddLabel(node, labelId));
            tx.commit();
        }
        NodeWriteTestBase.assertLabels(node, labelName);
    }

    @Test
    void shouldRemoveLabel() throws Exception {
        long nodeId = NodeWriteTestBase.createNodeWithLabels(labelName);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().nodeRemoveLabel(nodeId, labelId));
            tx.commit();
        }
        NodeWriteTestBase.assertNoLabels(nodeId);
    }

    @Test
    void shouldNotAddLabelToNonExistingNode() throws Exception {
        long node = 1337L;
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> tx.dataWrite().nodeAddLabel(node, labelId));
        }
    }

    @Test
    void shouldRemoveLabelOnce() throws Exception {
        int labelId;
        long nodeId = NodeWriteTestBase.createNodeWithLabels(labelName);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            labelId = tx.token().labelGetOrCreateForName(labelName);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().nodeRemoveLabel(nodeId, labelId));
            tx.commit();
        }
        tx = NodeWriteTestBase.beginTransaction();
        try {
            labelId = tx.token().labelGetOrCreateForName(labelName);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().nodeRemoveLabel(nodeId, labelId));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        NodeWriteTestBase.assertNoLabels(nodeId);
    }

    @Test
    void shouldAddPropertyToNode() throws Exception {
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        NodeWriteTestBase.assertProperty(node, propertyKey, "hello");
    }

    @Test
    void shouldRollbackSetNodeProperty() throws Exception {
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.NO_VALUE);
            tx.rollback();
        }
        NodeWriteTestBase.assertNoProperty(node, propertyKey);
    }

    @Test
    void shouldThrowWhenSettingPropertyOnDeletedNode() throws Exception {
        long node = NodeWriteTestBase.createNode();
        NodeWriteTestBase.deleteNode(node);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello"));
            org.junit.jupiter.api.Assertions.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Test
    void shouldUpdatePropertyToNode() throws Exception {
        long node = NodeWriteTestBase.createNodeWithProperty(propertyKey, 42);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.intValue((int)42));
            tx.commit();
        }
        NodeWriteTestBase.assertProperty(node, propertyKey, "hello");
    }

    @Test
    void shouldRemovePropertyFromNode() throws Exception {
        long node = NodeWriteTestBase.createNodeWithProperty(propertyKey, 42);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token)).isEqualTo((Object)Values.intValue((int)42));
            tx.commit();
        }
        NodeWriteTestBase.assertNoProperty(node, propertyKey);
    }

    @Test
    void shouldRemoveNonExistingPropertyFromNode() throws Exception {
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        NodeWriteTestBase.assertNoProperty(node, propertyKey);
    }

    @Test
    void shouldRemovePropertyFromNodeTwice() throws Exception {
        long node = NodeWriteTestBase.createNodeWithProperty(propertyKey, 42);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token)).isEqualTo((Object)Values.intValue((int)42));
            Assertions.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        NodeWriteTestBase.assertNoProperty(node, propertyKey);
    }

    @Test
    void shouldUpdatePropertyToNodeInTransaction() throws Exception {
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.NO_VALUE);
            Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"world"))).isEqualTo((Object)Values.stringValue((String)"hello"));
            Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.intValue((int)1337))).isEqualTo((Object)Values.stringValue((String)"world"));
            tx.commit();
        }
        NodeWriteTestBase.assertProperty(node, propertyKey, 1337);
    }

    @Test
    void shouldRemoveReSetAndTwiceRemovePropertyOnNode() throws Exception {
        long node = NodeWriteTestBase.createNodeWithProperty(propertyKey, "bar");
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int prop = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            tx.dataWrite().nodeRemoveProperty(node, prop);
            tx.dataWrite().nodeSetProperty(node, prop, Values.of((Object)"bar"));
            tx.dataWrite().nodeRemoveProperty(node, prop);
            tx.dataWrite().nodeRemoveProperty(node, prop);
            tx.commit();
        }
        NodeWriteTestBase.assertNoProperty(node, propertyKey);
    }

    @Test
    void shouldNotWriteWhenSettingPropertyToSameValue() throws Exception {
        TextValue theValue = Values.stringValue((String)"The Value");
        long nodeId = NodeWriteTestBase.createNodeWithProperty(propertyKey, theValue.asObject());
        KernelTransaction tx = NodeWriteTestBase.beginTransaction();
        int property = tx.token().propertyKeyGetOrCreateForName(propertyKey);
        Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(nodeId, property, (Value)theValue)).isEqualTo((Object)theValue);
        Assertions.assertThat((long)tx.commit()).isEqualTo(0L);
    }

    @Test
    void shouldSetAndReadLargeByteArrayPropertyToNode() throws Exception {
        int prop;
        long node = NodeWriteTestBase.createNode();
        Value largeByteArray = Values.of((Object)new byte[100000]);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            prop = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().nodeSetProperty(node, prop, largeByteArray)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        tx = NodeWriteTestBase.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleNode(node, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)propertyCursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((int)propertyCursor.propertyKey(), (int)prop);
            Assertions.assertThat((Object)propertyCursor.propertyValue()).isEqualTo((Object)largeByteArray);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeApplyChangesShouldAddNonExistentLabel() throws Exception {
        int label;
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName("Label");
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.of(label), (IntSet)IntSets.immutable.empty(), (IntObjectMap)IntObjectMaps.immutable.empty());
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                Assertions.assertThat((long[])nodeCursor.labels().all()).isEqualTo((Object)new long[]{label});
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldNotAddExistingLabel() throws Exception {
        int label;
        String labelName = "Label";
        long node = NodeWriteTestBase.createNodeWithLabels(labelName);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            label = tx.tokenRead().nodeLabel(labelName);
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.of(label), (IntSet)IntSets.immutable.empty(), (IntObjectMap)IntObjectMaps.immutable.empty());
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                Assertions.assertThat((long[])nodeCursor.labels().all()).isEqualTo((Object)new long[]{label});
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldRemoveExistingLabel() throws Exception {
        String labelName = "Label";
        long node = NodeWriteTestBase.createNodeWithLabels(labelName);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int label = tx.tokenRead().nodeLabel(labelName);
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.of(label), (IntObjectMap)IntObjectMaps.immutable.empty());
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                Assertions.assertThat((long[])nodeCursor.labels().all()).isEqualTo((Object)ArrayUtils.EMPTY_LONG_ARRAY);
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldNotRemoveNonExistentLabel() throws Exception {
        int label;
        String labelName = "Label";
        long node = NodeWriteTestBase.createNodeWithLabels(labelName);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            label = tx.tokenRead().nodeLabel(labelName);
            int otherLabel = tx.tokenWrite().labelGetOrCreateForName("OtherLabel");
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.of(otherLabel), (IntObjectMap)IntObjectMaps.immutable.empty());
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                Assertions.assertThat((long[])nodeCursor.labels().all()).isEqualTo((Object)new long[]{label});
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldAddMultipleLabels() throws Exception {
        int label2;
        int label1;
        long node = NodeWriteTestBase.createNode();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            label1 = tx.tokenWrite().labelGetOrCreateForName("Label1");
            label2 = tx.tokenWrite().labelGetOrCreateForName("Label2");
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.of(new int[]{label1, label2}), (IntSet)IntSets.immutable.empty(), (IntObjectMap)IntObjectMaps.immutable.empty());
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                Assertions.assertThat((long[])nodeCursor.labels().all()).isEqualTo((Object)new long[]{label1, label2});
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldRemoveMultipleLabels() throws Exception {
        int label3;
        String labelName1 = "Label1";
        String labelName2 = "Label2";
        String labelName3 = "Label3";
        long node = NodeWriteTestBase.createNodeWithLabels(labelName1, labelName2, labelName3);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int label1 = tx.tokenRead().nodeLabel(labelName1);
            int label2 = tx.tokenRead().nodeLabel(labelName2);
            label3 = tx.tokenRead().nodeLabel(labelName3);
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.of(new int[]{label1, label2}), (IntObjectMap)IntObjectMaps.immutable.empty());
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                Assertions.assertThat((long[])nodeCursor.labels().all()).isEqualTo((Object)new long[]{label3});
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldAddAndRemoveMultipleLabels() throws Exception {
        long node;
        int[] initialLabels;
        int[] labels = new int[10];
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = tx.tokenWrite().labelGetOrCreateForName("Label" + i);
            }
            initialLabels = this.random.selection(labels, 0, labels.length, false);
            node = tx.dataWrite().nodeCreateWithLabels(initialLabels);
            tx.commit();
        }
        int[] addedLabels = this.random.selection(labels, 1, labels.length, false);
        int[] removedLabels = this.random.selection(labels, 1, labels.length, false);
        removedLabels = Arrays.stream(removedLabels).filter(label -> !ArrayUtils.contains((int[])addedLabels, (int)label)).toArray();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.of(addedLabels), (IntSet)IntSets.immutable.of(removedLabels), (IntObjectMap)IntObjectMaps.immutable.empty());
            tx.commit();
        }
        MutableLongSet expectedLabels = LongSets.mutable.empty();
        Arrays.stream(initialLabels).forEach(arg_0 -> ((MutableLongSet)expectedLabels).add(arg_0));
        Arrays.stream(addedLabels).forEach(arg_0 -> ((MutableLongSet)expectedLabels).add(arg_0));
        Arrays.stream(removedLabels).forEach(arg_0 -> ((MutableLongSet)expectedLabels).remove(arg_0));
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                Assertions.assertThat((long[])nodeCursor.labels().all()).isEqualTo((Object)expectedLabels.toSortedArray());
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldAddProperty() throws Exception {
        int key;
        long node = NodeWriteTestBase.createNode();
        String keyName = "key";
        IntValue value = Values.intValue((int)123);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            key = tx.tokenWrite().propertyKeyCreateForName(keyName, false);
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)value));
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)arg_0 -> this.lambda$nodeApplyChangesShouldAddProperty$9(node, key, (Value)value, arg_0)));
    }

    @Test
    void nodeApplyChangesShouldChangeProperty() throws Exception {
        int key;
        String keyName = "key";
        TextValue changedValue = Values.stringValue((String)"value");
        long node = NodeWriteTestBase.createNodeWithProperty(keyName, 123);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            key = tx.tokenRead().propertyKey(keyName);
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)changedValue));
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)arg_0 -> this.lambda$nodeApplyChangesShouldChangeProperty$10(node, key, (Value)changedValue, arg_0)));
    }

    @Test
    void nodeApplyChangesShouldRemoveProperty() throws Exception {
        String keyName = "key";
        long node = NodeWriteTestBase.createNodeWithProperty(keyName, 123);
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int key = tx.tokenRead().propertyKey(keyName);
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)Values.NO_VALUE));
            tx.commit();
        }
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);
                 PropertyCursor propertyCursor = NodeWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                ktx.dataRead().singleNode(node, nodeCursor);
                nodeCursor.next();
                this.assertProperties((EntityCursor)nodeCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.empty());
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldSetAndRemoveMultipleProperties() throws Exception {
        long node;
        int[] keys = new int[10];
        MutableIntObjectMap initialProperties = IntObjectMaps.mutable.empty();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = tx.tokenWrite().propertyKeyGetOrCreateForName("key" + i);
            }
            node = tx.dataWrite().nodeCreate();
            for (int key2 : this.random.selection(keys, 0, keys.length, false)) {
                Value value2 = this.random.nextValue();
                initialProperties.put(key2, (Object)value2);
                tx.dataWrite().nodeSetProperty(node, key2, value2);
            }
            tx.commit();
        }
        MutableIntObjectMap propertyChanges = IntObjectMaps.mutable.empty();
        for (int key2 : this.random.selection(keys, 1, keys.length, false)) {
            propertyChanges.put(key2, (Object)this.random.nextValue());
        }
        for (int key2 : this.random.selection(keys, 1, keys.length, false)) {
            propertyChanges.put(key2, (Object)Values.NO_VALUE);
        }
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntObjectMap)propertyChanges);
            tx.commit();
        }
        MutableIntObjectMap expectedProperties = IntObjectMaps.mutable.empty();
        expectedProperties.putAll((IntObjectMap)initialProperties);
        propertyChanges.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
            if (value == Values.NO_VALUE) {
                expectedProperties.remove(key);
            } else {
                expectedProperties.put(key, value);
            }
        });
        NodeWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);
                 PropertyCursor propertyCursor = NodeWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                ktx.dataRead().singleNode(node, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                this.assertProperties((EntityCursor)nodeCursor, propertyCursor, (IntObjectMap<Value>)expectedProperties);
            }
        }));
    }

    @Test
    void nodeApplyChangesShouldApplyAllTypesOfChanges() throws Exception {
        long nodeId;
        int[] possibleLabelIds = new int[20];
        int[] possiblePropertyKeyIds = new int[possibleLabelIds.length];
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            for (int i = 0; i < possibleLabelIds.length; ++i) {
                possibleLabelIds[i] = tx.tokenWrite().labelGetOrCreateForName("Label" + i);
                possiblePropertyKeyIds[i] = tx.tokenWrite().propertyKeyGetOrCreateForName("Key" + i);
            }
        }
        ImmutableIntSet initialLabels = IntSets.immutable.of(this.random.selection(possibleLabelIds, 0, possibleLabelIds.length / 2, false));
        MutableIntObjectMap initialProperties = IntObjectMaps.mutable.empty();
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreateWithLabels(initialLabels.toArray());
            for (int key2 : this.random.selection(possiblePropertyKeyIds, 0, possiblePropertyKeyIds.length, false)) {
                Value value2 = this.random.nextValue();
                initialProperties.put(key2, (Object)value2);
                tx.dataWrite().nodeSetProperty(nodeId, key2, value2);
            }
            tx.commit();
        }
        MutableIntSet addedLabels = IntSets.mutable.empty();
        int numAddedLabels = this.random.nextInt(possibleLabelIds.length / 2);
        for (int i = 0; i < numAddedLabels; ++i) {
            int labelId;
            while (initialLabels.contains(labelId = this.random.among(possibleLabelIds)) || !addedLabels.add(labelId)) {
            }
        }
        ImmutableIntSet removedLabels = IntSets.immutable.of(this.random.selection(initialLabels.toArray(), 0, initialLabels.size(), false));
        MutableIntObjectMap changedProperties = IntObjectMaps.mutable.empty();
        int numChangedProperties = this.random.nextInt(possiblePropertyKeyIds.length);
        for (int i = 0; i < numChangedProperties; ++i) {
            int key3;
            while (changedProperties.containsKey(key3 = this.random.among(possiblePropertyKeyIds))) {
            }
            boolean remove = changedProperties.containsKey(key3) && this.random.nextBoolean();
            changedProperties.put(key3, (Object)(remove ? Values.NO_VALUE : this.random.nextValue()));
        }
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            tx.dataWrite().nodeApplyChanges(nodeId, (IntSet)addedLabels, (IntSet)removedLabels, (IntObjectMap)changedProperties);
            tx.commit();
        }
        MutableIntSet expectedLabels = IntSets.mutable.of(initialLabels.toArray());
        expectedLabels.addAll((IntIterable)addedLabels);
        expectedLabels.removeAll((IntIterable)removedLabels);
        MutableIntObjectMap expectedProperties = IntObjectMaps.mutable.ofAll((IntObjectMap)initialProperties);
        changedProperties.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
            if (value == Values.NO_VALUE) {
                expectedProperties.remove(key);
            } else {
                expectedProperties.put(key, value);
            }
        });
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            CursorFactory cursorFactory = NodeWriteTestBase.cursorFactory(tx);
            try (NodeCursor nodeCursor = cursorFactory.allocateNodeCursor(CursorContext.NULL);
                 PropertyCursor propertyCursor = cursorFactory.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                tx.dataRead().singleNode(nodeId, nodeCursor);
                Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                this.assertLabels(nodeCursor, (IntSet)expectedLabels);
                this.assertProperties((EntityCursor)nodeCursor, propertyCursor, (IntObjectMap<Value>)expectedProperties);
            }
        }
    }

    @Test
    void nodeApplyChangesShouldCheckUniquenessAfterAllChanges() throws Exception {
        long node;
        Label label = Label.label((String)"Label");
        String key1Name = "key1";
        String key2Name = "key2";
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().constraintFor(label).assertPropertyIsUnique(key1Name).assertPropertyIsUnique(key2Name);
            tx.commit();
        }
        try (Transaction tx = graphDb.beginTx();){
            Node n1 = tx.createNode(new Label[]{label});
            n1.setProperty(key1Name, (Object)"A");
            n1.setProperty(key2Name, (Object)"B");
            node = n1.getId();
            Node n2 = tx.createNode(new Label[]{label});
            n2.setProperty(key1Name, (Object)"A");
            n2.setProperty(key2Name, (Object)"C");
            tx.commit();
        }
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int key1 = tx.tokenRead().propertyKey(key1Name);
            int key2 = tx.tokenRead().propertyKey(key2Name);
            MutableIntObjectMap propertyChanges = IntObjectMaps.mutable.empty();
            propertyChanges.put(key1, (Object)Values.stringValue((String)"D"));
            propertyChanges.put(key2, (Object)Values.stringValue((String)"C"));
            tx.dataWrite().nodeApplyChanges(node, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntObjectMap)propertyChanges);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try (ResourceIterator nodes = tx.findNodes(label, MapUtil.map((Object[])new Object[]{key1Name, "D", key2Name, "C"}));){
            Assertions.assertThat((boolean)nodes.hasNext()).isTrue();
            Assertions.assertThat((long)((Node)nodes.next()).getId()).isEqualTo(node);
            Assertions.assertThat((boolean)nodes.hasNext()).isFalse();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeApplyChangesShouldEnforceUniquenessCorrectly() throws Exception {
        long[] nodes = new long[10];
        Object[] labels = new Label[4];
        Object[] keys = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = Label.label((String)("Label" + i));
            keys[i] = "key" + i;
        }
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < nodes.length; ++i) {
                Node node = tx.createNode();
                nodes[i] = node.getId();
            }
            tx.commit();
        }
        ArrayList<Label> constraintLabels = new ArrayList<Label>();
        ArrayList<String[]> constraintPropertyKeys = new ArrayList<String[]>();
        try (Transaction tx = graphDb.beginTx();){
            Label constraintLabel = (Label)this.random.among(labels);
            String constraintKey = (String)this.random.among(keys);
            tx.schema().constraintFor(constraintLabel).assertPropertyIsUnique(constraintKey).create();
            constraintLabels.add(constraintLabel);
            constraintPropertyKeys.add(new String[]{constraintKey});
            constraintLabel = (Label)this.random.among(labels);
            String[] constraintKeys = (String[])this.random.selection(keys, 2, 2, false);
            tx.schema().constraintFor(constraintLabel).assertPropertyIsUnique(constraintKeys[0]).assertPropertyIsUnique(constraintKeys[1]).create();
            constraintLabels.add(constraintLabel);
            constraintPropertyKeys.add(constraintKeys);
            tx.commit();
        }
        int[] labelIds = new int[labels.length];
        int[] keyIds = new int[keys.length];
        try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
            int i;
            for (i = 0; i < labels.length; ++i) {
                labelIds[i] = tx.tokenWrite().labelGetOrCreateForName(labels[i].name());
            }
            for (i = 0; i < keys.length; ++i) {
                keyIds[i] = tx.tokenWrite().propertyKeyGetOrCreateForName((String)keys[i]);
            }
        }
        Race race = new Race().withEndCondition(new BooleanSupplier[]{() -> false});
        race.addContestants(1, Race.throwing(() -> {
            try (KernelTransaction tx = NodeWriteTestBase.beginTransaction();){
                long node = this.random.among(nodes);
                MutableIntSet addedLabels = IntSets.mutable.of(this.random.selection(labelIds, 0, 2, false));
                MutableIntSet removedLabels = IntSets.mutable.of(this.random.selection(labelIds, 0, 2, false));
                removedLabels.removeAll((IntIterable)addedLabels);
                MutableIntObjectMap properties = IntObjectMaps.mutable.empty();
                for (int key : this.random.selection(keyIds, 0, 2, false)) {
                    Value value = (double)this.random.nextFloat() < 0.2 ? Values.NO_VALUE : Values.intValue((int)this.random.nextInt(5));
                    properties.put(key, (Object)value);
                }
                tx.dataWrite().nodeApplyChanges(node, (IntSet)addedLabels, (IntSet)removedLabels, (IntObjectMap)properties);
                tx.commit();
            }
            catch (UniquePropertyValueValidationException uniquePropertyValueValidationException) {
                // empty catch block
            }
        }), 100);
        race.goUnchecked();
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < constraintLabels.size(); ++i) {
                Label label = (Label)constraintLabels.get(i);
                String[] propertyKeys = (String[])constraintPropertyKeys.get(i);
                HashSet<ValueTuple> entries = new HashSet<ValueTuple>();
                try (ResourceIterator nodesWithLabel = tx.findNodes(label);){
                    while (nodesWithLabel.hasNext()) {
                        Node node = (Node)nodesWithLabel.next();
                        Map properties = node.getProperties(propertyKeys);
                        if (properties.size() != propertyKeys.length) continue;
                        Object[] values = new Object[propertyKeys.length];
                        for (int v = 0; v < propertyKeys.length; ++v) {
                            String key = propertyKeys[v];
                            values[v] = properties.get(key);
                        }
                        Assertions.assertThat((boolean)entries.add(ValueTuple.of((Object[])values))).isTrue();
                    }
                    continue;
                }
            }
            tx.commit();
        }
    }

    private void assertLabels(NodeCursor nodeCursor, IntSet expectedLabels) {
        MutableIntSet readLabels = IntSets.mutable.empty();
        TokenSet labels = nodeCursor.labels();
        for (int i = 0; i < labels.numberOfTokens(); ++i) {
            readLabels.add(labels.token(i));
        }
        Assertions.assertThat((Object)readLabels).isEqualTo((Object)expectedLabels);
    }

    private static long createNode() {
        long node;
        try (Transaction ctx = graphDb.beginTx();){
            node = ctx.createNode().getId();
            ctx.commit();
        }
        return node;
    }

    private static void deleteNode(long node) {
        try (Transaction tx = graphDb.beginTx();){
            tx.getNodeById(node).delete();
            tx.commit();
        }
    }

    private static long createNodeWithLabels(String ... labelNames) {
        long node;
        try (Transaction ctx = graphDb.beginTx();){
            node = ctx.createNode((Label[])Arrays.stream(labelNames).map(Label::label).toArray(Label[]::new)).getId();
            ctx.commit();
        }
        return node;
    }

    private static long createNodeWithProperty(String propertyKey, Object value) {
        Node node;
        try (Transaction ctx = graphDb.beginTx();){
            node = ctx.createNode();
            node.setProperty(propertyKey, value);
            ctx.commit();
        }
        return node.getId();
    }

    private static void assertNoLabels(long nodeId) {
        try (Transaction tx = graphDb.beginTx();){
            Assertions.assertThat((Iterable)tx.getNodeById(nodeId).getLabels()).isEqualTo((Object)Iterables.empty());
        }
    }

    private static void assertLabels(long nodeId, String label) {
        try (Transaction tx = graphDb.beginTx();){
            Assertions.assertThat((Iterable)tx.getNodeById(nodeId).getLabels()).contains((Object[])new Label[]{Label.label((String)label)});
        }
    }

    private static void assertNoProperty(long node, String propertyKey) {
        try (Transaction tx = graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.getNodeById(node).hasProperty(propertyKey));
        }
    }

    private static void assertProperty(long node, String propertyKey, Object value) {
        try (Transaction tx = graphDb.beginTx();){
            Assertions.assertThat((Object)tx.getNodeById(node).getProperty(propertyKey)).isEqualTo(value);
        }
    }

    private /* synthetic */ void lambda$nodeApplyChangesShouldChangeProperty$10(long node, int key, Value changedValue, KernelTransaction ktx) throws Exception {
        try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);
             PropertyCursor propertyCursor = NodeWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ktx.dataRead().singleNode(node, nodeCursor);
            nodeCursor.next();
            this.assertProperties((EntityCursor)nodeCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.of(key, (Object)changedValue));
        }
    }

    private /* synthetic */ void lambda$nodeApplyChangesShouldAddProperty$9(long node, int key, Value value, KernelTransaction ktx) throws Exception {
        try (NodeCursor nodeCursor = NodeWriteTestBase.cursorFactory(ktx).allocateNodeCursor(CursorContext.NULL);
             PropertyCursor propertyCursor = NodeWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ktx.dataRead().singleNode(node, nodeCursor);
            nodeCursor.next();
            this.assertProperties((EntityCursor)nodeCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.of(key, (Object)value));
        }
    }
}

