/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.KernelTransaction;

public class WorkerContext<T extends AutoCloseable>
implements AutoCloseable {
    private final T cursor;
    private final KernelTransaction.ExecutionContext context;
    private final KernelTransaction owner;

    public WorkerContext(T cursor, KernelTransaction.ExecutionContext context, KernelTransaction owner) {
        this.cursor = cursor;
        this.context = context;
        this.owner = owner;
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new KernelTransaction.ExecutionContext[]{this.context});
    }

    public T getCursor() {
        return this.cursor;
    }

    public KernelTransaction.ExecutionContext getContext() {
        return this.context;
    }

    public KernelTransaction getTransaction() {
        return this.owner;
    }

    public void complete() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.cursor});
        this.context.complete();
    }
}

