/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.StoreFileListing;
import org.neo4j.kernel.impl.store.StoreFileProvider;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.utils.TestDirectory;

@DbmsExtension
class StoreFileListingTest {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Database database;
    private static final String[] STANDARD_STORE_DIR_FILES = new String[]{"index", "lock", "debug.log", "neostore", "neostore.id", "neostore.counts.db", "neostore.labelscanstore.db", "neostore.labeltokenstore.db", "neostore.labeltokenstore.db.id", "neostore.labeltokenstore.db.names", "neostore.labeltokenstore.db.names.id", "neostore.nodestore.db", "neostore.nodestore.db.id", "neostore.nodestore.db.labels", "neostore.nodestore.db.labels.id", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.arrays.id", "neostore.propertystore.db.id", "neostore.propertystore.db.index", "neostore.propertystore.db.index.id", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.index.keys.id", "neostore.propertystore.db.strings", "neostore.propertystore.db.strings.id", "neostore.relationshipgroupstore.db", "neostore.relationshipgroupstore.db.id", "neostore.relationshipstore.db", "neostore.relationshipstore.db.id", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.id", "neostore.relationshiptypestore.db.names", "neostore.relationshiptypestore.db.names.id", "neostore.schemastore.db", "neostore.schemastore.db.id", "neostore.transaction.db.0", "neostore.transaction.db.1", "neostore.transaction.db.2", "store_lock"};
    private static final String[] STANDARD_STORE_DIR_DIRECTORIES = new String[]{"schema", "index", "branched"};

    StoreFileListingTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.createIndexDbFile();
    }

    @Test
    void shouldCloseIndexSnapshots() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        DatabaseLayout databaseLayout = (DatabaseLayout)Mockito.mock(DatabaseLayout.class);
        Mockito.when((Object)databaseLayout.metadataStore()).thenReturn((Object)((Path)Mockito.mock(Path.class)));
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        StoreFileListingTest.filesInStoreDirAre(databaseLayout, STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
        StoreFileListing fileListing = new StoreFileListing(databaseLayout, logFiles, indexingService, storageEngine, idGeneratorFactory);
        ResourceIterator<Path> indexSnapshot = StoreFileListingTest.indexFilesAre(indexingService, new String[]{"schema/index/my.index"});
        ResourceIterator result = fileListing.builder().excludeLogFiles().build();
        result.close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    @Test
    void shouldListMetaDataStoreLast() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.database.listStoreFiles(false));
        Assertions.assertEquals((Object)fileMetadata.path(), (Object)this.database.getDatabaseLayout().metadataStore());
    }

    @Test
    void shouldListMetaDataStoreLastWithTxLogs() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.database.listStoreFiles(true));
        Assertions.assertEquals((Object)fileMetadata.path(), (Object)this.database.getDatabaseLayout().metadataStore());
    }

    @Test
    void shouldListTransactionLogsFromCustomAbsoluteLocationWhenConfigured() throws IOException {
        Path customLogLocation = this.testDirectory.directory("customLogLocation");
        this.verifyLogFilesWithCustomPathListing(customLogLocation.toAbsolutePath());
    }

    @Test
    void shouldListTxLogFiles() throws Exception {
        Assertions.assertTrue((boolean)this.database.listStoreFiles(true).stream().map(metaData -> metaData.path().getFileName()).anyMatch(fileName -> {
            try {
                return TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(fileName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }

    @Test
    void shouldNotListTxLogFiles() throws Exception {
        Assertions.assertTrue((boolean)this.database.listStoreFiles(false).stream().map(metaData -> metaData.path().getFileName()).noneMatch(fileName -> {
            try {
                return TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(fileName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }

    @Test
    void shouldListNeostoreFiles() throws Exception {
        DatabaseLayout layout = this.database.getDatabaseLayout();
        Set expectedFiles = layout.storeFiles();
        ResourceIterator storeFiles = this.database.listStoreFiles(false);
        Set listedStoreFiles = storeFiles.stream().map(StoreFileMetadata::path).collect(Collectors.toSet());
        Assertions.assertEquals((Object)expectedFiles, listedStoreFiles);
    }

    @Test
    void doNotListFilesFromAdditionalProviderThatRegisterTwice() throws IOException {
        StoreFileListing storeFileListing = this.database.getStoreFileListing();
        MarkerFileProvider provider = new MarkerFileProvider();
        storeFileListing.registerStoreFileProvider((StoreFileProvider)provider);
        storeFileListing.registerStoreFileProvider((StoreFileProvider)provider);
        ResourceIterator metadataResourceIterator = storeFileListing.builder().build();
        Assertions.assertEquals((long)1L, (long)metadataResourceIterator.stream().filter(metadata -> "marker".equals(metadata.path().getFileName().toString())).count());
    }

    private void verifyLogFilesWithCustomPathListing(Path path) throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath("customDb")).setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)path).build();
        GraphDatabaseAPI graphDatabase = (GraphDatabaseAPI)managementService.database("neo4j");
        Database database = (Database)graphDatabase.getDependencyResolver().resolveDependency(Database.class);
        LogFiles logFiles = (LogFiles)graphDatabase.getDependencyResolver().resolveDependency(LogFiles.class);
        Assertions.assertTrue((boolean)database.listStoreFiles(true).stream().anyMatch(metadata -> metadata.isLogFile() && logFiles.isLogFile(metadata.path())));
        Assertions.assertEquals((Object)path.getFileName().toString(), (Object)logFiles.logFilesDirectory().getParent().getFileName().toString());
        managementService.shutdown();
    }

    private static void filesInStoreDirAre(DatabaseLayout databaseLayout, String[] filenames, String[] dirs) {
        ArrayList<Path> files = new ArrayList<Path>();
        StoreFileListingTest.mockFiles(filenames, files, false);
        StoreFileListingTest.mockFiles(dirs, files, true);
        Mockito.when((Object)databaseLayout.listDatabaseFiles((Predicate)ArgumentMatchers.any())).thenReturn((Object)files.toArray(new Path[0]));
    }

    private static ResourceIterator<Path> indexFilesAre(IndexingService indexingService, String[] fileNames) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        StoreFileListingTest.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)indexingService.snapshotIndexFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void createIndexDbFile() throws IOException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        Path indexFile = databaseLayout.file("index.db");
        if (Files.notExists(indexFile, new LinkOption[0])) {
            Files.createFile(indexFile, new FileAttribute[0]);
        }
    }

    private static void mockFiles(String[] filenames, List<Path> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            Path path = (Path)Mockito.mock(Path.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            Mockito.when((Object)path.toFile()).thenReturn((Object)file);
            files.add(path);
        }
    }

    private static class MarkerFileProvider
    implements StoreFileProvider {
        private MarkerFileProvider() {
        }

        public Resource addFilesTo(Collection<StoreFileMetadata> fileMetadataCollection) {
            fileMetadataCollection.add(new StoreFileMetadata(Path.of("marker", new String[0]), 0));
            return Resource.EMPTY;
        }
    }
}

