/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@DbmsExtension
class DbmsRuntimeSystemGraphComponentTest {
    @Inject
    private GraphDatabaseService userDatabase;
    private GraphDatabaseService fakeSystemDb;
    private final SystemGraphComponents systemGraphComponents = new SystemGraphComponents();
    private DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent;

    DbmsRuntimeSystemGraphComponentTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.fakeSystemDb = new FakeSystemDb(this.userDatabase);
        this.initDbmsComponent(false);
    }

    @Test
    void testInitialisationOnFreshDatabase() {
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void testInitialisationOnExistingDatabase() {
        DbmsRuntimeSystemGraphComponentTest.createVersionNode(this.userDatabase);
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.V5_0, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.UNINITIALIZED);
    }

    @Test
    void testInitialisationOnExistingDatabaseWithAutomaticUpgrade() {
        this.systemGraphComponents.deregister("dbms-runtime");
        this.initDbmsComponent(true);
        DbmsRuntimeSystemGraphComponentTest.createVersionNode(this.userDatabase);
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void testCurrentVersionPresent() {
        DbmsRuntimeSystemGraphComponentTest.createVersionNode(this.userDatabase, DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION);
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void testOldVersionPresent() {
        DbmsRuntimeSystemGraphComponentTest.createVersionNode(this.userDatabase, DbmsRuntimeVersion.V4_2);
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.V4_2, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.REQUIRES_UPGRADE);
    }

    @Test
    void testUpgrade() throws Exception {
        DbmsRuntimeSystemGraphComponentTest.createVersionNode(this.userDatabase, DbmsRuntimeVersion.V4_2);
        this.assertStatus(SystemGraphComponent.Status.REQUIRES_UPGRADE);
        this.systemGraphComponents.upgradeToCurrent(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void upgradeFromUninitialized() throws Exception {
        this.assertStatus(SystemGraphComponent.Status.UNINITIALIZED);
        this.systemGraphComponents.upgradeToCurrent(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void initializeRuntimeVersionNodeToLatestVersion() {
        DbmsRuntimeSystemGraphComponentTest.createRuntimeComponentNode(this.userDatabase, DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
        this.systemGraphComponents.initializeSystemGraph(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    @Test
    void updateRuntimeVersionNodeToLatestVersion() throws Exception {
        DbmsRuntimeSystemGraphComponentTest.createRuntimeComponentNode(this.userDatabase, DbmsRuntimeVersion.V4_2);
        this.systemGraphComponents.upgradeToCurrent(this.fakeSystemDb);
        this.assertVersion((ComponentVersion)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, this.fakeSystemDb);
        this.assertStatus(SystemGraphComponent.Status.CURRENT);
    }

    private void initDbmsComponent(boolean automaticUpgrade) {
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.allow_single_automatic_upgrade, (Object)automaticUpgrade).build();
        this.dbmsRuntimeSystemGraphComponent = new DbmsRuntimeSystemGraphComponent(config);
        this.systemGraphComponents.register((SystemGraphComponent)this.dbmsRuntimeSystemGraphComponent);
    }

    private void assertVersion(ComponentVersion expectedVersion, GraphDatabaseService system) {
        this.systemGraphComponents.forEach(component -> {
            if (component instanceof DbmsRuntimeSystemGraphComponent) {
                DbmsRuntimeVersion foundVersion = (DbmsRuntimeVersion)((DbmsRuntimeSystemGraphComponent)component).fetchStateFromSystemDatabase(system);
                Assertions.assertEquals((Object)expectedVersion, (Object)foundVersion);
            }
        });
    }

    private void assertStatus(SystemGraphComponent.Status expectedStatus) {
        try (Transaction tx = this.userDatabase.beginTx();){
            Assertions.assertEquals((Object)expectedStatus, (Object)this.dbmsRuntimeSystemGraphComponent.detect(tx));
        }
    }

    private static void createVersionNode(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            tx.createNode(new Label[]{SystemGraphComponent.VERSION_LABEL});
            tx.commit();
        }
    }

    private static void createVersionNode(GraphDatabaseService database, DbmsRuntimeVersion version) {
        try (Transaction tx = database.beginTx();){
            tx.createNode(new Label[]{SystemGraphComponent.VERSION_LABEL}).setProperty("dbms-runtime", (Object)version.getVersion());
            tx.commit();
        }
    }

    private static void createRuntimeComponentNode(GraphDatabaseService database, DbmsRuntimeVersion version) {
        try (Transaction tx = database.beginTx();){
            tx.createNode(new Label[]{DbmsRuntimeSystemGraphComponent.OLD_COMPONENT_LABEL}).setProperty("version", (Object)version.getVersion());
            tx.commit();
        }
    }

    private static class FakeSystemDb
    implements GraphDatabaseService {
        private final GraphDatabaseService wrappedDb;

        FakeSystemDb(GraphDatabaseService wrappedDb) {
            this.wrappedDb = wrappedDb;
        }

        public boolean isAvailable() {
            return this.wrappedDb.isAvailable();
        }

        public boolean isAvailable(long timeoutMillis) {
            return this.wrappedDb.isAvailable(timeoutMillis);
        }

        public Transaction beginTx() {
            return this.wrappedDb.beginTx();
        }

        public Transaction beginTx(long timeout, TimeUnit unit) {
            return this.wrappedDb.beginTx(timeout, unit);
        }

        public void executeTransactionally(String query) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public void executeTransactionally(String query, Map<String, Object> parameters) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer, Duration timeout) throws QueryExecutionException {
            throw new IllegalStateException("Not implemented");
        }

        public String databaseName() {
            return "system";
        }
    }
}

