/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class IndexingCompositeQueryAcceptanceTest {
    @Inject
    private GraphDatabaseAPI db;
    public static final String TOKEN_NAME = "TOKEN1";
    private static final IndexSeek biIndexSeek = (tx, keys, values, entityControl) -> {
        assert (keys.length == 2);
        assert (values.length == 2);
        return entityControl.findEntities(tx, TOKEN_NAME, keys[0], values[0], keys[1], values[1]);
    };
    private static final IndexSeek triIndexSeek = (tx, keys, values, entityControl) -> {
        assert (keys.length == 3);
        assert (values.length == 3);
        return entityControl.findEntities(tx, TOKEN_NAME, keys[0], values[0], keys[1], values[1], keys[2], values[2]);
    };
    private static final IndexSeek mapIndexSeek = (tx, keys, values, entityControl) -> entityControl.findEntities(tx, TOKEN_NAME, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, values));

    public static Stream<Arguments> data() {
        return IndexingCompositeQueryAcceptanceTest.generate(DataSet.values(), IndexingMode.values(), EntityTypes.values());
    }

    private static Stream<Arguments> generate(DataSet[] dataSets, IndexingMode[] indexingModes, EntityControl[] entityControls) {
        Stream.Builder<Arguments> builder = Stream.builder();
        for (DataSet dataSet : dataSets) {
            for (IndexingMode indexingMode : indexingModes) {
                for (EntityControl entityControl : entityControls) {
                    builder.add(Arguments.arguments((Object[])new Object[]{dataSet, indexingMode, entityControl}));
                }
            }
        }
        return builder.build();
    }

    public void createIndex(IndexingMode withIndex, String[] keys, EntityControl entityControl) {
        switch (withIndex) {
            case NONE: {
                try (Transaction tx = this.db.beginTx();){
                    tx.schema().getIndexes().forEach(IndexDefinition::drop);
                    tx.commit();
                    break;
                }
            }
            case PROPERTY_RANGE: {
                this.createAndWaitForIndex(keys, entityControl, IndexType.RANGE);
                break;
            }
        }
    }

    private void createAndWaitForIndex(String[] keys, EntityControl entityControl, IndexType indexType) {
        String indexName;
        try (Transaction tx = this.db.beginTx();){
            indexName = entityControl.createIndex(tx, TOKEN_NAME, keys, indexType);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(indexName, 5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest(name="shouldSupportIndexSeek using {0} with {1} index for {2}")
    @MethodSource(value={"data"})
    public void shouldSupportIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(withIndex, dataSet.keys, entityControl);
        IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, dataSet.nonMatching);
        MutableLongSet expected = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.values});
        try (Transaction tx = this.db.beginTx();){
            found = dataSet.indexSeek.findEntities(tx, dataSet.keys, dataSet.values, entityControl);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest(name="shouldSupportIndexSeekBackwardsOrder using {0} with {1} index for {2}")
    @MethodSource(value={"data"})
    public void shouldSupportIndexSeekBackwardsOrder(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(withIndex, dataSet.keys, entityControl);
        IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, dataSet.nonMatching);
        MutableLongSet expected = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.values});
        String[] reversedKeys = new String[dataSet.keys.length];
        Object[] reversedValues = new Object[dataSet.keys.length];
        for (int i = 0; i < dataSet.keys.length; ++i) {
            reversedValues[dataSet.keys.length - 1 - i] = dataSet.values[i];
            reversedKeys[dataSet.keys.length - 1 - i] = dataSet.keys[i];
        }
        try (Transaction tx = this.db.beginTx();){
            found = dataSet.indexSeek.findEntities(tx, reversedKeys, reversedValues, entityControl);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest(name="shouldIncludeEntitiesCreatedInSameTxInIndexSeek using {0} with {1} index for {2}")
    @MethodSource(value={"data"})
    public void shouldIncludeEntitiesCreatedInSameTxInIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(withIndex, dataSet.keys, entityControl);
        IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, dataSet.nonMatching[0], dataSet.nonMatching[1]);
        MutableLongSet expected = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.values});
        try (Transaction tx = this.db.beginTx();){
            expected.add(entityControl.createEntity(tx, TOKEN_NAME, IndexingCompositeQueryAcceptanceTest.propertyMap(dataSet.keys, dataSet.values)));
            entityControl.createEntity(tx, TOKEN_NAME, IndexingCompositeQueryAcceptanceTest.propertyMap(dataSet.keys, dataSet.nonMatching[2]));
            found = dataSet.indexSeek.findEntities(tx, dataSet.keys, dataSet.values, entityControl);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest(name="shouldNotIncludeEntitiesDeletedInSameTxInIndexSeek using {0} with {1} index for {2}")
    @MethodSource(value={"data"})
    public void shouldNotIncludeEntitiesDeletedInSameTxInIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(withIndex, dataSet.keys, entityControl);
        IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.nonMatching[0]});
        MutableLongSet toDelete = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, dataSet.values, dataSet.nonMatching[1], dataSet.nonMatching[2]);
        MutableLongSet expected = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.values});
        try (Transaction tx = this.db.beginTx();){
            LongIterator deleting = toDelete.longIterator();
            while (deleting.hasNext()) {
                long id = deleting.next();
                entityControl.deleteEntity(tx, id);
                expected.remove(id);
            }
            found = dataSet.indexSeek.findEntities(tx, dataSet.keys, dataSet.values, entityControl);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    @ParameterizedTest(name="shouldConsiderEntitiesChangedInSameTxInIndexSeek using {0} with {1} index for {2}")
    @MethodSource(value={"data"})
    public void shouldConsiderEntitiesChangedInSameTxInIndexSeek(DataSet dataSet, IndexingMode withIndex, EntityControl entityControl) {
        LongSet found;
        this.createIndex(withIndex, dataSet.keys, entityControl);
        IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.nonMatching[0]});
        MutableLongSet toChangeToMatch = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.nonMatching[1]});
        MutableLongSet toChangeToNotMatch = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.values});
        MutableLongSet expected = IndexingCompositeQueryAcceptanceTest.createEntities((GraphDatabaseService)this.db, entityControl, TOKEN_NAME, dataSet.keys, new Object[][]{dataSet.values});
        try (Transaction tx = this.db.beginTx();){
            LongIterator toMatching = toChangeToMatch.longIterator();
            while (toMatching.hasNext()) {
                long id = toMatching.next();
                entityControl.setProperties(tx, id, dataSet.keys, dataSet.values);
                expected.add(id);
            }
            LongIterator toNotMatching = toChangeToNotMatch.longIterator();
            while (toNotMatching.hasNext()) {
                long id = toNotMatching.next();
                entityControl.setProperties(tx, id, dataSet.keys, dataSet.nonMatching[2]);
                expected.remove(id);
            }
            found = dataSet.indexSeek.findEntities(tx, dataSet.keys, dataSet.values, entityControl);
        }
        Assertions.assertThat((Object)found).isEqualTo((Object)expected);
    }

    private static MutableLongSet createEntities(GraphDatabaseService db, EntityControl entityControl, String label, String[] keys, Object[] ... propertyValueTuples) {
        LongHashSet expected = new LongHashSet();
        try (Transaction tx = db.beginTx();){
            for (Object[] valueTuple : propertyValueTuples) {
                expected.add(entityControl.createEntity(tx, label, IndexingCompositeQueryAcceptanceTest.propertyMap(keys, valueTuple)));
            }
            tx.commit();
        }
        return expected;
    }

    private static Map<String, Object> propertyMap(String[] keys, Object[] valueTuple) {
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            propertyValues.put(keys[i], valueTuple[i]);
        }
        return propertyValues;
    }

    private static Object[] plus(Integer[] values, int offset) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] + offset;
        }
        return result;
    }

    private static LongSet mapToIds(ResourceIterator<? extends Entity> nodes) {
        try (ResourceIterator<? extends Entity> resourceIterator = nodes;){
            LongHashSet found = new LongHashSet();
            nodes.stream().mapToLong(Entity::getId).forEach(arg_0 -> ((MutableLongSet)found).add(arg_0));
            LongHashSet longHashSet = found;
            return longHashSet;
        }
    }

    static enum DataSet {
        BI_SEEK((Integer[])Iterators.array((Object[])new Integer[]{2, 3}), biIndexSeek),
        TRI_SEEK((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4}), triIndexSeek),
        MAP_SEEK((Integer[])Iterators.array((Object[])new Integer[]{2, 3, 4, 5, 6}), mapIndexSeek);

        String[] keys;
        Object[] values;
        Object[][] nonMatching;
        IndexSeek indexSeek;

        private DataSet(Integer[] values, IndexSeek indexSeek) {
            this.values = values;
            this.indexSeek = indexSeek;
            this.nonMatching = (Object[][])Iterators.array((Object[])new Object[][]{IndexingCompositeQueryAcceptanceTest.plus(values, 1), IndexingCompositeQueryAcceptanceTest.plus(values, 2), IndexingCompositeQueryAcceptanceTest.plus(values, 3)});
            this.keys = (String[])Arrays.stream(values).map(v -> "key" + v).toArray(String[]::new);
        }
    }

    static enum IndexingMode {
        NONE,
        TOKEN,
        PROPERTY_RANGE;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum EntityTypes implements EntityControl
    {
        NODE{

            @Override
            public String createIndex(Transaction tx, String tokenName, String[] keys, IndexType indexType) {
                IndexCreator indexCreator = tx.schema().indexFor(Label.label((String)tokenName)).withIndexType(indexType);
                for (String key : keys) {
                    indexCreator = indexCreator.on(key);
                }
                IndexDefinition indexDefinition = indexCreator.create();
                return indexDefinition.getName();
            }

            @Override
            public long createEntity(Transaction tx, String token, Map<String, Object> properties) {
                Node node = tx.createNode(new Label[]{Label.label((String)token)});
                properties.forEach((arg_0, arg_1) -> ((Node)node).setProperty(arg_0, arg_1));
                return node.getId();
            }

            @Override
            public void deleteEntity(Transaction tx, long id) {
                tx.getNodeById(id).delete();
            }

            @Override
            public void setProperties(Transaction tx, long id, String[] keys, Object[] values) {
                Node node = tx.getNodeById(id);
                for (int i = 0; i < keys.length; ++i) {
                    node.setProperty(keys[i], values[i]);
                }
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, String key1, Object value1, String key2, Object value2) {
                return IndexingCompositeQueryAcceptanceTest.mapToIds((ResourceIterator<? extends Entity>)tx.findNodes(Label.label((String)token), key1, value1, key2, value2));
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
                return IndexingCompositeQueryAcceptanceTest.mapToIds((ResourceIterator<? extends Entity>)tx.findNodes(Label.label((String)token), key1, value1, key2, value2, key3, value3));
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, Map<String, Object> propertyValues) {
                return IndexingCompositeQueryAcceptanceTest.mapToIds((ResourceIterator<? extends Entity>)tx.findNodes(Label.label((String)token), propertyValues));
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public String createIndex(Transaction tx, String tokenName, String[] keys, IndexType indexType) {
                IndexCreator indexCreator = tx.schema().indexFor(RelationshipType.withName((String)tokenName)).withIndexType(indexType);
                for (String key : keys) {
                    indexCreator = indexCreator.on(key);
                }
                return indexCreator.create().getName();
            }

            @Override
            public long createEntity(Transaction tx, String token, Map<String, Object> properties) {
                Node from = tx.createNode(new Label[]{Label.label((String)"node")});
                Node to = tx.createNode(new Label[]{Label.label((String)"node")});
                Relationship rel = from.createRelationshipTo(to, RelationshipType.withName((String)token));
                properties.forEach((arg_0, arg_1) -> ((Relationship)rel).setProperty(arg_0, arg_1));
                return rel.getId();
            }

            @Override
            public void deleteEntity(Transaction tx, long id) {
                tx.getRelationshipById(id).delete();
            }

            @Override
            public void setProperties(Transaction tx, long id, String[] keys, Object[] values) {
                Relationship rel = tx.getRelationshipById(id);
                for (int i = 0; i < keys.length; ++i) {
                    rel.setProperty(keys[i], values[i]);
                }
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, String key1, Object value1, String key2, Object value2) {
                return IndexingCompositeQueryAcceptanceTest.mapToIds((ResourceIterator<? extends Entity>)tx.findRelationships(RelationshipType.withName((String)token), key1, value1, key2, value2));
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
                return IndexingCompositeQueryAcceptanceTest.mapToIds((ResourceIterator<? extends Entity>)tx.findRelationships(RelationshipType.withName((String)token), key1, value1, key2, value2, key3, value3));
            }

            @Override
            public LongSet findEntities(Transaction tx, String token, Map<String, Object> propertyValues) {
                return IndexingCompositeQueryAcceptanceTest.mapToIds((ResourceIterator<? extends Entity>)tx.findRelationships(RelationshipType.withName((String)token), propertyValues));
            }
        };

    }

    static interface EntityControl {
        public String createIndex(Transaction var1, String var2, String[] var3, IndexType var4);

        public long createEntity(Transaction var1, String var2, Map<String, Object> var3);

        public void deleteEntity(Transaction var1, long var2);

        public void setProperties(Transaction var1, long var2, String[] var4, Object[] var5);

        public LongSet findEntities(Transaction var1, String var2, String var3, Object var4, String var5, Object var6);

        public LongSet findEntities(Transaction var1, String var2, String var3, Object var4, String var5, Object var6, String var7, Object var8);

        public LongSet findEntities(Transaction var1, String var2, Map<String, Object> var3);
    }

    private static interface IndexSeek {
        public LongSet findEntities(Transaction var1, String[] var2, Object[] var3, EntityControl var4);
    }
}

