/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongFunction;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.GeneratingInputIterator;
import org.neo4j.internal.batchimport.IdGroupDistribution;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.ParallelBatchImporter;
import org.neo4j.internal.batchimport.RandomsStates;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ProcessorAssignmentStrategies;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.SuppressOutput;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Values;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class, SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
public class ParallelBatchImporterTest {
    private static final int NODE_COUNT = 10000;
    private static final int RELATIONSHIPS_PER_NODE = 5;
    private static final int RELATIONSHIP_COUNT = 50000;
    private static final int RELATIONSHIP_TYPES = 3;
    private static final int NUMBER_OF_ID_GROUPS = 5;
    @Inject
    private RandomSupport random;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private SuppressOutput suppressOutput;
    @Inject
    private DatabaseLayout databaseLayout;
    private InputIdGenerator inputIdGenerator;
    private final Configuration config = new Configuration(){

        public int batchSize() {
            return 100;
        }

        public int maxNumberOfWorkerThreads() {
            int cores = Runtime.getRuntime().availableProcessors();
            return ParallelBatchImporterTest.this.random.intBetween(cores, cores + 100);
        }

        public long maxOffHeapMemory() {
            double ratio = 10.0;
            long mebi = ByteUnit.mebiBytes((long)1L);
            return ParallelBatchImporterTest.this.random.nextInt((int)(ratio * (double)mebi / 2.0), (int)(ratio * (double)mebi));
        }
    };
    private static final String[] TOKENS = new String[]{"token1", "token2", "token3", "token4", "token5", "token6", "token7"};

    private static Stream<Arguments> params() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new LongInputIdGenerator(), IdType.INTEGER}), Arguments.arguments((Object[])new Object[]{new StringInputIdGenerator(), IdType.STRING}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"params"})
    void shouldImportCsvData(InputIdGenerator inputIdGenerator, IdType idType) throws Exception {
        this.inputIdGenerator = inputIdGenerator;
        ExecutionMonitor processorAssigner = ProcessorAssignmentStrategies.eagerRandomSaturation((int)this.config.maxNumberOfWorkerThreads());
        CapturingMonitor monitor = new CapturingMonitor(processorAssigner);
        boolean successful = false;
        Groups groups = new Groups();
        IdGroupDistribution groupDistribution = new IdGroupDistribution(10000L, 5, this.random.random(), groups);
        long nodeRandomSeed = this.random.nextLong();
        long relationshipRandomSeed = this.random.nextLong();
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
        Config dbConfig = Config.defaults((Setting)GraphDatabaseSettings.dense_node_threshold, (Object)10);
        this.augmentConfig(dbConfig);
        IndexImporterFactoryImpl indexImporterFactory = new IndexImporterFactoryImpl();
        ParallelBatchImporter inserter = new ParallelBatchImporter(this.databaseLayout, this.fs, (PageCacheTracer)pageCacheTracer, this.config, (LogService)NullLogService.getInstance(), (ExecutionMonitor)monitor, AdditionalInitialIds.EMPTY, LogTailMetadata.EMPTY_LOG_TAIL, dbConfig, Monitor.NO_MONITOR, (JobScheduler)jobScheduler, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)indexImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, contextFactory);
        LongAdder propertyCount = new LongAdder();
        LongAdder relationshipCount = new LongAdder();
        try {
            inserter.doImport(Input.input((InputIterable)ParallelBatchImporterTest.nodes(nodeRandomSeed, 10000L, this.config.batchSize(), inputIdGenerator, groupDistribution, propertyCount), (InputIterable)this.relationships(relationshipRandomSeed, 50000L, this.config.batchSize(), inputIdGenerator, groupDistribution, propertyCount, relationshipCount), (IdType)idType, (Input.Estimates)Input.knownEstimates((long)10000L, (long)50000L, (long)(10000 * TOKENS.length / 2), (long)(50000 * TOKENS.length / 2), (long)(10000 * TOKENS.length / 2 * 8), (long)(50000 * TOKENS.length / 2 * 8), (long)(10000 * TOKENS.length / 2)), (ReadableGroups)groups));
            Assertions.assertThat((long)pageCacheTracer.pins()).isGreaterThan(0L);
            Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(pageCacheTracer.unpins());
            Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(Math.addExact(pageCacheTracer.faults(), pageCacheTracer.hits()));
            DatabaseManagementService managementService = this.getDBMSBuilder(this.databaseLayout).build();
            GraphDatabaseService db = managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                inputIdGenerator.reset();
                this.verifyData(10000, 50000, db, tx, groupDistribution, nodeRandomSeed, relationshipRandomSeed);
                tx.commit();
            }
            finally {
                managementService.shutdown();
            }
            Assertions.assertThat((boolean)this.mentionsCountsStoreRebuild(this.databaseLayout)).isFalse();
            ParallelBatchImporterTest.assertConsistent(this.databaseLayout);
            successful = true;
        }
        finally {
            jobScheduler.close();
            if (!successful) {
                Path failureFile = this.databaseLayout.databaseDirectory().resolve("input");
                try (PrintStream out = new PrintStream(Files.newOutputStream(failureFile, new OpenOption[0]));){
                    out.println("Seed used in this failing run: " + this.random.seed());
                    out.println(inputIdGenerator);
                    inputIdGenerator.reset();
                    out.println();
                    out.println("Processor assignments");
                    out.println(processorAssigner);
                }
                System.err.println("Additional debug information stored in " + failureFile);
            }
        }
    }

    private boolean mentionsCountsStoreRebuild(DatabaseLayout databaseLayout) throws IOException {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)databaseLayout.getNeo4jLayout().homeDirectory()).build();
        Path debugLogPath = ((Path)config.get(GraphDatabaseSettings.logs_directory)).resolve("debug.log");
        try (Stream<String> lines = Files.lines(debugLogPath);){
            boolean bl = lines.anyMatch(line -> line.contains("Missing counts store, rebuilding it") && line.contains("[" + databaseLayout.getDatabaseName()));
            return bl;
        }
    }

    static void assertConsistent(DatabaseLayout databaseLayout) throws ConsistencyCheckIncompleteException {
        final ConsistencyCheckService.Result result = new ConsistencyCheckService(databaseLayout).with(Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L))).runFullConsistencyCheck();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isSuccessful()).as(new Description(){

            public String value() {
                StringBuilder builder = new StringBuilder("Database contains inconsistencies. " + result);
                if (result.reportFile() != null) {
                    builder.append(String.format("%nInconsistencies:", new Object[0]));
                    try {
                        Files.lines(result.reportFile()).forEach(line -> builder.append(String.format("%n%s", line)));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return builder.toString();
            }
        })).isTrue();
    }

    protected void augmentConfig(Config config) {
    }

    protected TestDatabaseManagementServiceBuilder getDBMSBuilder(DatabaseLayout layout) {
        return new TestDatabaseManagementServiceBuilder(layout);
    }

    private void verifyData(int nodeCount, int relationshipCount, GraphDatabaseService db, Transaction tx, IdGroupDistribution groups, long nodeRandomSeed, long relationshipRandomSeed) throws IOException {
        LongAdder propertyCount = new LongAdder();
        try (InputIterator nodes = ParallelBatchImporterTest.nodes(nodeRandomSeed, nodeCount, this.config.batchSize(), this.inputIdGenerator, groups, propertyCount).iterator();
             InputIterator relationships = this.relationships(relationshipRandomSeed, relationshipCount, this.config.batchSize(), this.inputIdGenerator, groups, propertyCount, new LongAdder()).iterator();
             ResourceIterable dbNodes = tx.getAllNodes();){
            HashMap<String, Node> nodeByInputId = new HashMap<String, Node>(nodeCount);
            for (Node node : dbNodes) {
                String id = (String)node.getProperty("id");
                org.junit.jupiter.api.Assertions.assertNull((Object)nodeByInputId.put(id, node));
            }
            int verifiedNodes = 0;
            long allNodesScanLabelCount = 0L;
            InputChunk chunk = nodes.newChunk();
            InputEntity input = new InputEntity();
            while (nodes.next(chunk)) {
                while (chunk.next((InputEntityVisitor)input)) {
                    String iid = ParallelBatchImporterTest.uniqueId(input.idGroup, input.objectId);
                    Node node = (Node)nodeByInputId.get(iid);
                    ParallelBatchImporterTest.assertNodeEquals(input, node);
                    ++verifiedNodes;
                    ParallelBatchImporterTest.assertDegrees(node);
                    allNodesScanLabelCount += Iterables.count((Iterable)node.getLabels());
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)nodeCount, (int)verifiedNodes);
            long labelScanStoreEntryCount = Iterables.stream((Iterable)tx.getAllLabels()).mapToLong(l -> Iterators.count((Iterator)tx.findNodes(l))).sum();
            org.junit.jupiter.api.Assertions.assertEquals((long)allNodesScanLabelCount, (long)labelScanStoreEntryCount, (String)String.format("Expected label scan store and node store to have same number labels. But %n#labelsInNodeStore=%d%n#labelsInLabelScanStore=%d%n", allNodesScanLabelCount, labelScanStoreEntryCount));
            chunk = relationships.newChunk();
            HashMap<String, Relationship> relationshipByName = new HashMap<String, Relationship>();
            try (ResourceIterable allRelationships = tx.getAllRelationships();){
                for (Relationship relationship : allRelationships) {
                    relationshipByName.put((String)relationship.getProperty("id"), relationship);
                }
            }
            int verifiedRelationships = 0;
            while (relationships.next(chunk)) {
                while (chunk.next((InputEntityVisitor)input)) {
                    if (!this.inputIdGenerator.isMiss(input.objectStartId) && !this.inputIdGenerator.isMiss(input.objectEndId)) {
                        Relationship relationship;
                        String name = (String)ParallelBatchImporterTest.propertyOf(input, "id");
                        relationship = (Relationship)relationshipByName.get(name);
                        org.junit.jupiter.api.Assertions.assertNotNull((Object)relationship, (String)("Expected there to be a relationship with name '" + name + "'"));
                        org.junit.jupiter.api.Assertions.assertEquals(nodeByInputId.get(ParallelBatchImporterTest.uniqueId(input.startIdGroup, input.objectStartId)), (Object)relationship.getStartNode());
                        org.junit.jupiter.api.Assertions.assertEquals(nodeByInputId.get(ParallelBatchImporterTest.uniqueId(input.endIdGroup, input.objectEndId)), (Object)relationship.getEndNode());
                        ParallelBatchImporterTest.assertRelationshipEquals(input, relationship);
                    }
                    ++verifiedRelationships;
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)relationshipCount, (int)verifiedRelationships);
        }
    }

    private static void assertDegrees(Node node) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            for (Direction direction : Direction.values()) {
                long degree = node.getDegree(type, direction);
                long actualDegree = Iterables.count((Iterable)node.getRelationships(direction, new RelationshipType[]{type}));
                org.junit.jupiter.api.Assertions.assertEquals((long)actualDegree, (long)degree);
            }
        }
    }

    private static String uniqueId(Group group, Object id) {
        return group.name() + "_" + id;
    }

    private static Object propertyOf(InputEntity input, String key) {
        Object[] properties = input.properties();
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i++].equals(key)) continue;
            return properties[i];
        }
        throw new IllegalStateException(key + " not found on " + input);
    }

    private static void assertRelationshipEquals(InputEntity input, Relationship relationship) {
        ParallelBatchImporterTest.assertPropertiesEquals(input, (Entity)relationship);
        org.junit.jupiter.api.Assertions.assertEquals((Object)input.stringType, (Object)relationship.getType().name());
    }

    private static void assertNodeEquals(InputEntity input, Node node) {
        ParallelBatchImporterTest.assertPropertiesEquals(input, (Entity)node);
        Set expectedLabels = Iterators.asSet((Object[])input.labels());
        for (Label label : node.getLabels()) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedLabels.remove(label.name()));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedLabels.isEmpty());
    }

    private static void assertPropertiesEquals(InputEntity input, Entity entity) {
        Object[] properties = input.properties();
        for (int i = 0; i < properties.length; ++i) {
            String key = (String)properties[i++];
            Object value = properties[i];
            ParallelBatchImporterTest.assertPropertyValueEquals(input, entity, key, value, entity.getProperty(key));
        }
    }

    private static void assertPropertyValueEquals(InputEntity input, Entity entity, String key, Object expected, Object array) {
        if (expected.getClass().isArray()) {
            int length = Array.getLength(expected);
            org.junit.jupiter.api.Assertions.assertEquals((int)length, (int)Array.getLength(array), (String)(input + ", " + entity));
            for (int i = 0; i < length; ++i) {
                ParallelBatchImporterTest.assertPropertyValueEquals(input, entity, key, Array.get(expected, i), Array.get(array, i));
            }
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.of((Object)expected), (Object)Values.of((Object)array), (String)(input + ", " + entity + " for key:" + key));
        }
    }

    private InputIterable relationships(long randomSeed, long count, int batchSize, InputIdGenerator idGenerator, IdGroupDistribution groups, LongAdder propertyCount, LongAdder relationshipCount) {
        return () -> new GeneratingInputIterator(count, batchSize, (LongFunction)new RandomsStates(randomSeed), (randoms, visitor, id) -> {
            int thisPropertyCount = ParallelBatchImporterTest.randomProperties(randoms, "Name " + id, visitor);
            ExistingId startNodeExistingId = idGenerator.randomExisting((RandomValues)randoms);
            Group startNodeGroup = groups.groupOf(startNodeExistingId.nodeIndex);
            ExistingId endNodeExistingId = idGenerator.randomExisting((RandomValues)randoms);
            Group endNodeGroup = groups.groupOf(endNodeExistingId.nodeIndex);
            Object startNode = idGenerator.miss((RandomValues)randoms, startNodeExistingId.id, 0.001f);
            Object endNode = idGenerator.miss((RandomValues)randoms, endNodeExistingId.id, 0.001f);
            if (!this.inputIdGenerator.isMiss(startNode) && !this.inputIdGenerator.isMiss(endNode)) {
                relationshipCount.increment();
                propertyCount.add(thisPropertyCount);
            }
            visitor.startId(startNode, startNodeGroup);
            visitor.endId(endNode, endNodeGroup);
            Object type = InputIdGenerator.randomType(randoms);
            if ((double)randoms.nextFloat() < 5.0E-5) {
                type = (String)type + "_odd";
            }
            visitor.type((String)type);
        }, 0L);
    }

    private static InputIterable nodes(long randomSeed, long count, int batchSize, InputIdGenerator inputIdGenerator, IdGroupDistribution groups, LongAdder propertyCount) {
        return () -> new GeneratingInputIterator(count, batchSize, (LongFunction)new RandomsStates(randomSeed), (randoms, visitor, id) -> {
            Object nodeId = inputIdGenerator.nextNodeId((RandomValues)randoms, id);
            Group group = groups.groupOf(id);
            visitor.id(nodeId, group);
            propertyCount.add(ParallelBatchImporterTest.randomProperties(randoms, ParallelBatchImporterTest.uniqueId(group, nodeId), visitor));
            visitor.labels((String[])randoms.selection((Object[])TOKENS, 0, TOKENS.length, true));
        }, 0L);
    }

    private static int randomProperties(RandomValues randoms, Object id, InputEntityVisitor visitor) {
        String[] keys;
        for (String key : keys = (String[])randoms.selection((Object[])TOKENS, 0, TOKENS.length, false)) {
            visitor.property(key, randoms.nextValue().asObject());
        }
        visitor.property("id", id);
        return keys.length + 1;
    }

    private static class LongInputIdGenerator
    extends InputIdGenerator {
        private LongInputIdGenerator() {
        }

        @Override
        void reset() {
        }

        @Override
        synchronized Object nextNodeId(RandomValues random, long item) {
            return item;
        }

        @Override
        ExistingId randomExisting(RandomValues random) {
            long index = random.nextInt(10000);
            return new ExistingId(index, index);
        }

        @Override
        Object miss(RandomValues random, Object id, float chance) {
            return random.nextFloat() < chance ? Long.valueOf((Long)id + 100000000L) : id;
        }

        @Override
        boolean isMiss(Object id) {
            return (Long)id >= 100000000L;
        }
    }

    private static class StringInputIdGenerator
    extends InputIdGenerator {
        private final String[] strings = new String[10000];

        private StringInputIdGenerator() {
        }

        @Override
        void reset() {
            Arrays.fill(this.strings, null);
        }

        @Override
        Object nextNodeId(RandomValues random, long item) {
            String result;
            byte[] randomBytes = random.nextByteArray(10, 10).asObjectCopy();
            this.strings[Math.toIntExact((long)item)] = result = UUID.nameUUIDFromBytes(randomBytes).toString();
            return result;
        }

        @Override
        ExistingId randomExisting(RandomValues random) {
            int index = random.nextInt(this.strings.length);
            return new ExistingId(this.strings[index], index);
        }

        @Override
        Object miss(RandomValues random, Object id, float chance) {
            return random.nextFloat() < chance ? "_" + id : id;
        }

        @Override
        boolean isMiss(Object id) {
            return ((String)id).startsWith("_");
        }
    }

    public static abstract class InputIdGenerator {
        abstract void reset();

        abstract Object nextNodeId(RandomValues var1, long var2);

        abstract ExistingId randomExisting(RandomValues var1);

        abstract Object miss(RandomValues var1, Object var2, float var3);

        abstract boolean isMiss(Object var1);

        static String randomType(RandomValues random) {
            return "TYPE" + random.nextInt(3);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class CapturingMonitor
    implements ExecutionMonitor {
        private final ExecutionMonitor delegate;
        private String additionalInformation;

        CapturingMonitor(ExecutionMonitor delegate) {
            this.delegate = delegate;
        }

        public void initialize(DependencyResolver dependencyResolver) {
            this.delegate.initialize(dependencyResolver);
        }

        public void start(StageExecution execution) {
            this.delegate.start(execution);
        }

        public void end(StageExecution execution, long totalTimeMillis) {
            this.delegate.end(execution, totalTimeMillis);
        }

        public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.delegate.done(successful, totalTimeMillis, additionalInformation);
        }

        public long checkIntervalMillis() {
            return this.delegate.checkIntervalMillis();
        }

        public void check(StageExecution execution) {
            this.delegate.check(execution);
        }
    }

    private static class ExistingId {
        private final Object id;
        private final long nodeIndex;

        ExistingId(Object id, long nodeIndex) {
            this.id = id;
            this.nodeIndex = nodeIndex;
        }
    }
}

