/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.ParallelBatchImporter;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityDecorators;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class CsvInputBatchImportIT {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private RandomSupport random;
    @Inject
    private RecordDatabaseLayout databaseLayout;
    private static final Supplier<ZoneId> testDefaultTimeZone = () -> ZoneId.of("Asia/Shanghai");

    CsvInputBatchImportIT() {
    }

    @Test
    void shouldImportDataComingFromCsvFiles() throws Exception {
        Config dbConfig = Config.newBuilder().set(GraphDatabaseSettings.db_timezone, (Object)LogTimeZone.SYSTEM).set(GraphDatabaseSettings.dense_node_threshold, (Object)5).build();
        try (ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();){
            ParallelBatchImporter importer = new ParallelBatchImporter((DatabaseLayout)this.databaseLayout, this.fileSystem, PageCacheTracer.NULL, CsvInputBatchImportIT.smallBatchSizeConfig(), (LogService)NullLogService.getInstance(), ExecutionMonitor.INVISIBLE, AdditionalInitialIds.EMPTY, LogTailMetadata.EMPTY_LOG_TAIL, dbConfig, Monitor.NO_MONITOR, (JobScheduler)scheduler, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, CursorContextFactory.NULL_CONTEXT_FACTORY);
            Groups groups = new Groups();
            Group group = groups.getOrCreate(null);
            List<InputEntity> nodeData = this.randomNodeData(group);
            List<InputEntity> relationshipData = this.randomRelationshipData(nodeData, group);
            importer.doImport(CsvInputBatchImportIT.csv(this.nodeDataAsFile(nodeData), this.relationshipDataAsFile(relationshipData), IdType.STRING, CsvInputBatchImportIT.lowBufferSize(org.neo4j.csv.reader.Configuration.COMMAS), groups));
            this.verifyImportedData(nodeData, relationshipData);
        }
    }

    static Input csv(Path nodes, Path relationships, IdType idType, org.neo4j.csv.reader.Configuration configuration, Groups groups) {
        return new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (Path[])new Path[]{nodes})}), DataFactories.defaultFormatNodeFileHeader(testDefaultTimeZone, (boolean)false), DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (Path[])new Path[]{relationships})}), DataFactories.defaultFormatRelationshipFileHeader(testDefaultTimeZone, (boolean)false), idType, configuration, false, CsvInput.NO_MONITOR, groups, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static org.neo4j.csv.reader.Configuration lowBufferSize(org.neo4j.csv.reader.Configuration actual) {
        return actual.toBuilder().withBufferSize(10000).build();
    }

    private List<InputEntity> randomNodeData(Group group) {
        ArrayList<InputEntity> nodes = new ArrayList<InputEntity>();
        for (int i = 0; i < 300; ++i) {
            InputEntity node = new InputEntity();
            node.id((Object)UUID.randomUUID().toString(), group);
            node.property("name", (Object)("Node " + i));
            node.property("pointA", (Object)("\"   { x : -4.2, y : " + i % 90 + ", crs: WGS-84 } \""));
            node.property("pointB", (Object)("\" { x : -8, y : " + i + " } \""));
            node.property("date", (Object)LocalDate.of(2018, i % 12 + 1, i % 28 + 1));
            node.property("time", (Object)OffsetTime.of(1, i % 60, 0, 0, ZoneOffset.ofHours(9)));
            node.property("dateTime", (Object)ZonedDateTime.of(2011, 9, 11, 8, i % 60, 0, 0, ZoneId.of("Europe/Stockholm")));
            node.property("dateTime2", (Object)LocalDateTime.of(2011, 9, 11, 8, i % 60, 0, 0));
            node.property("localTime", (Object)LocalTime.of(1, i % 60, 0));
            node.property("localDateTime", (Object)LocalDateTime.of(2011, 9, 11, 8, i % 60));
            node.property("duration", (Object)Period.of(2, -3, i % 30));
            node.property("floatArray", (Object)new float[]{1.0f, 2.0f, 3.0f});
            node.property("dateArray", (Object)new LocalDate[]{LocalDate.of(2018, i % 12 + 1, i % 28 + 1)});
            node.property("pointArray", (Object)("\" { x : -8, y : " + i + " } \""));
            node.labels(CsvInputBatchImportIT.randomLabels(this.random.random()));
            nodes.add(node);
        }
        return nodes;
    }

    private static String[] randomLabels(Random random) {
        String[] labels = new String[random.nextInt(3)];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = "Label" + random.nextInt(4);
        }
        return labels;
    }

    private static Configuration smallBatchSizeConfig() {
        return Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)100);
    }

    private Path relationshipDataAsFile(List<InputEntity> relationshipData) throws IOException {
        Path file = this.testDirectory.file("relationships.csv");
        try (StringWriter stringWriter = new StringWriter();){
            CsvInputBatchImportIT.println(stringWriter, ":start_id,:end_id,:type");
            for (InputEntity relationship : relationshipData) {
                CsvInputBatchImportIT.println(stringWriter, relationship.startId() + "," + relationship.endId() + "," + relationship.stringType);
            }
            FileSystemUtils.writeString((FileSystemAbstraction)this.fileSystem, (Path)file, (String)stringWriter.toString(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        return file;
    }

    private Path nodeDataAsFile(List<InputEntity> nodeData) throws IOException {
        Path file = this.testDirectory.file("nodes.csv");
        try (StringWriter writer = new StringWriter();){
            CsvInputBatchImportIT.println(writer, "id:ID,name,pointA:Point{crs:WGS-84},pointB:Point,date:Date,time:Time,dateTime:DateTime,dateTime2:DateTime,localTime:LocalTime,localDateTime:LocalDateTime,duration:Duration,floatArray:float[],dateArray:date[],pointArray:point[],some-labels:LABEL");
            for (InputEntity node : nodeData) {
                String csvLabels = this.csvLabels(node.labels());
                StringBuilder sb = new StringBuilder().append(node.id()).append(',');
                for (int i = 0; i < node.propertyCount(); ++i) {
                    sb.append(this.serializePropertyValue(node.propertyValue(i))).append(',');
                }
                if (csvLabels != null && !csvLabels.isEmpty()) {
                    sb.append(csvLabels);
                }
                CsvInputBatchImportIT.println(writer, sb.toString());
            }
            FileSystemUtils.writeString((FileSystemAbstraction)this.fileSystem, (Path)file, (String)writer.toString(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        return file;
    }

    private String serializePropertyValue(Object value) {
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType() == Float.TYPE) {
                return StringUtils.join((float[])((float[])value), (char)';');
            }
            return StringUtils.join((Object[])((Object[])value), (char)';');
        }
        return value.toString();
    }

    private String csvLabels(String[] labels) {
        if (labels == null || labels.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(builder.length() > 0 ? ";" : "").append(label);
        }
        return builder.toString();
    }

    private static void println(Writer writer, String string) throws IOException {
        writer.write(string + "\n");
    }

    private List<InputEntity> randomRelationshipData(List<InputEntity> nodeData, Group group) {
        ArrayList<InputEntity> relationships = new ArrayList<InputEntity>();
        for (int i = 0; i < 1000; ++i) {
            InputEntity relationship = new InputEntity();
            relationship.startId(nodeData.get(this.random.nextInt(nodeData.size())).id(), group);
            relationship.endId(nodeData.get(this.random.nextInt(nodeData.size())).id(), group);
            relationship.type("TYPE_" + this.random.nextInt(3));
            relationships.add(relationship);
        }
        return relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyImportedData(List<InputEntity> nodeData, List<InputEntity> relationshipData) {
        HashMap<String, InputEntity> expectedNodes = new HashMap<String, InputEntity>();
        HashMap<String, String[]> expectedNodeNames = new HashMap<String, String[]>();
        HashMap<String, Map<String, Consumer<Object>>> expectedNodePropertyVerifiers = new HashMap<String, Map<String, Consumer<Object>>>();
        AutoCreatingHashMap expectedRelationships = new AutoCreatingHashMap(AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.values(AtomicInteger.class))));
        AutoCreatingHashMap expectedNodeCounts = new AutoCreatingHashMap(AutoCreatingHashMap.values(AtomicLong.class));
        AutoCreatingHashMap expectedRelationshipCounts = new AutoCreatingHashMap(AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.nested((Factory)AutoCreatingHashMap.values(AtomicLong.class))));
        CsvInputBatchImportIT.buildUpExpectedData(nodeData, relationshipData, expectedNodes, expectedNodeNames, expectedNodePropertyVerifiers, (Map<String, Map<String, Map<String, AtomicInteger>>>)expectedRelationships, (Map<String, AtomicLong>)expectedNodeCounts, (Map<String, Map<String, Map<String, AtomicLong>>>)expectedRelationshipCounts);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();
             ResourceIterable allNodes = tx.getAllNodes();){
            for (Node node : allNodes) {
                String name = (String)node.getProperty("name");
                Object[] labels = (String[])expectedNodeNames.remove(name);
                org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])labels), CsvInputBatchImportIT.names(node.getLabels()));
                Map expectedPropertyVerifiers = (Map)expectedNodePropertyVerifiers.remove(name);
                Map map = node.getAllProperties();
                map.remove("id");
                for (Map.Entry actualProperty : map.entrySet()) {
                    Consumer v = (Consumer)expectedPropertyVerifiers.get(actualProperty.getKey());
                    if (v == null) continue;
                    v.accept(actualProperty.getValue());
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expectedNodeNames.size());
            try (ResourceIterable allRelationships = tx.getAllRelationships();){
                for (Relationship relationship : allRelationships) {
                    String startNodeName = (String)relationship.getStartNode().getProperty("name");
                    Map inner = (Map)expectedRelationships.get(startNodeName);
                    String string = (String)relationship.getEndNode().getProperty("name");
                    Map innerInner = (Map)inner.get(string);
                    String type = relationship.getType().name();
                    int countAfterwards = ((AtomicInteger)innerInner.get(type)).decrementAndGet();
                    Assertions.assertThat((int)countAfterwards).isGreaterThanOrEqualTo(0);
                    if (countAfterwards != 0) continue;
                    innerInner.remove(type);
                    if (!innerInner.isEmpty()) continue;
                    inner.remove(string);
                    if (!inner.isEmpty()) continue;
                    expectedRelationships.remove(startNodeName);
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expectedRelationships.size());
            RecordStorageEngine storageEngine = (RecordStorageEngine)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = storageEngine.testAccessNeoStores();
            CountsAccessor counts = storageEngine.countsAccessor();
            Function<String, Integer> labelTranslationTable = CsvInputBatchImportIT.translationTable(neoStores.getLabelTokenStore(), -1, storageEngine);
            for (Pair pair : CsvInputBatchImportIT.allNodeCounts(labelTranslationTable, (Map<String, AtomicLong>)expectedNodeCounts)) {
                org.junit.jupiter.api.Assertions.assertEquals((long)((Long)pair.other()), (long)counts.nodeCount(((Integer)pair.first()).intValue(), CursorContext.NULL_CONTEXT), (String)("Label count mismatch for label " + pair.first()));
            }
            Function<String, Integer> relationshipTypeTranslationTable = CsvInputBatchImportIT.translationTable(neoStores.getRelationshipTypeTokenStore(), -1, storageEngine);
            for (Pair<RelationshipCountKey, Long> count : CsvInputBatchImportIT.allRelationshipCounts(labelTranslationTable, relationshipTypeTranslationTable, (Map<String, Map<String, Map<String, AtomicLong>>>)expectedRelationshipCounts)) {
                RelationshipCountKey key = (RelationshipCountKey)count.first();
                org.junit.jupiter.api.Assertions.assertEquals((long)((Long)count.other()), (long)counts.relationshipCount(key.startLabel, key.type, key.endLabel, CursorContext.NULL_CONTEXT), (String)("Label count mismatch for label " + key));
            }
            tx.commit();
        }
        finally {
            managementService.shutdown();
        }
    }

    private static Iterable<Pair<RelationshipCountKey, Long>> allRelationshipCounts(Function<String, Integer> labelTranslationTable, Function<String, Integer> relationshipTypeTranslationTable, Map<String, Map<String, Map<String, AtomicLong>>> counts) {
        ArrayList<Pair<RelationshipCountKey, Long>> result = new ArrayList<Pair<RelationshipCountKey, Long>>();
        for (Map.Entry<String, Map<String, Map<String, AtomicLong>>> startLabel : counts.entrySet()) {
            for (Map.Entry<String, Map<String, AtomicLong>> type : startLabel.getValue().entrySet()) {
                for (Map.Entry<String, AtomicLong> endLabel : type.getValue().entrySet()) {
                    RelationshipCountKey key = new RelationshipCountKey(labelTranslationTable.apply(startLabel.getKey()), relationshipTypeTranslationTable.apply(type.getKey()), labelTranslationTable.apply(endLabel.getKey()));
                    result.add((Pair<RelationshipCountKey, Long>)Pair.of((Object)key, (Object)endLabel.getValue().longValue()));
                }
            }
        }
        return result;
    }

    private static Iterable<Pair<Integer, Long>> allNodeCounts(Function<String, Integer> labelTranslationTable, Map<String, AtomicLong> counts) {
        ArrayList<Pair<Integer, Long>> result = new ArrayList<Pair<Integer, Long>>();
        for (Map.Entry<String, AtomicLong> count : counts.entrySet()) {
            result.add((Pair<Integer, Long>)Pair.of((Object)labelTranslationTable.apply(count.getKey()), (Object)count.getValue().get()));
        }
        counts.put(null, new AtomicLong(counts.size()));
        return result;
    }

    private static Function<String, Integer> translationTable(TokenStore<?> tokenStore, int anyValue, RecordStorageEngine storageEngine) {
        HashMap<String, Integer> translationTable = new HashMap<String, Integer>();
        try (StoreCursors storeCursors = storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            for (NamedToken token : tokenStore.getTokens(storeCursors)) {
                translationTable.put(token.name(), token.id());
            }
            Function<String, Integer> function = from -> from == null ? anyValue : (Integer)translationTable.get(from);
            return function;
        }
    }

    private static Set<String> names(Iterable<Label> labels) {
        HashSet<String> names = new HashSet<String>();
        for (Label label : labels) {
            names.add(label.name());
        }
        return names;
    }

    private static void buildUpExpectedData(List<InputEntity> nodeData, List<InputEntity> relationshipData, Map<String, InputEntity> expectedNodes, Map<String, String[]> expectedNodeNames, Map<String, Map<String, Consumer<Object>>> expectedNodePropertyVerifiers, Map<String, Map<String, Map<String, AtomicInteger>>> expectedRelationships, Map<String, AtomicLong> nodeCounts, Map<String, Map<String, Map<String, AtomicLong>>> relationshipCounts) {
        for (InputEntity node : nodeData) {
            expectedNodes.put((String)node.id(), node);
            expectedNodeNames.put(CsvInputBatchImportIT.nameOf(node), node.labels());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasIntPropertyKeyIds);
            TreeMap<String, Consumer<Object>> propertyVerifiers = new TreeMap<String, Consumer<Object>>();
            for (int i = 0; i < node.propertyCount(); ++i) {
                Consumer<Object> verify;
                Object expectedValue = node.propertyValue(i);
                if (expectedValue instanceof TemporalAmount) {
                    verify = actualValue -> {
                        LocalDateTime referenceTemporal = LocalDateTime.of(0, 1, 1, 0, 0);
                        LocalDateTime expected = referenceTemporal.plus((TemporalAmount)expectedValue);
                        LocalDateTime actual = referenceTemporal.plus((TemporalAmount)actualValue);
                        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
                    };
                } else if (expectedValue instanceof Temporal) {
                    LocalDate expectedDate = ((Temporal)expectedValue).query(TemporalQueries.localDate());
                    LocalTime expectedTime = ((Temporal)expectedValue).query(TemporalQueries.localTime());
                    ZoneId expectedZoneId = ((Temporal)expectedValue).query(TemporalQueries.zone());
                    verify = actualValue -> {
                        LocalDate actualDate = ((Temporal)actualValue).query(TemporalQueries.localDate());
                        LocalTime actualTime = ((Temporal)actualValue).query(TemporalQueries.localTime());
                        ZoneId actualZoneId = ((Temporal)actualValue).query(TemporalQueries.zone());
                        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedDate, (Object)actualDate);
                        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTime, (Object)actualTime);
                        if (expectedZoneId == null) {
                            if (actualZoneId != null) {
                                org.junit.jupiter.api.Assertions.assertEquals((Object)testDefaultTimeZone.get(), (Object)actualZoneId);
                            }
                        } else {
                            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedZoneId, (Object)actualZoneId);
                        }
                    };
                } else {
                    verify = expectedValue instanceof float[] ? actualValue -> org.junit.jupiter.api.Assertions.assertArrayEquals((float[])((float[])expectedValue), (float[])((float[])actualValue)) : (expectedValue.getClass().isArray() ? actualValue -> org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])((Object[])expectedValue), (Object[])((Object[])actualValue)) : actualValue -> org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValue, (Object)actualValue));
                }
                propertyVerifiers.put((String)node.propertyKey(i), verify);
            }
            Consumer<Object> verifyPointA = actualValue -> {
                PointValue v = (PointValue)actualValue;
                double actualY = ((Coordinate)v.getCoordinates().get(0)).getCoordinate()[1];
                double expectedY = CsvInputBatchImportIT.indexOf(node) % 90;
                String message = actualValue + " does not have y=" + expectedY;
                org.junit.jupiter.api.Assertions.assertEquals((double)expectedY, (double)actualY, (double)0.1, (String)message);
                message = actualValue + " does not have crs=wgs-84";
                org.junit.jupiter.api.Assertions.assertEquals((Object)CoordinateReferenceSystem.WGS_84.getName(), (Object)v.getCoordinateReferenceSystem().getName(), (String)message);
            };
            propertyVerifiers.put("pointA", verifyPointA);
            Consumer<Object> verifyPointB = actualValue -> {
                PointValue v = (PointValue)actualValue;
                double actualY = ((Coordinate)v.getCoordinates().get(0)).getCoordinate()[1];
                double expectedY = CsvInputBatchImportIT.indexOf(node);
                String message = actualValue + " does not have y=" + expectedY;
                org.junit.jupiter.api.Assertions.assertEquals((double)expectedY, (double)actualY, (double)0.1, (String)message);
                message = actualValue + " does not have crs=cartesian";
                org.junit.jupiter.api.Assertions.assertEquals((Object)CoordinateReferenceSystem.CARTESIAN.getName(), (Object)v.getCoordinateReferenceSystem().getName(), (String)message);
            };
            propertyVerifiers.put("pointB", verifyPointB);
            Consumer<Object> verifyPointArray = actualValue -> verifyPointB.accept(((PointValue[])actualValue)[0]);
            propertyVerifiers.put("pointArray", verifyPointArray);
            expectedNodePropertyVerifiers.put(CsvInputBatchImportIT.nameOf(node), propertyVerifiers);
            CsvInputBatchImportIT.countNodeLabels(nodeCounts, node.labels());
        }
        for (InputEntity relationship : relationshipData) {
            InputEntity startNode = expectedNodes.get(relationship.startId());
            InputEntity endNode = expectedNodes.get(relationship.endId());
            expectedRelationships.get(CsvInputBatchImportIT.nameOf(startNode)).get(CsvInputBatchImportIT.nameOf(endNode)).get(relationship.stringType).incrementAndGet();
            relationshipCounts.get(null).get(null).get(null).incrementAndGet();
            relationshipCounts.get(null).get(relationship.stringType).get(null).incrementAndGet();
            for (String startNodeLabelName : Iterators.asSet((Object[])startNode.labels())) {
                Map<String, Map<String, AtomicLong>> startLabelCounts = relationshipCounts.get(startNodeLabelName);
                startLabelCounts.get(null).get(null).incrementAndGet();
                Map<String, AtomicLong> typeCounts = startLabelCounts.get(relationship.stringType);
                typeCounts.get(null).incrementAndGet();
            }
            for (String endNodeLabelName : Iterators.asSet((Object[])endNode.labels())) {
                relationshipCounts.get(null).get(null).get(endNodeLabelName).incrementAndGet();
                relationshipCounts.get(null).get(relationship.stringType).get(endNodeLabelName).incrementAndGet();
            }
        }
    }

    private static void countNodeLabels(Map<String, AtomicLong> nodeCounts, String[] labels) {
        HashSet<String> seen = new HashSet<String>();
        for (String labelName : labels) {
            if (!seen.add(labelName)) continue;
            nodeCounts.get(labelName).incrementAndGet();
        }
    }

    private static String nameOf(InputEntity node) {
        return (String)node.properties()[1];
    }

    private static int indexOf(InputEntity node) {
        return Integer.parseInt(((String)node.properties()[1]).split("\\s")[1]);
    }

    private static class RelationshipCountKey {
        private final int startLabel;
        private final int type;
        private final int endLabel;

        RelationshipCountKey(int startLabel, int type, int endLabel) {
            this.startLabel = startLabel;
            this.type = type;
            this.endLabel = endLabel;
        }

        public String toString() {
            return String.format("[start:%d, type:%d, end:%d]", this.startLabel, this.type, this.endLabel);
        }
    }
}

