/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Procedure;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class QueryTracingIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private static final List<ExecutingQuery> queries = new ArrayList<ExecutingQuery>();

    @ExtensionCallback
    protected void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.addExtension((ExtensionFactory)new CustomProcedureExtensionFactory());
    }

    @Test
    void chainedQueryExecution() {
        try (InternalTransaction transaction = this.databaseAPI.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
             KernelStatement statement = (KernelStatement)transaction.kernelTransaction().acquireStatement();){
            QueryRegistry queryRegistry = statement.queryRegistry();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)queryRegistry.executingQuery().isEmpty());
            Assertions.assertThat(queries).isEmpty();
            String outerQuery = "CALL db.testCaptureProcedure()";
            String innerQuery = "match (n) return count(n)";
            try (Result result = transaction.execute(outerQuery);){
                result.next();
            }
            Assertions.assertThat(queries).hasSize(3);
            Assertions.assertThat((String)queries.get(0).rawQueryText()).isEqualTo(outerQuery);
            Assertions.assertThat((String)queries.get(1).rawQueryText()).isEqualTo(innerQuery);
            Assertions.assertThat((String)queries.get(2).rawQueryText()).isEqualTo(outerQuery);
        }
    }

    private static class CustomProcedureExtensionFactory
    extends ExtensionFactory<Dependencies> {
        protected CustomProcedureExtensionFactory() {
            super("customProcedureFactory");
        }

        public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
            try {
                dependencies.procedures().registerProcedure(QueryCapturingProcedure.class);
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
            return new LifecycleAdapter();
        }

        static interface Dependencies {
            public GlobalProcedures procedures();
        }
    }

    public static class QueryCapturingProcedure {
        @Context
        public Transaction transaction;

        @Procedure(name="db.testCaptureProcedure")
        public Stream<Result> myProc() {
            KernelStatement statement = (KernelStatement)((InternalTransaction)this.transaction).kernelTransaction().acquireStatement();
            queries.add((ExecutingQuery)statement.queryRegistry().executingQuery().get());
            try (org.neo4j.graphdb.Result result = this.transaction.execute("match (n) return count(n)");){
                queries.add((ExecutingQuery)statement.queryRegistry().executingQuery().get());
            }
            queries.add((ExecutingQuery)statement.queryRegistry().executingQuery().get());
            return Stream.of(new Result());
        }

        public static class Result {
            public Long value = 7L;
        }
    }
}

