/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TransactionalQueryExecutionIT {
    @Inject
    private GraphDatabaseService db;

    TransactionalQueryExecutionIT() {
    }

    @Test
    void executeQueryTransactionally() {
        Label marker = Label.label((String)"MARKER");
        Assertions.assertEquals((long)0L, (long)this.countMarkedNodes(marker));
        this.db.executeTransactionally("CREATE (n:MARKER)");
        this.db.executeTransactionally("CREATE (n:MARKER)");
        this.db.executeTransactionally("CREATE (n:MARKER)");
        Assertions.assertEquals((long)3L, (long)this.countMarkedNodes(marker));
    }

    @Test
    void executeQueryAndConsumeResult() {
        this.db.executeTransactionally("CREATE (n:CONSUMABLE)");
        this.db.executeTransactionally("CREATE (n:CONSUMABLE)");
        this.db.executeTransactionally("CREATE (n:CONSUMABLE)");
        this.db.executeTransactionally("CREATE (n:CONSUMABLE)");
        Assertions.assertEquals((int)4, (Integer)((Integer)this.db.executeTransactionally("MATCH (n:CONSUMABLE) RETURN n", Collections.emptyMap(), (ResultTransformer)new CountingResultTransformer())));
    }

    @Test
    void executeQueryWithParametersTransactionally() {
        this.db.executeTransactionally("CREATE (n:NODE) SET n = $data RETURN n", MapUtil.map((Object[])new Object[]{"data", MapUtil.map((Object[])new Object[]{"key", "value"})}));
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertNotNull((Object)transaction.findNode(Label.label((String)"NODE"), "key", (Object)"value"));
        }
    }

    private long countMarkedNodes(Label marker) {
        try (Transaction transaction = this.db.beginTx();){
            long l = Iterators.count((Iterator)transaction.findNodes(marker));
            return l;
        }
    }

    private static class CountingResultTransformer
    implements ResultTransformer<Integer> {
        private CountingResultTransformer() {
        }

        public Integer apply(Result result) {
            int nodeCounter = 0;
            while (result.hasNext()) {
                Map row = result.next();
                if (row.get("n") == null) continue;
                ++nodeCounter;
            }
            return nodeCounter;
        }
    }
}

