/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configuration")
public class TextIndexCreationTest {
    @Inject
    private GraphDatabaseAPI db;
    private int labelId;
    private int relTypeId;
    private int[] propertyIds;
    private int[] compositeKey;

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
    }

    protected IndexProviderDescriptor getIndexProviderDescriptor() {
        return TextIndexProvider.DESCRIPTOR;
    }

    @BeforeEach
    void setup() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            TokenWrite tokenWrite = ktx.tokenWrite();
            this.labelId = tokenWrite.labelGetOrCreateForName(Label.label((String)"PERSON").name());
            this.relTypeId = tokenWrite.relationshipTypeGetOrCreateForName(RelationshipType.withName((String)"FRIEND").name());
            this.propertyIds = new int[]{tokenWrite.propertyKeyGetOrCreateForName("name")};
            this.compositeKey = new int[]{tokenWrite.propertyKeyGetOrCreateForName("address"), tokenWrite.propertyKeyGetOrCreateForName("age")};
            tx.commit();
        }
    }

    @Test
    void shouldRejectCompositeKeys() {
        this.assertUnsupported(() -> this.createTextIndex("nti", (SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])this.compositeKey)));
        this.assertUnsupported(() -> this.createTextIndex("rti", (SchemaDescriptor)SchemaDescriptors.forRelType((int)this.relTypeId, (int[])this.compositeKey)));
    }

    private void assertUnsupported(Executable executable) {
        String message = ((UnsupportedOperationException)org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)executable)).getMessage();
        Assertions.assertThat((String)message).isEqualTo("Composite indexes are not supported for TEXT index type.");
    }

    @Test
    void shouldCreateIndexes() throws Exception {
        this.createTextIndex("node_text_index", (SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])this.propertyIds));
        this.createTextIndex("rel_text_index", (SchemaDescriptor)SchemaDescriptors.forRelType((int)this.relTypeId, (int[])this.propertyIds));
        this.awaitIndexesOnline();
        try (Transaction transaction = this.db.beginTx();){
            KernelTransaction ktx = ((TransactionImpl)transaction).kernelTransaction();
            this.assertValidTextIndex(ktx.schemaRead().indexGetForName("node_text_index"), this.propertyIds);
            this.assertValidTextIndex(ktx.schemaRead().indexGetForName("rel_text_index"), this.propertyIds);
        }
    }

    private void awaitIndexesOnline() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
        }
    }

    private void assertValidTextIndex(IndexDescriptor index, int[] propertyIds) {
        Assertions.assertThat((Comparable)index.getIndexType()).isEqualTo((Object)IndexType.TEXT);
        Assertions.assertThat((Object[])index.getCapability().behaviours()).isEmpty();
        Assertions.assertThat((int[])index.schema().getPropertyIds()).isEqualTo((Object)propertyIds);
        Assertions.assertThat((boolean)index.getCapability().supportsOrdering()).isFalse();
        Assertions.assertThat((boolean)index.getCapability().supportsReturningValues()).isFalse();
    }

    private void createTextIndex(String name, SchemaDescriptor schema) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.TEXT).withIndexProvider(this.getIndexProviderDescriptor()).withName(name);
            KernelTransaction kernelTransaction = ((InternalTransaction)tx).kernelTransaction();
            kernelTransaction.schemaWrite().indexCreate(prototype);
            tx.commit();
        }
    }
}

