/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.SpecialisedIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.index.schema.TokenIndexProviderFactory;
import org.neo4j.monitoring.Monitors;

class TokenIndexProviderCompatibilitySuiteTest
extends SpecialisedIndexProviderCompatibilityTestSuite {
    TokenIndexProviderCompatibilitySuiteTest() {
    }

    @Override
    IndexPrototype indexPrototype() {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE));
    }

    @Override
    IndexType indexType() {
        return IndexType.LOOKUP;
    }

    @Override
    IndexProvider createIndexProvider(PageCache pageCache, FileSystemAbstraction fs, Path graphDbDir, Config config) {
        Monitors monitors = new Monitors();
        String monitorTag = "";
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)graphDbDir);
        NamedDatabaseId defaultDatabaseId = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("neo4j")).thenReturn(Optional.of(defaultDatabaseId));
        ReadOnlyDatabases readOnlyDatabases = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{new ConfigBasedLookupFactory(config, databaseIdRepository)});
        DatabaseReadOnlyChecker readOnlyChecker = readOnlyDatabases.forDatabase(defaultDatabaseId);
        return TokenIndexProviderFactory.create((PageCache)pageCache, (Path)graphDbDir, (FileSystemAbstraction)fs, (Monitors)monitors, (String)monitorTag, (DatabaseReadOnlyChecker)readOnlyChecker, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector, (DatabaseLayout)databaseLayout, (CursorContextFactory)CursorContextFactory.NULL_CONTEXT_FACTORY, (PageCacheTracer)PageCacheTracer.NULL);
    }
}

