/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class DynamicTransactionReadOnlyIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private Config config;

    DynamicTransactionReadOnlyIT() {
    }

    @Test
    void byDefaultDatabaseIsWritable() {
        Assertions.assertDoesNotThrow(() -> {
            try (Transaction tx = this.database.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void reactToDatabaseReadOnlyMode() {
        this.config.set(GraphDatabaseSettings.read_only_databases, Set.of(this.database.databaseName()));
        try {
            try (Transaction tx = this.database.beginTx();){
                Assertions.assertThrows(WriteOperationsNotAllowedException.class, () -> ((Transaction)tx).createNode());
            }
            this.config.set(GraphDatabaseSettings.read_only_databases, Collections.emptySet());
            Assertions.assertDoesNotThrow(() -> {
                try (Transaction tx = this.database.beginTx();){
                    tx.createNode();
                    tx.commit();
                }
            });
        }
        finally {
            this.config.set(GraphDatabaseSettings.read_only_databases, Collections.emptySet());
        }
    }
}

