/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.batchimport.cache.idmapping.string.Workers;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
class InternalTransactionCommitProcessIT {
    private static final int TOTAL_ACTIVE_THREADS = 6;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private GBPTreeCountsStore countsStore;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private TransactionIdStore transactionIdStore;

    InternalTransactionCommitProcessIT() {
    }

    @ExtensionCallback
    static void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(10L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    void commitDuringContinuousCheckpointing() throws Exception {
        final AtomicBoolean done = new AtomicBoolean();
        Workers workers = new Workers(this.getClass().getSimpleName());
        try {
            for (int i = 0; i < 6; ++i) {
                workers.start(new Runnable(){
                    private final ThreadLocalRandom random = ThreadLocalRandom.current();

                    @Override
                    public void run() {
                        while (!done.get()) {
                            try (Transaction tx = InternalTransactionCommitProcessIT.this.db.beginTx();){
                                tx.createNode();
                                tx.commit();
                            }
                            this.randomSleep();
                        }
                    }

                    private void randomSleep() {
                        try {
                            Thread.sleep(this.random.nextInt(50));
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        }
        finally {
            done.set(true);
        }
        workers.awaitAndThrowOnError();
        ((AbstractLongAssert)Assertions.assertThat((long)this.countsStore.txId()).as("Count store should be rotated once at least", new Object[0])).isGreaterThan(0L);
        long lastRotationTx = this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        org.junit.jupiter.api.Assertions.assertEquals((long)this.transactionIdStore.getLastClosedTransactionId(), (long)lastRotationTx, (String)"NeoStore last closed transaction id should be equal last count store rotation transaction id.");
        org.junit.jupiter.api.Assertions.assertEquals((long)this.transactionIdStore.getLastClosedTransactionId(), (long)this.countsStore.txId(), (String)"Last closed transaction should be last rotated tx in count store");
    }
}

