/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class DenseNodeRelChainPositionTest {
    @Inject
    private GraphDatabaseService db;

    DenseNodeRelChainPositionTest() {
    }

    @Test
    void givenDenseNodeWhenAskForWrongDirectionThenIncorrectNrOfRelsReturned() {
        Node node1;
        int denseNodeThreshold = (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue() + 1;
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode();
            Node node2 = tx.createNode();
            for (int i = 0; i < denseNodeThreshold; ++i) {
                node1.createRelationshipTo(node2, RelationshipType.withName((String)"FOO"));
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node node1b = tx.getNodeById(node1.getId());
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)node1b.getRelationships(Direction.INCOMING)));
            Assertions.assertEquals((long)denseNodeThreshold, (long)Iterables.count((Iterable)node1b.getRelationships(Direction.OUTGOING)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

