/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import java.util.Iterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class TestNeo4jCacheAndPersistence
extends AbstractNeo4jTestCase {
    @Inject
    private TestDirectory testDirectory;
    private static final String key1 = "key1";
    private static final String key2 = "key2";
    private static final String arrayKey = "arrayKey";
    private static final Integer int1 = 1;
    private static final Integer int2 = 2;
    private static final String string1 = "1";
    private static final String string2 = "2";
    private final int[] array = new int[]{1, 2, 3, 4, 5, 6, 7};
    private long node1Id = -1L;
    private long node2Id = -1L;

    TestNeo4jCacheAndPersistence() {
    }

    @BeforeEach
    void createTestingGraph() {
        Node node1 = TestNeo4jCacheAndPersistence.createNode();
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node2 = transaction.createNode();
            node1 = transaction.getNodeById(node1.getId());
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            this.node1Id = node1.getId();
            this.node2Id = node2.getId();
            node1.setProperty(key1, (Object)int1);
            node1.setProperty(key2, (Object)string1);
            node2.setProperty(key1, (Object)int2);
            node2.setProperty(key2, (Object)string2);
            rel.setProperty(key1, (Object)int1);
            rel.setProperty(key2, (Object)string1);
            node1.setProperty(arrayKey, (Object)this.array);
            node2.setProperty(arrayKey, (Object)this.array);
            rel.setProperty(arrayKey, (Object)this.array);
            transaction.commit();
        }
        transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((Object)1, (Object)transaction.getNodeById(node1.getId()).getProperty(key1));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @AfterEach
    void deleteTestingGraph() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(this.node1Id);
            Node node2 = transaction.getNodeById(this.node2Id);
            node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH).delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testAddProperty() {
        String key3 = "key3";
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(this.node1Id);
            Node node2 = transaction.getNodeById(this.node2Id);
            Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
            node2.setProperty(key3, (Object)int1);
            rel.setProperty(key3, (Object)int2);
            Assertions.assertTrue((boolean)node1.hasProperty(key1));
            Assertions.assertTrue((boolean)node2.hasProperty(key1));
            Assertions.assertTrue((boolean)node1.hasProperty(key2));
            Assertions.assertTrue((boolean)node2.hasProperty(key2));
            Assertions.assertTrue((boolean)node1.hasProperty(arrayKey));
            Assertions.assertTrue((boolean)node2.hasProperty(arrayKey));
            Assertions.assertTrue((boolean)rel.hasProperty(arrayKey));
            Assertions.assertFalse((boolean)node1.hasProperty(key3));
            Assertions.assertTrue((boolean)node2.hasProperty(key3));
            Assertions.assertEquals((Object)int1, (Object)node1.getProperty(key1));
            Assertions.assertEquals((Object)int2, (Object)node2.getProperty(key1));
            Assertions.assertEquals((Object)string1, (Object)node1.getProperty(key2));
            Assertions.assertEquals((Object)string2, (Object)node2.getProperty(key2));
            Assertions.assertEquals((Object)int1, (Object)rel.getProperty(key1));
            Assertions.assertEquals((Object)string1, (Object)rel.getProperty(key2));
            Assertions.assertEquals((Object)int2, (Object)rel.getProperty(key3));
            transaction.commit();
        }
    }

    @Test
    void testNodeRemoveProperty() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(this.node1Id);
            Node node2 = transaction.getNodeById(this.node2Id);
            Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
            Assertions.assertEquals((Object)1, (Object)node1.removeProperty(key1));
            Assertions.assertEquals((Object)2, (Object)node2.removeProperty(key1));
            Assertions.assertEquals((Object)1, (Object)rel.removeProperty(key1));
            Assertions.assertEquals((Object)string1, (Object)node1.removeProperty(key2));
            Assertions.assertEquals((Object)string2, (Object)node2.removeProperty(key2));
            Assertions.assertEquals((Object)string1, (Object)rel.removeProperty(key2));
            Assertions.assertNotNull((Object)node1.removeProperty(arrayKey));
            Assertions.assertNotNull((Object)node2.removeProperty(arrayKey));
            Assertions.assertNotNull((Object)rel.removeProperty(arrayKey));
            transaction.commit();
        }
    }

    @Test
    void testNodeChangeProperty() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(this.node1Id);
            Node node2 = transaction.getNodeById(this.node2Id);
            Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
            node1.setProperty(key1, (Object)int2);
            node2.setProperty(key1, (Object)int1);
            rel.setProperty(key1, (Object)int2);
            int[] newIntArray = new int[]{3, 2, 1};
            node1.setProperty(arrayKey, (Object)newIntArray);
            node2.setProperty(arrayKey, (Object)newIntArray);
            rel.setProperty(arrayKey, (Object)newIntArray);
            transaction.commit();
        }
    }

    @Test
    void testNodeGetProperties() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(this.node1Id);
            Assertions.assertFalse((boolean)node1.hasProperty(null));
            Iterator keys = node1.getPropertyKeys().iterator();
            keys.next();
            keys.next();
            Assertions.assertTrue((boolean)node1.hasProperty(key1));
            Assertions.assertTrue((boolean)node1.hasProperty(key2));
            transaction.commit();
        }
    }

    private static Relationship[] getRelationshipArray(Iterable<Relationship> relsIterable) {
        return (Relationship[])Iterables.asArray(Relationship.class, relsIterable);
    }

    @Test
    void testDirectedRelationship1() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(this.node1Id);
            Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
            Node[] nodes = rel.getNodes();
            Assertions.assertEquals((int)2, (int)nodes.length);
            Node node2 = transaction.getNodeById(this.node2Id);
            Assertions.assertTrue((nodes[0].equals(node1) && nodes[1].equals(node2) ? 1 : 0) != 0);
            Assertions.assertEquals((Object)node1, (Object)rel.getStartNode());
            Assertions.assertEquals((Object)node2, (Object)rel.getEndNode());
            Relationship[] relArray = TestNeo4jCacheAndPersistence.getRelationshipArray((Iterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel, (Object)relArray[0]);
            relArray = TestNeo4jCacheAndPersistence.getRelationshipArray((Iterable<Relationship>)node2.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel, (Object)relArray[0]);
            transaction.commit();
        }
    }

    @Test
    void testRelCountInSameTx() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertEquals((int)1, (int)TestNeo4jCacheAndPersistence.getRelationshipArray((Iterable<Relationship>)node1.getRelationships()).length);
            Assertions.assertEquals((int)1, (int)TestNeo4jCacheAndPersistence.getRelationshipArray((Iterable<Relationship>)node2.getRelationships()).length);
            rel.delete();
            Assertions.assertEquals((int)0, (int)TestNeo4jCacheAndPersistence.getRelationshipArray((Iterable<Relationship>)node1.getRelationships()).length);
            Assertions.assertEquals((int)0, (int)TestNeo4jCacheAndPersistence.getRelationshipArray((Iterable<Relationship>)node2.getRelationships()).length);
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testGetDirectedRelationship() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(this.node1Id);
            Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING);
            Assertions.assertEquals((Object)int1, (Object)rel.getProperty(key1));
            transaction.commit();
        }
    }

    @Test
    void testSameTxWithArray() {
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            Node nodeA = transaction.createNode();
            Node nodeB = transaction.createNode();
            Relationship relA = nodeA.createRelationshipTo(nodeB, (RelationshipType)MyRelTypes.TEST);
            nodeA.setProperty(arrayKey, (Object)this.array);
            relA.setProperty(arrayKey, (Object)this.array);
            Assertions.assertNotNull((Object)nodeA.getProperty(arrayKey));
            Assertions.assertNotNull((Object)relA.getProperty(arrayKey));
            relA.delete();
            nodeA.delete();
            nodeB.delete();
            transaction.commit();
        }
    }

    @Test
    void testAddCacheCleared() {
        int count;
        Relationship rel;
        Node nodeA = TestNeo4jCacheAndPersistence.createNode();
        Node nodeB = TestNeo4jCacheAndPersistence.createNode();
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            nodeA = transaction.getNodeById(nodeA.getId());
            nodeB = transaction.getNodeById(nodeB.getId());
            nodeA.setProperty(string1, (Object)1);
            rel = nodeA.createRelationshipTo(nodeB, (RelationshipType)MyRelTypes.TEST);
            rel.setProperty(string1, (Object)1);
            transaction.commit();
        }
        transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            nodeA = transaction.getNodeById(nodeA.getId());
            nodeB = transaction.getNodeById(nodeB.getId());
            rel = transaction.getRelationshipById(rel.getId());
            nodeA.createRelationshipTo(nodeB, (RelationshipType)MyRelTypes.TEST);
            count = (int)Iterables.count((Iterable)nodeA.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)2, (int)count);
            nodeA.setProperty(string2, (Object)2);
            Assertions.assertEquals((Object)1, (Object)nodeA.getProperty(string1));
            rel.setProperty(string2, (Object)2);
            Assertions.assertEquals((Object)1, (Object)rel.getProperty(string1));
            transaction.getNodeById(nodeA.getId());
            transaction.getRelationshipById(rel.getId());
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            nodeA = transaction.getNodeById(nodeA.getId());
            rel = transaction.getRelationshipById(rel.getId());
            count = (int)Iterables.count((Iterable)nodeA.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)2, (int)count);
            Assertions.assertEquals((Object)1, (Object)nodeA.getProperty(string1));
            Assertions.assertEquals((Object)1, (Object)rel.getProperty(string1));
            Assertions.assertEquals((Object)2, (Object)nodeA.getProperty(string2));
            Assertions.assertEquals((Object)2, (Object)rel.getProperty(string2));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testNodeMultiRemoveProperty() {
        Node node = TestNeo4jCacheAndPersistence.createNode();
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            node = transaction.getNodeById(node.getId());
            node.setProperty("key0", (Object)"0");
            node.setProperty(key1, (Object)string1);
            node.setProperty(key2, (Object)string2);
            node.setProperty("key3", (Object)"3");
            node.setProperty("key4", (Object)"4");
            transaction.commit();
        }
        transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            node = transaction.getNodeById(node.getId());
            node.removeProperty("key3");
            node.removeProperty(key2);
            node.removeProperty("key3");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            node = transaction.getNodeById(node.getId());
            Assertions.assertEquals((Object)"0", (Object)node.getProperty("key0"));
            Assertions.assertEquals((Object)string1, (Object)node.getProperty(key1));
            Assertions.assertEquals((Object)"4", (Object)node.getProperty("key4"));
            Assertions.assertFalse((boolean)node.hasProperty(key2));
            Assertions.assertFalse((boolean)node.hasProperty("key3"));
            node.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testRelMultiRemoveProperty() {
        Relationship rel;
        Node node1 = TestNeo4jCacheAndPersistence.createNode();
        Node node2 = TestNeo4jCacheAndPersistence.createNode();
        try (Transaction transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            rel.setProperty("key0", (Object)"0");
            rel.setProperty(key1, (Object)string1);
            rel.setProperty(key2, (Object)string2);
            rel.setProperty("key3", (Object)"3");
            rel.setProperty("key4", (Object)"4");
            transaction.commit();
        }
        transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipById(rel.getId());
            rel.removeProperty("key3");
            rel.removeProperty(key2);
            rel.removeProperty("key3");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            rel = transaction.getRelationshipById(rel.getId());
            Assertions.assertEquals((Object)"0", (Object)rel.getProperty("key0"));
            Assertions.assertEquals((Object)string1, (Object)rel.getProperty(key1));
            Assertions.assertEquals((Object)"4", (Object)rel.getProperty("key4"));
            Assertions.assertFalse((boolean)rel.hasProperty(key2));
            Assertions.assertFalse((boolean)rel.hasProperty("key3"));
            rel.delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLowGrabSize() {
        Node node2;
        Node node1;
        try (Transaction tx = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            node1 = tx.createNode();
            node2 = tx.createNode();
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST2);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            tx.commit();
        }
        tx = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            node1 = tx.getNodeById(node1.getId());
            node2 = tx.getNodeById(node2.getId());
            RelationshipType[] types = new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL};
            Assertions.assertEquals((long)3L, (long)Iterables.count((Iterable)node1.getRelationships(types)));
            Assertions.assertEquals((long)3L, (long)Iterables.count((Iterable)node1.getRelationships()));
            Assertions.assertEquals((long)3L, (long)Iterables.count((Iterable)node2.getRelationships(types)));
            Assertions.assertEquals((long)3L, (long)Iterables.count((Iterable)node2.getRelationships()));
            Assertions.assertEquals((long)2L, (long)Iterables.count((Iterable)node1.getRelationships(Direction.OUTGOING)));
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)node1.getRelationships(Direction.INCOMING)));
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)node2.getRelationships(Direction.OUTGOING)));
            Assertions.assertEquals((long)2L, (long)Iterables.count((Iterable)node2.getRelationships(Direction.INCOMING)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testAnotherLowGrabSize() {
        TestNeo4jCacheAndPersistence.testLowGrabSize(false);
    }

    @Test
    void testAnotherLowGrabSizeWithLoops() {
        TestNeo4jCacheAndPersistence.testLowGrabSize(true);
    }

    private static void testLowGrabSize(boolean includeLoops) {
        HashSet<Relationship> outgoingOriginal = new HashSet<Relationship>();
        HashSet<Relationship> incomingOriginal = new HashSet<Relationship>();
        HashSet<Relationship> loopsOriginal = new HashSet<Relationship>();
        Node node1 = TestNeo4jCacheAndPersistence.createNode();
        Node node2 = TestNeo4jCacheAndPersistence.createNode();
        Node node3 = TestNeo4jCacheAndPersistence.createNode();
        int total = 0;
        int totalOneDirection = 0;
        try (Transaction tx = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();){
            node1 = tx.getNodeById(node1.getId());
            node2 = tx.getNodeById(node2.getId());
            node3 = tx.getNodeById(node3.getId());
            for (int i = 0; i < 33; ++i) {
                if (includeLoops) {
                    loopsOriginal.add(node2.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
                    ++total;
                    ++totalOneDirection;
                }
                if (i % 2 == 0) {
                    incomingOriginal.add(node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
                    outgoingOriginal.add(node2.createRelationshipTo(node3, (RelationshipType)MyRelTypes.TEST));
                } else {
                    outgoingOriginal.add(node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST));
                    incomingOriginal.add(node3.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
                }
                total += 2;
                ++totalOneDirection;
            }
            tx.commit();
        }
        tx = TestNeo4jCacheAndPersistence.getGraphDb().beginTx();
        try {
            node2 = tx.getNodeById(node2.getId());
            HashSet<Relationship> rels = new HashSet<Relationship>();
            HashSet outgoing = new HashSet(outgoingOriginal);
            HashSet incoming = new HashSet(incomingOriginal);
            HashSet loops = new HashSet(loopsOriginal);
            try (ResourceIterable types = node2.getRelationships(new RelationshipType[]{MyRelTypes.TEST});){
                for (Relationship rel : types) {
                    Assertions.assertTrue((boolean)rels.add(rel));
                    if (rel.getStartNode().equals(node2) && rel.getEndNode().equals(node2)) {
                        Assertions.assertTrue((boolean)loops.remove(rel));
                        continue;
                    }
                    if (rel.getStartNode().equals(node2)) {
                        Assertions.assertTrue((boolean)outgoing.remove(rel));
                        continue;
                    }
                    Assertions.assertTrue((boolean)incoming.remove(rel));
                }
            }
            Assertions.assertEquals((int)total, (int)rels.size());
            Assertions.assertEquals((int)0, (int)loops.size());
            Assertions.assertEquals((int)0, (int)incoming.size());
            Assertions.assertEquals((int)0, (int)outgoing.size());
            rels.clear();
            outgoing = new HashSet(outgoingOriginal);
            incoming = new HashSet(incomingOriginal);
            loops = new HashSet(loopsOriginal);
            try (ResourceIterable relationships = node2.getRelationships(Direction.OUTGOING);){
                for (Relationship rel : relationships) {
                    Assertions.assertTrue((boolean)rels.add(rel));
                    if (rel.getStartNode().equals(node2) && rel.getEndNode().equals(node2)) {
                        Assertions.assertTrue((boolean)loops.remove(rel));
                        continue;
                    }
                    if (rel.getStartNode().equals(node2)) {
                        Assertions.assertTrue((boolean)outgoing.remove(rel));
                        continue;
                    }
                    Assertions.fail((String)("There should be no incoming relationships " + rel));
                }
            }
            Assertions.assertEquals((int)totalOneDirection, (int)rels.size());
            Assertions.assertEquals((int)0, (int)loops.size());
            Assertions.assertEquals((int)0, (int)outgoing.size());
            rels.clear();
            outgoing = new HashSet(outgoingOriginal);
            incoming = new HashSet(incomingOriginal);
            loops = new HashSet(loopsOriginal);
            relationships = node2.getRelationships(Direction.INCOMING);
            try {
                for (Relationship rel : relationships) {
                    Assertions.assertTrue((boolean)rels.add(rel));
                    if (rel.getStartNode().equals(node2) && rel.getEndNode().equals(node2)) {
                        Assertions.assertTrue((boolean)loops.remove(rel));
                        continue;
                    }
                    if (rel.getEndNode().equals(node2)) {
                        Assertions.assertTrue((boolean)incoming.remove(rel));
                        continue;
                    }
                    Assertions.fail((String)("There should be no outgoing relationships " + rel));
                }
            }
            finally {
                if (relationships != null) {
                    relationships.close();
                }
            }
            Assertions.assertEquals((int)totalOneDirection, (int)rels.size());
            Assertions.assertEquals((int)0, (int)loops.size());
            Assertions.assertEquals((int)0, (int)incoming.size());
            rels.clear();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

