/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexPopulationProgress;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class SchemaImplTest {
    private static final Label USER_LABEL = Label.label((String)"User");
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    SchemaImplTest() {
    }

    @BeforeEach
    void createDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)this.fs).build();
        this.db = this.managementService.database("neo4j");
    }

    @AfterEach
    void shutdownDb() {
        this.managementService.shutdown();
    }

    @Test
    void testGetIndexPopulationProgress() throws Exception {
        IndexDefinition indexDefinition;
        Schema schema;
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.indexExists(USER_LABEL));
        try (Transaction tx = this.db.beginTx();){
            Label label = Label.label((String)"User");
            for (int id = 0; id < 100000; ++id) {
                Node userNode = tx.createNode(new Label[]{label});
                userNode.setProperty("username", (Object)("user" + id + "@neo4j.org"));
            }
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            schema = tx.schema();
            indexDefinition = schema.indexFor(USER_LABEL).on("username").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IndexPopulationProgress progress;
            Schema.IndexState state;
            schema = tx.schema();
            do {
                state = schema.getIndexState(indexDefinition);
                progress = schema.getIndexPopulationProgress(indexDefinition);
                org.junit.jupiter.api.Assertions.assertTrue((progress.getCompletedPercentage() >= 0.0f ? 1 : 0) != 0);
                org.junit.jupiter.api.Assertions.assertTrue((progress.getCompletedPercentage() <= 100.0f ? 1 : 0) != 0);
                Thread.sleep(10L);
            } while (state == Schema.IndexState.POPULATING);
            org.junit.jupiter.api.Assertions.assertSame((Object)state, (Object)Schema.IndexState.ONLINE);
            org.junit.jupiter.api.Assertions.assertEquals((double)100.0, (double)progress.getCompletedPercentage(), (double)1.0E-4);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void createdIndexDefinitionsMustBeNamed() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = tx.schema().indexFor(USER_LABEL).on("name").create();
            Assertions.assertThat((String)index.getName()).isEqualTo("index_83617be8");
            tx.commit();
        }
    }

    @Test
    void mustRememberNamesOfCreatedIndex() {
        IndexDefinition index;
        String indexName = "Users index";
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(USER_LABEL).on("name").withName(indexName).create();
            Assertions.assertThat((String)index.getName()).isEqualTo(indexName);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(indexName);
            Assertions.assertThat((String)index.getName()).isEqualTo(indexName);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private boolean indexExists(Label label) {
        try (Transaction transaction = this.db.beginTx();){
            Iterable indexes = transaction.schema().getIndexes(label);
            IndexDefinition index = (IndexDefinition)Iterables.firstOrNull((Iterable)indexes);
            boolean exists = index != null;
            transaction.commit();
            boolean bl = exists;
            return bl;
        }
    }
}

